/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.IdManager;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.technology.Technology;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class TechId
implements Serializable {
    public static final TechId[] NULL_ARRAY = new TechId[0];
    public final IdManager idManager;
    public final String techName;
    public final int techIndex;

    TechId(IdManager idManager, String techName, int techIndex) {
        if (techName == null) {
            throw new NullPointerException();
        }
        if (TechId.legalTechnologyName(techName) != techName) {
            throw new IllegalArgumentException(techName);
        }
        this.idManager = idManager;
        this.techName = techName;
        this.techIndex = techIndex;
    }

    private Object writeReplace() {
        return new TechIdKey(this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("TechId");
    }

    public Technology inDatabase(EDatabase database) {
        return database.getTech(this);
    }

    public String toString() {
        return this.techName;
    }

    void check() {
        assert (this == this.idManager.getTechId(this.techIndex));
        assert (this.techName != null && TechId.legalTechnologyName(this.techName) == this.techName);
    }

    public static String legalTechnologyName(String techName) {
        char ch;
        int i;
        if (techName == null || techName.length() == 0) {
            return null;
        }
        for (i = 0; i < techName.length() && !Character.isWhitespace(ch = techName.charAt(i)) && ch != ':'; ++i) {
        }
        if (i == techName.length()) {
            return techName;
        }
        char[] chars = techName.toCharArray();
        while (i < techName.length()) {
            int ch2 = chars[i];
            chars[i] = Character.isWhitespace((char)ch2) || ch2 == 58 ? 45 : ch2;
            ++i;
        }
        return new String(chars);
    }

    private static class TechIdKey
    extends EObjectInputStream.Key {
        private final int techIndex;

        private TechIdKey(TechId techId) {
            this.techIndex = techId.techIndex;
        }

        protected Object readResolveInDatabase(EDatabase database) throws InvalidObjectException {
            return database.getIdManager().getTechId(this.techIndex);
        }
    }
}

