/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.HeadConnection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.TailConnection;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class ArcInst
extends Geometric
implements Comparable {
    public static final int TAILEND = 0;
    public static final int HEADEND = 1;
    public static final String ARC_NAME_TD;
    public static final Variable.Key ARC_NAME;
    public static final Variable.Key ARC_RADIUS;
    static final double MINPORTDISTANCE;
    private static final int FIXED = 1;
    private static final int FIXANG = 2;
    private static final int AANGLE = 16380;
    private static final int AANGLESH = 2;
    private static final int DISK_AANGLE = 16352;
    private static final int DISK_AANGLESH = 5;
    private static final int ISHEADNEGATED = 65536;
    private static final int DISK_NOEXTEND = 131072;
    private static final int ISTAILNEGATED = 262144;
    private static final int HEADARROW = 524288;
    private static final int DISK_ISDIRECTIONAL = 524288;
    private static final int TAILNOEXTEND = 0x100000;
    private static final int DISK_NOTEND0 = 0x100000;
    private static final int HEADNOEXTEND = 0x200000;
    private static final int DISK_NOTEND1 = 0x200000;
    private static final int DISK_REVERSEEND = 0x400000;
    private static final int CANTSLIDE = 0x800000;
    private static final int TAILARROW = 0x2000000;
    private static final int BODYARROW = 0x4000000;
    private static final int HARDSELECTA = Integer.MIN_VALUE;
    private static int COMMON_BITS;
    private static final int DATABASE_BITS;
    private static final Name BASENAME;
    private Name name;
    private int duplicate = -1;
    private ImmutableTextDescriptor nameDescriptor;
    private Rectangle2D visBounds;
    private int userBits;
    private int changeClock;
    private Undo.Change change;
    private double width;
    private double length;
    private ArcProto protoType;
    PortInst tailPortInst;
    EPoint tailLocation;
    byte tailShrink;
    private TailConnection tailEnd;
    PortInst headPortInst;
    EPoint headLocation;
    byte headShrink;
    private HeadConnection headEnd;
    private int arcIndex = -1;
    private static final int MAXARCPIECES = 16;
    private static int[] extendFactor;
    private static final int MAXANGLES = 3;
    private static int[] shortAngles;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ArcInst(Cell parent, ArcProto protoType, String name, int duplicate, ImmutableTextDescriptor nameDescriptor, PortInst headPort, PortInst tailPort, EPoint headPt, EPoint tailPt, double width, int userBits) {
        if (!$assertionsDisabled && parent != headPort.getNodeInst().getParent()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent != tailPort.getNodeInst().getParent()) {
            throw new AssertionError();
        }
        this.parent = parent;
        this.protoType = protoType;
        if (width < 0.0) {
            width = protoType.getWidth();
        }
        this.width = DBMath.round(width);
        this.name = Name.findName(name);
        this.duplicate = duplicate;
        if (nameDescriptor == null) {
            nameDescriptor = ImmutableTextDescriptor.getArcTextDescriptor();
        }
        this.nameDescriptor = nameDescriptor;
        this.tailPortInst = tailPort;
        this.tailLocation = tailPt;
        this.tailEnd = new TailConnection(this);
        this.headPortInst = headPort;
        this.headLocation = headPt;
        this.headEnd = new HeadConnection(this);
        this.userBits = userBits & DATABASE_BITS;
        this.visBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public static ArcInst makeInstance(ArcProto type, double width, PortInst head, PortInst tail) {
        ArcInst ai = ArcInst.newInstance(type, width, head, tail);
        if (ai != null) {
            ai.setDefaultConstraints();
        }
        return ai;
    }

    public static ArcInst makeInstance(ArcProto type, double width, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name) {
        ArcInst ai = ArcInst.newInstance(type, width, head, tail, headPt, tailPt, name, 0);
        if (ai != null) {
            ai.setDefaultConstraints();
        }
        return ai;
    }

    public static ArcInst makeDummyInstance(ArcProto ap, double arcLength) {
        PrimitiveNode npEnd = ap.findPinProto();
        if (npEnd == null) {
            System.out.println("Cannot find pin for " + ap);
            return null;
        }
        NodeInst niH = NodeInst.makeDummyInstance(npEnd, new EPoint(-arcLength / 2.0, 0.0), npEnd.getDefWidth(), npEnd.getDefHeight(), 0);
        PortInst piH = niH.getOnlyPortInst();
        Rectangle2D boundsH = piH.getBounds();
        double xH = boundsH.getCenterX();
        double yH = boundsH.getCenterY();
        NodeInst niT = NodeInst.makeDummyInstance(npEnd, new EPoint(arcLength / 2.0, 0.0), npEnd.getDefWidth(), npEnd.getDefHeight(), 0);
        PortInst piT = niT.getOnlyPortInst();
        Rectangle2D boundsT = piT.getBounds();
        double xT = boundsT.getCenterX();
        double yT = boundsT.getCenterY();
        ArcInst ai = new ArcInst(null, ap, "", 0, null, piH, piT, new EPoint(xH, yH), new EPoint(xT, yT), ap.getDefaultWidth(), 0);
        ai.updateGeometric();
        return ai;
    }

    public static ArcInst newInstance(ArcProto type, double width, PortInst head, PortInst tail) {
        return ArcInst.newInstance(type, width, head, tail, null, null, null, 0);
    }

    public static ArcInst newInstance(ArcProto type, double width, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name, int defAngle) {
        EPoint tailP;
        EPoint headP;
        if (headPt == null) {
            Rectangle2D headBounds = head.getBounds();
            headP = new EPoint(headBounds.getCenterX(), headBounds.getCenterY());
        } else {
            headP = EPoint.snap(headPt);
        }
        if (tailPt == null) {
            Rectangle2D tailBounds = tail.getBounds();
            tailP = new EPoint(tailBounds.getCenterX(), tailBounds.getCenterY());
        } else {
            tailP = EPoint.snap(tailPt);
        }
        Cell parent = head.getNodeInst().getParent();
        Poly headPoly = head.getPoly();
        if (!ArcInst.stillInPoly(headP, headPoly)) {
            System.out.println("Error in " + parent + ": head of " + type.getName() + " arc at (" + headP.getX() + "," + headP.getY() + ") does not fit in " + head + " which is centered at (" + headPoly.getCenterX() + "," + headPoly.getCenterY() + ")");
            return null;
        }
        Poly tailPoly = tail.getPoly();
        if (!ArcInst.stillInPoly(tailP, tailPoly)) {
            System.out.println("Error in " + parent + ": tail of " + type.getName() + " arc at (" + tailP.getX() + "," + tailP.getY() + ") does not fit in " + tail + " which is centered at (" + tailPoly.getCenterX() + "," + tailPoly.getCenterY() + ")");
            return null;
        }
        if ((defAngle %= 3600) < 0) {
            defAngle += 3600;
        }
        return ArcInst.newInstance(parent, type, name, -1, null, head, tail, headP, tailP, width, defAngle << 2);
    }

    public static ArcInst newInstance(Cell parent, ArcProto protoType, String name, int duplicate, ImmutableTextDescriptor nameDescriptor, PortInst headPort, PortInst tailPort, EPoint headPt, EPoint tailPt, double width, int userBits) {
        if (protoType == null || headPort == null || tailPort == null || !headPort.isLinked() || !tailPort.isLinked()) {
            return null;
        }
        if (headPt == null || tailPt == null) {
            return null;
        }
        if (parent != headPort.getNodeInst().getParent() || parent != tailPort.getNodeInst().getParent()) {
            System.out.println("ArcProto.newInst: the 2 PortInsts are in different Cells!");
            return null;
        }
        PortProto headProto = headPort.getPortProto();
        PrimitivePort headPrimPort = headProto.getBasePort();
        if (!headPrimPort.connectsTo(protoType)) {
            System.out.println("Cannot create " + protoType + " in " + parent + " because it cannot connect to port " + headProto.getName());
            return null;
        }
        PortProto tailProto = tailPort.getPortProto();
        PrimitivePort tailPrimPort = tailProto.getBasePort();
        if (!tailPrimPort.connectsTo(protoType)) {
            System.out.println("Cannot create " + protoType + " in " + parent + " because it cannot connect to port " + tailProto.getName());
            return null;
        }
        ArcInst ai = new ArcInst(parent, protoType, name, duplicate, nameDescriptor, headPort, tailPort, headPt, tailPt, width, userBits);
        if (ai == null) {
            return null;
        }
        ai.lowLevelLink();
        Undo.newObject(ai);
        return ai;
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("ArcInst already killed");
            return;
        }
        this.lowLevelUnlink();
        Undo.killObject(this);
    }

    public void modify(double dWidth, double dHeadX, double dHeadY, double dTailX, double dTailY) {
        double oldxA = this.headLocation.getX();
        double oldyA = this.headLocation.getY();
        double oldxB = this.tailLocation.getX();
        double oldyB = this.tailLocation.getY();
        double oldWidth = this.getWidth();
        this.lowLevelModify(dWidth, dHeadX, dHeadY, dTailX, dTailY);
        Undo.modifyArcInst(this, oldxA, oldyA, oldxB, oldyB, oldWidth);
    }

    public ArcInst replace(ArcProto ap) {
        if (!this.headPortInst.getPortProto().connectsTo(ap) || !this.tailPortInst.getPortProto().connectsTo(ap)) {
            System.out.println("Cannot replace " + this + " with one of type " + ap.getName() + " because the nodes cannot connect to it");
            return null;
        }
        double newwid = this.getWidth() - this.getProto().getWidthOffset() + ap.getWidthOffset();
        ArcInst newar = ArcInst.newInstance(ap, newwid, this.headPortInst, this.tailPortInst, this.headLocation, this.tailLocation, null, 0);
        if (newar == null) {
            System.out.println("Cannot replace " + this + " with one of type " + ap.getName() + " because the new arc failed to create");
            return null;
        }
        newar.copyPropertiesFrom(this);
        this.kill();
        newar.setName(this.getName());
        return newar;
    }

    public void lowLevelLink() {
        if (!this.isUsernamed() && (this.name == null || !this.parent.isUniqueName(this.name, this.getClass(), (ElectricObject)this)) || ArcInst.checkNameKey(this.name, this.parent, false)) {
            this.name = this.parent.getAutoname(BASENAME);
            this.duplicate = 0;
        }
        this.headPortInst.getNodeInst().addConnection(this.headEnd);
        this.tailPortInst.getNodeInst().addConnection(this.tailEnd);
        ArcInst.updateShrinkage(this.headPortInst.getNodeInst());
        ArcInst.updateShrinkage(this.tailPortInst.getNodeInst());
        this.updateGeometric();
        this.duplicate = this.parent.addArc(this);
        this.parent.linkArc(this);
    }

    public void lowLevelUnlink() {
        this.headPortInst.getNodeInst().removeConnection(this.headEnd);
        this.tailPortInst.getNodeInst().removeConnection(this.tailEnd);
        this.parent.removeArc(this);
        this.parent.unLinkArc(this);
        ArcInst.updateShrinkage(this.headPortInst.getNodeInst());
        ArcInst.updateShrinkage(this.tailPortInst.getNodeInst());
        this.parent.checkInvariants();
    }

    public void lowLevelModify(double dWidth, double dHeadX, double dHeadY, double dTailX, double dTailY) {
        this.parent.unLinkArc(this);
        this.width = DBMath.round(this.width + dWidth);
        if (dHeadX != 0.0 || dHeadY != 0.0) {
            this.headLocation = new EPoint(this.headLocation.getX() + dHeadX, this.headLocation.getY() + dHeadY);
        }
        if (dTailX != 0.0 || dTailY != 0.0) {
            this.tailLocation = new EPoint(this.tailLocation.getX() + dTailX, this.tailLocation.getY() + dTailY);
        }
        this.updateGeometric();
        ArcInst.updateShrinkage(this.headPortInst.getNodeInst());
        ArcInst.updateShrinkage(this.tailPortInst.getNodeInst());
        this.parent.linkArc(this);
    }

    public double getWidth() {
        return this.width;
    }

    public double getLength() {
        return this.length;
    }

    public int getAngle() {
        return (this.userBits & 0x3FFC) >> 2;
    }

    public void setAngle(int angle) {
        this.checkChanging();
        if (!this.tailLocation.equals(this.headLocation)) {
            return;
        }
        this.lowLevelSetAngle(angle);
        Undo.otherChange(this);
    }

    private void lowLevelSetAngle(int angle) {
        if ((angle %= 3600) < 0) {
            angle += 3600;
        }
        if (!($assertionsDisabled || 0 <= angle && angle < 3600)) {
            throw new AssertionError();
        }
        this.userBits = this.userBits & 0xFFFFC003 | angle << 2;
    }

    public Rectangle2D getBounds() {
        return this.visBounds;
    }

    public Poly makePoly(double length, double width, Poly.Type style) {
        Poly poly;
        Poly curvedPoly;
        Double radiusDouble;
        if (this.protoType.isCurvable() && (radiusDouble = this.getRadius()) != null && (curvedPoly = this.curvedArcOutline(style, width, radiusDouble)) != null) {
            return curvedPoly;
        }
        if (width == 0.0) {
            Poly poly2 = new Poly(new Point2D.Double[]{this.headLocation.mutable(), this.tailLocation.mutable()});
            if (style == Poly.Type.FILLED) {
                style = Poly.Type.OPENED;
            }
            poly2.setStyle(style);
            return poly2;
        }
        double extendH = 0.0;
        if (this.isHeadExtended()) {
            extendH = width / 2.0;
            if (this.headShrink != 0) {
                extendH = ArcInst.getExtendFactor(width, this.headShrink);
            }
        }
        double extendT = 0.0;
        if (this.isTailExtended()) {
            extendT = width / 2.0;
            if (this.tailShrink != 0) {
                extendT = ArcInst.getExtendFactor(width, this.tailShrink);
            }
        }
        if ((poly = Poly.makeEndPointPoly(length, width, this.getAngle(), this.headLocation, extendH, this.tailLocation, extendT)) != null) {
            poly.setStyle(style);
        }
        return poly;
    }

    public Double getRadius() {
        Variable var = this.getVar(ARC_RADIUS);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (obj instanceof Integer) {
            return new Double((double)((Integer)obj).intValue() / 2000.0);
        }
        if (obj instanceof Double) {
            return new Double((Double)obj);
        }
        return null;
    }

    public Poly curvedArcOutline(Poly.Type style, double wid, double radius) {
        int pieces;
        double length;
        double pureRadius = Math.abs(radius);
        if (pureRadius * 2.0 < (length = this.tailLocation.distance(this.headLocation))) {
            return null;
        }
        Point2D[] centers = DBMath.findCenters(pureRadius, this.headLocation, this.tailLocation, length);
        if (centers == null) {
            return null;
        }
        Point2D centerPt = centers[1];
        if (radius < 0.0) {
            radius = -radius;
            centerPt = centers[0];
        }
        int angleBase = DBMath.figureAngle(centerPt, this.headLocation);
        int angleRange = DBMath.figureAngle(centerPt, this.tailLocation);
        if ((angleRange -= angleBase) < 0) {
            angleRange += 3600;
        }
        for (pieces = angleRange; pieces > 16; pieces /= 2) {
        }
        if (pieces == 0) {
            return null;
        }
        int points = (pieces + 1) * 2;
        Point2D[] pointArray = new Point2D[points];
        double outerRadius = radius + wid / 2.0;
        double innerRadius = outerRadius - wid;
        for (int i = 0; i <= pieces; ++i) {
            int a = (angleBase + i * angleRange / pieces) % 3600;
            double sin = DBMath.sin(a);
            double cos = DBMath.cos(a);
            pointArray[i] = new Point2D.Double(cos * innerRadius + centerPt.getX(), sin * innerRadius + centerPt.getY());
            pointArray[points - 1 - i] = new Point2D.Double(cos * outerRadius + centerPt.getX(), sin * outerRadius + centerPt.getY());
        }
        Poly poly = new Poly(pointArray);
        poly.setStyle(style);
        return poly;
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow wnd) {
        int dispVars = this.numDisplayableVariables(false);
        int totalText = dispVars;
        if (totalText == 0) {
            return null;
        }
        Poly[] polys = new Poly[totalText];
        this.addDisplayableVariables(this.getBounds(), polys, 0, wnd, false);
        return polys;
    }

    public static double getExtendFactor(double width, int extend) {
        if (extend <= 0) {
            return width / 2.0;
        }
        if (extend > 90) {
            return width / 2.0;
        }
        return width * 50.0 / (double)extendFactor[extend];
    }

    private static void updateShrinkage(NodeInst ni) {
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            byte shrink = ArcInst.checkShortening(ni, con.getPortInst().getPortProto());
            con.setEndShrink(shrink);
        }
    }

    private static byte checkShortening(NodeInst ni, PortProto pp) {
        NodeProto np = ni.getProto();
        if (!(np instanceof PrimitiveNode)) {
            return 0;
        }
        PrimitiveNode pn = (PrimitiveNode)np;
        if (!pn.canShrink() && !pn.isArcsShrink()) {
            return 0;
        }
        int total = 0;
        int off90 = 0;
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            if (ai.getWidth() == 0.0 || !pn.isArcsShrink() && con.getPortInst().getPortProto() != pp) continue;
            int ang = ai.getAngle() / 10;
            if (con.getEndIndex() == 1) {
                ang += 180;
            }
            if ((ang %= 360) % 90 != 0) {
                ++off90;
            }
            if (total >= 3) break;
            ArcInst.shortAngles[total++] = ang;
        }
        if (pn.canShrink()) {
            PrimitivePort pRp = (PrimitivePort)pp;
            int ang = pRp.getAngle();
            ang += (ni.getAngle() + 5) / 10;
            if ((ang = (ang + 180) % 360) % 90 != 0) {
                ++off90;
            }
            if (total < 3) {
                ArcInst.shortAngles[total++] = ang;
            }
        }
        if (off90 == 0) {
            return 0;
        }
        if (total != 2) {
            return 0;
        }
        int ang = Math.abs(shortAngles[1] - shortAngles[0]);
        if (ang > 180) {
            ang = 360 - ang;
        }
        if (ang > 90) {
            ang = 180 - ang;
        }
        return (byte)ang;
    }

    private void updateGeometric() {
        this.checkChanging();
        if (this.tailLocation.equals(this.headLocation)) {
            this.length = 0.0;
        } else {
            this.length = this.tailLocation.distance(this.headLocation);
            this.lowLevelSetAngle(DBMath.figureAngle(this.tailLocation, this.headLocation));
        }
        Poly poly = this.makePoly(this.length, this.width, Poly.Type.FILLED);
        this.visBounds.setRect(poly.getBounds2D());
        if (this.parent != null) {
            this.parent.setDirty();
        }
    }

    public TailConnection getTail() {
        return this.tailEnd;
    }

    public HeadConnection getHead() {
        return this.headEnd;
    }

    public Connection getConnection(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.tailEnd;
            }
            case 1: {
                return this.headEnd;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public PortInst getTailPortInst() {
        return this.tailPortInst;
    }

    public PortInst getHeadPortInst() {
        return this.headPortInst;
    }

    public PortInst getPortInst(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.tailPortInst;
            }
            case 1: {
                return this.headPortInst;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public EPoint getTailLocation() {
        return this.tailLocation;
    }

    public EPoint getHeadLocation() {
        return this.headLocation;
    }

    public EPoint getLocation(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.tailLocation;
            }
            case 1: {
                return this.headLocation;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean tailStillInPort(Point2D pt, boolean reduceForArc) {
        return this.stillInPort(0, pt, reduceForArc);
    }

    public boolean headStillInPort(Point2D pt, boolean reduceForArc) {
        return this.stillInPort(1, pt, reduceForArc);
    }

    public boolean stillInPort(int connIndex, Point2D pt, boolean reduceForArc) {
        PortInst pi = this.getPortInst(connIndex);
        Poly poly = pi.getPoly();
        if (reduceForArc) {
            double wid = this.getWidth() - this.getProto().getWidthOffset();
            poly.reducePortPoly(pi, wid, this.getAngle());
        }
        return ArcInst.stillInPoly(pt, poly);
    }

    private static boolean stillInPoly(Point2D pt, Poly poly) {
        return poly.isInside(pt) || poly.polyDistance(pt.getX(), pt.getY()) < MINPORTDISTANCE;
    }

    public Name getNameKey() {
        return this.name;
    }

    public void lowLevelRename(Name name, int duplicate) {
        this.parent.removeArc(this);
        this.name = name;
        this.duplicate = duplicate;
        this.duplicate = this.parent.addArc(this);
        this.parent.checkInvariants();
    }

    public int getDuplicate() {
        return this.duplicate;
    }

    public ImmutableTextDescriptor getTextDescriptor(String varName) {
        if (varName == ARC_NAME_TD) {
            return this.nameDescriptor;
        }
        return super.getTextDescriptor(varName);
    }

    public ImmutableTextDescriptor lowLevelSetTextDescriptor(String varName, ImmutableTextDescriptor td) {
        if (varName == ARC_NAME_TD) {
            ImmutableTextDescriptor oldDescriptor = this.nameDescriptor;
            this.nameDescriptor = td.withDisplayWithoutParamAndCode();
            return oldDescriptor;
        }
        return super.lowLevelSetTextDescriptor(varName, td);
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        if (key == ARC_NAME) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    public String describe(boolean withQuotes) {
        String name;
        String description = this.protoType.describe();
        String string = name = withQuotes ? "'" + this.getName() + "'" : this.getName();
        if (name != null) {
            description = description + "[" + name + "]";
        }
        return description;
    }

    public int compareTo(Object obj) {
        int cmp;
        ArcInst that = (ArcInst)obj;
        if (this.parent != that.parent && (cmp = this.parent.compareTo(that.parent)) != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(that.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.duplicate - that.duplicate;
    }

    public String toString() {
        if (this.protoType == null) {
            return "ArcInst null protoType";
        }
        return "arc " + this.describe(true);
    }

    public void setRigid(boolean state) {
        this.userBits = state ? (this.userBits |= 1) : (this.userBits &= 0xFFFFFFFE);
        Undo.otherChange(this);
    }

    public boolean isRigid() {
        return (this.userBits & 1) != 0;
    }

    public void setFixedAngle(boolean state) {
        this.userBits = state ? (this.userBits |= 2) : (this.userBits &= 0xFFFFFFFD);
        Undo.otherChange(this);
    }

    public boolean isFixedAngle() {
        return (this.userBits & 2) != 0;
    }

    public void setSlidable(boolean state) {
        this.userBits = state ? (this.userBits &= 0xFF7FFFFF) : (this.userBits |= 0x800000);
        Undo.otherChange(this);
    }

    public boolean isSlidable() {
        return (this.userBits & 0x800000) == 0;
    }

    public boolean isArrowed(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.isTailArrowed();
            }
            case 1: {
                return this.isHeadArrowed();
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean isTailArrowed() {
        return (this.userBits & 0x2000000) != 0;
    }

    public boolean isHeadArrowed() {
        return (this.userBits & 0x80000) != 0;
    }

    public boolean isBodyArrowed() {
        return (this.userBits & 0x4000000) != 0;
    }

    public void setArrowed(int connIndex, boolean state) {
        switch (connIndex) {
            case 0: {
                this.setTailArrowed(state);
                break;
            }
            case 1: {
                this.setHeadArrowed(state);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailArrowed(boolean state) {
        this.checkChanging();
        this.userBits = state ? (this.userBits |= 0x2000000) : (this.userBits &= 0xFDFFFFFF);
        Undo.otherChange(this);
    }

    public void setHeadArrowed(boolean state) {
        this.checkChanging();
        this.userBits = state ? (this.userBits |= 0x80000) : (this.userBits &= 0xFFF7FFFF);
        Undo.otherChange(this);
    }

    public void setBodyArrowed(boolean state) {
        this.checkChanging();
        this.userBits = state ? (this.userBits |= 0x4000000) : (this.userBits &= 0xFBFFFFFF);
        Undo.otherChange(this);
    }

    public boolean isExtended(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.isTailExtended();
            }
            case 1: {
                return this.isHeadExtended();
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean isTailExtended() {
        return (this.userBits & 0x100000) == 0;
    }

    public boolean isHeadExtended() {
        return (this.userBits & 0x200000) == 0;
    }

    public void setExtended(int connIndex, boolean e) {
        switch (connIndex) {
            case 0: {
                this.setTailExtended(e);
                break;
            }
            case 1: {
                this.setHeadExtended(e);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailExtended(boolean e) {
        this.checkChanging();
        this.userBits = e ? (this.userBits &= 0xFFEFFFFF) : (this.userBits |= 0x100000);
        if (this.isLinked()) {
            this.updateGeometric();
        }
        Undo.otherChange(this);
    }

    public void setHeadExtended(boolean e) {
        this.checkChanging();
        this.userBits = e ? (this.userBits &= 0xFFDFFFFF) : (this.userBits |= 0x200000);
        if (this.isLinked()) {
            this.updateGeometric();
        }
        Undo.otherChange(this);
    }

    public boolean isNegated(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.isTailNegated();
            }
            case 1: {
                return this.isHeadNegated();
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean isTailNegated() {
        return (this.userBits & 0x40000) != 0;
    }

    public boolean isHeadNegated() {
        return (this.userBits & 0x10000) != 0;
    }

    public void setNegated(int connIndex, boolean n) {
        switch (connIndex) {
            case 0: {
                this.setTailNegated(n);
                break;
            }
            case 1: {
                this.setHeadNegated(n);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailNegated(boolean n) {
        this.checkChanging();
        this.userBits = n ? (this.userBits |= 0x40000) : (this.userBits &= 0xFFFBFFFF);
        Undo.otherChange(this);
    }

    public void setHeadNegated(boolean n) {
        this.checkChanging();
        this.userBits = n ? (this.userBits |= 0x10000) : (this.userBits &= 0xFFFEFFFF);
        Undo.otherChange(this);
    }

    public static int fromElibBits(int bits) {
        int newBits = bits & COMMON_BITS;
        if ((bits & 0x40000) != 0) {
            newBits |= (bits & 0x400000) == 0 ? 262144 : 65536;
        }
        if ((bits & 0x10000) != 0) {
            newBits |= (bits & 0x400000) == 0 ? 65536 : 262144;
        }
        if ((bits & 0x20000) != 0) {
            if ((bits & 0x100000) == 0) {
                newBits |= 0x100000;
            }
            if ((bits & 0x200000) == 0) {
                newBits |= 0x200000;
            }
        }
        if ((bits & 0x80000) != 0) {
            newBits |= 0x4000000;
            if ((bits & 0x400000) == 0) {
                if ((bits & 0x200000) == 0) {
                    newBits |= 0x80000;
                }
            } else if ((bits & 0x100000) == 0) {
                newBits |= 0x2000000;
            }
        }
        int angle = (bits & 0x3FE0) >> 5;
        angle = angle % 360 * 10;
        return newBits |= angle << 2;
    }

    public int makeELIBArcBits() {
        int angle;
        boolean normalEnd;
        int diskBits = this.userBits & COMMON_BITS;
        if (!this.isHeadExtended() || !this.isTailExtended()) {
            diskBits |= 0x20000;
            if (this.isHeadExtended() != this.isTailExtended()) {
                if (this.isTailExtended()) {
                    diskBits |= 0x100000;
                }
                if (this.isHeadExtended()) {
                    diskBits |= 0x200000;
                }
            }
        }
        if (this.isHeadArrowed() || this.isTailArrowed() || this.isBodyArrowed()) {
            diskBits |= 0x80000;
            if (this.isTailArrowed()) {
                diskBits |= 0x400000;
            }
            if (!this.isHeadArrowed() && !this.isTailArrowed()) {
                diskBits |= 0x200000;
            }
        }
        boolean bl = normalEnd = (diskBits & 0x400000) == 0;
        if (this.isTailNegated()) {
            diskBits |= normalEnd ? 262144 : 65536;
        }
        if (this.isHeadNegated()) {
            diskBits |= normalEnd ? 65536 : 262144;
        }
        if ((angle = (int)((double)this.getAngle() / 10.0 + 0.5)) >= 360) {
            angle -= 360;
        }
        return diskBits |= angle << 5;
    }

    public int checkAndRepair(boolean repair, ErrorLogger errorLogger) {
        ErrorLogger.MessageLog error;
        String msg;
        Poly poly;
        int errorCount = 0;
        if (!this.headStillInPort(this.headLocation, false)) {
            poly = this.headPortInst.getPoly();
            msg = this.parent + ", " + this + ": head not in port, is at (" + this.headLocation.getX() + "," + this.headLocation.getY() + ") distance to port is " + poly.polyDistance(this.headLocation.getX(), this.headLocation.getY()) + " port center is (" + poly.getCenterX() + "," + poly.getCenterY() + ")";
            System.out.println(msg);
            if (errorLogger != null) {
                error = errorLogger.logError(msg, this.parent, 1);
                error.addGeom(this, true, this.parent, null);
                error.addGeom(this.headPortInst.getNodeInst(), true, this.parent, null);
            }
            if (repair) {
                this.headLocation = new EPoint(poly.getCenterX(), poly.getCenterY());
                this.updateGeometric();
            }
            ++errorCount;
        }
        if (!this.tailStillInPort(this.tailLocation, false)) {
            poly = this.tailPortInst.getPoly();
            msg = this.parent + ", " + this + ": tail not in port, is at (" + this.tailLocation.getX() + "," + this.tailLocation.getY() + ") distance to port is " + poly.polyDistance(this.tailLocation.getX(), this.tailLocation.getY()) + " port center is (" + poly.getCenterX() + "," + poly.getCenterY() + ")";
            System.out.println(msg);
            if (errorLogger != null) {
                error = errorLogger.logError(msg, this.parent, 1);
                error.addGeom(this, true, this.parent, null);
                error.addGeom(this.tailPortInst.getNodeInst(), true, this.parent, null);
            }
            if (repair) {
                this.tailLocation = new EPoint(poly.getCenterX(), poly.getCenterY());
                this.updateGeometric();
            }
            ++errorCount;
        }
        if (this.getWidth() < 0.0) {
            String msg2 = this.parent + ", " + this + ": has negative width (" + this.getWidth() + ")";
            System.out.println(msg2);
            if (errorLogger != null) {
                ErrorLogger.MessageLog error2 = errorLogger.logError(msg2, this.parent, 1);
                error2.addGeom(this, true, this.parent, null);
            }
            if (repair) {
                this.checkChanging();
                this.width = DBMath.round(Math.abs(this.width));
            }
            ++errorCount;
        }
        return errorCount;
    }

    public void check() {
        if (!$assertionsDisabled && this.name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.duplicate < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.headEnd.getArc() != this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.tailEnd.getArc() != this) {
            throw new AssertionError();
        }
    }

    public void setArcIndex(int arcIndex) {
        this.arcIndex = arcIndex;
    }

    public final int getArcIndex() {
        return this.arcIndex;
    }

    public boolean isLinked() {
        try {
            return this.parent != null && this.parent.isLinked() && this.parent.getArc(this.arcIndex) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public Name getBasename() {
        return BASENAME;
    }

    public ArcProto getProto() {
        return this.protoType;
    }

    public void copyPropertiesFrom(ArcInst fromAi) {
        if (fromAi == null) {
            return;
        }
        this.copyVarsFrom(fromAi);
        this.copyConstraintsFrom(fromAi);
        this.copyTextDescriptorFrom(fromAi, ARC_NAME_TD);
    }

    public void copyConstraintsFrom(ArcInst fromAi) {
        this.checkChanging();
        if (fromAi == null) {
            return;
        }
        int newBits = this.tailLocation.equals(this.headLocation) ? fromAi.userBits : fromAi.userBits & 0xFFFFC003 | this.userBits & 0x3FFC;
        boolean extensionChanged = (this.userBits & 0x300000) != ((newBits &= DATABASE_BITS) & 0x300000);
        this.userBits = newBits;
        if (this.isLinked() && extensionChanged) {
            this.updateGeometric();
        }
        Undo.otherChange(this);
    }

    private void setDefaultConstraints() {
        this.setRigid(this.protoType.isRigid());
        this.setFixedAngle(this.protoType.isFixedAngle());
        this.setSlidable(this.protoType.isSlidable());
        this.setHeadExtended(this.protoType.isExtended());
        this.setTailExtended(this.protoType.isExtended());
        this.setHeadArrowed(this.protoType.isDirectional());
        this.setBodyArrowed(this.protoType.isDirectional());
    }

    public void setHardSelect(boolean state) {
        this.checkChanging();
        this.userBits = state ? (this.userBits |= Integer.MIN_VALUE) : (this.userBits &= Integer.MAX_VALUE);
        Undo.otherChange(this);
    }

    public boolean isHardSelect() {
        return (this.userBits & Integer.MIN_VALUE) != 0;
    }

    public void setChangeClock(int changeClock) {
        this.changeClock = changeClock;
    }

    public int getChangeClock() {
        return this.changeClock;
    }

    public void setChange(Undo.Change change) {
        this.change = change;
    }

    public Undo.Change getChange() {
        return this.change;
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Poly[] aPolyList;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArcInst a = (ArcInst)obj;
        if (this.protoType.getClass() != a.getProto().getClass()) {
            return false;
        }
        ArcProto arcType = a.getProto();
        Technology tech = arcType.getTechnology();
        if (this.getProto().getTechnology() != tech) {
            if (buffer != null) {
                buffer.append("No same technology for arcs " + this.getName() + " and " + a.getName() + "\n");
            }
            return false;
        }
        Poly[] polyList = this.getProto().getTechnology().getShapeOfArc(this);
        if (polyList.length != (aPolyList = tech.getShapeOfArc(a)).length) {
            if (buffer != null) {
                buffer.append("No same number of geometries in " + this.getName() + " and " + a.getName() + "\n");
            }
            return false;
        }
        ArrayList<Poly> noCheckAgain = new ArrayList<Poly>();
        for (int i = 0; i < polyList.length; ++i) {
            boolean found = false;
            for (int j = 0; j < aPolyList.length; ++j) {
                if (noCheckAgain.contains(aPolyList[j]) || !polyList[i].compare(aPolyList[j], buffer)) continue;
                found = true;
                noCheckAgain.add(aPolyList[j]);
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Poly cropPerLayer(Poly poly) {
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null) {
            return poly;
        }
        polyBounds = new Rectangle2D.Double(polyBounds.getMinX(), polyBounds.getMinY(), polyBounds.getWidth(), polyBounds.getHeight());
        for (int i = 0; i < 2; ++i) {
            PortInst pi = this.getPortInst(i);
            NodeInst ni = pi.getNodeInst();
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] activeCropPolyList = tech.getShapeOfNode(ni);
            int nTot = activeCropPolyList.length;
            for (int k = 0; k < nTot; ++k) {
                Poly nPoly = activeCropPolyList[k];
                if (nPoly.getLayer() != poly.getLayer()) continue;
                nPoly.transform(trans);
                Rectangle2D nPolyBounds = nPoly.getBox();
                if (nPolyBounds == null) continue;
                int result = Poly.cropBoxComplete(polyBounds, nPolyBounds, true);
                if (result == 1) {
                    return null;
                }
                if (result == -2) {
                    System.out.println("When is this case?");
                }
                Poly newPoly = new Poly(polyBounds);
                newPoly.setLayer(poly.getLayer());
                newPoly.setStyle(poly.getStyle());
                return newPoly;
            }
        }
        return poly;
    }

    public boolean isDiffusionArc() {
        return this.getProto().getFunction().isDiffusion();
    }

    static {
        $assertionsDisabled = !ArcInst.class.desiredAssertionStatus();
        ARC_NAME_TD = new String("ARC_name");
        ARC_NAME = ElectricObject.newKey("ARC_name");
        ARC_RADIUS = ElectricObject.newKey("ARC_radius");
        MINPORTDISTANCE = DBMath.getEpsilon() * 0.71;
        COMMON_BITS = -2139095037;
        DATABASE_BITS = COMMON_BITS | 0x3FFC | 0x4000000 | 0x40000 | 0x100000 | 0x2000000 | 0x10000 | 0x200000 | 0x80000;
        BASENAME = Name.findName("net@");
        extendFactor = new int[]{0, 11459, 5729, 3819, 2864, 2290, 1908, 1635, 1430, 1271, 1143, 1039, 951, 878, 814, 760, 712, 669, 631, 598, 567, 540, 514, 492, 470, 451, 433, 417, 401, 387, 373, 361, 349, 338, 327, 317, 308, 299, 290, 282, 275, 267, 261, 254, 248, 241, 236, 230, 225, 219, 214, 210, 205, 201, 196, 192, 188, 184, 180, 177, 173, 170, 166, 163, 160, 157, 154, 151, 148, 146, 143, 140, 138, 135, 133, 130, 128, 126, 123, 121, 119, 117, 115, 113, 111, 109, 107, 105, 104, 102, 100};
        shortAngles = new int[3];
    }
}

