/* -*- tab-width: 4 -*-
 *
 * Electric(tm) VLSI Design System
 *
 * File: AStarClosedListBase.java
 * Written by: Christian Harnisch, Ingo Besenfelder, Michael Neumann (Team 3)
 *
 * Copyright (c) 2010, Static Free Software. All rights reserved.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sun.electric.tool.routing.experimentalAStar2.algorithm;

public interface AStarClosedListBase<T extends AStarNodeBase<T>>
{
  /**
   * Marks a node as been visited and expanded, which means that his neighbour
   * nodes have been added to the open list.
   * 
   * @param node The node to add.
   */
  public void addNodeToClosedList(T node);

  /**
   * If contained in the list of visited and expanded nodes, the given node is
   * removed. Otherwise, the list remains unchanged.
   * 
   * @param node The node to be removed.
   */
  public void removeNodeFromClosedList(T node);

  /**
   * If this position has already been visited by the A* search, and its nodes
   * neighbours have been added to the open list, this method returns the node
   * associated with the given position.
   * 
   * @param x X-position of the map to be checked.
   * @param y Y-position of the map to be checked.
   * @param z Z-position of the map to be checked.
   * 
   * @return A node if one was found, <code>null</code> otherwise.
   */
  public T findClosedNode(int x, int y, int z);

  /**
   * Removes all nodes from the closed list.
   */
  public void clearClosedList();
}
