/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (functions.h)
 *  
 *  It has been AutoGen-ed  Sunday November 16, 2008 at 04:04:00 PM PST
 *  From the definitions    functions.def
 *  and the template file   functions.tpl
 *
 *  Tables of Text Functions for AutoGen
 *
 *  copyright 1992-1999 Bruce Korb
 *
 *  AutoGen is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  AutoGen is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  The 21 AutoGen functions are tagged with special attributes:
 *
 *  A - is invoked via an alias
 *
 *  U - is unnamed.  May *not* be explicitly invoked.  May not have
 *      have an alias.  These three are used by AutoGen for its purposes.
 *
 *  L - has a special load procedure defined
 *
 *  C - in context.  May be explicitly invoked in certain situations.
 *      For example, "ELSE" may only be specified within an "IF" block.
 *      Their load procedures are enabled by the block macro (e.g. IF),
 *      and disabled by the block ending macro (e.g. ENDIF).
 *      While disabled, the load procedure is the "Bogus" method.
 *
 *      If a function is neither has a special load procedure nor is
 *      situational, then the "Unknown" load method is applied.
 *
 *  R - has a special remove (unload) procedure
 *
 *  H - has a handler procedure defined.  Only these procedures should
 *      be encountered by the dispatcher during processing.
 *
 *  U L  H - BOGUS       Out-of-context or unknown functions are bogus.
 *    L  H - CASE        Select one of several template blocks
 *  A L    - COMMENT     A block of comment to be ignored
 *    L  H - DEBUG       Print debug message to trace output
 *    L RH - DEFINE      Define a user AutoGen macro
 *    C    - ELIF        Alternate Conditional Template Block
 *    C    - ELSE        Alternate Template Block
 *    C    - ENDDEF      Ends a macro definition.
 *    C    - ENDFOR      Terminates the @code{FOR} function template block
 *    C    - ENDIF       Terminate the @code{IF} Template Block
 *    C    - ENDWHILE    Terminate the @code{WHILE} Template Block
 *    C    - ESAC        Terminate the @code{CASE} Template Block
 *  A L  H - EXPR        Evaluate and emit an Expression
 *    L  H - FOR         Emit a template block multiple times
 *    L  H - IF          Conditionally Emit a Template Block
 *    L  H - INCLUDE     Read in and emit a template block
 *       H - INVOKE      Invoke a User Defined Macro
 *  A C R  - SELECT      Selection block for CASE function
 *  U    H - TEXT        A block of text to be emitted.
 *  U L  H - UNKNOWN     Either a user macro or a value name.
 *    L  H - WHILE       Conditionally loop over a Template Block
 */
#ifndef AUTOGEN_FUNCTIONS_H_GUARD
#define AUTOGEN_FUNCTIONS_H_GUARD 1

#define FUNC_CT    21

extern char const * const apzFuncNames[ FUNC_CT ];

/*
 *  Enumerate all the function types, whether they have
 *  implementation functions or not.
 */
typedef enum {
    FTYP_BOGUS,        /* Out-of-context or unknown functions are bogus. */
    FTYP_CASE,         /* Select one of several template blocks */
    FTYP_COMMENT,      /* A block of comment to be ignored */
    FTYP_DEBUG,        /* Print debug message to trace output */
    FTYP_DEFINE,       /* Define a user AutoGen macro */
    FTYP_ELIF,         /* Alternate Conditional Template Block */
    FTYP_ELSE,         /* Alternate Template Block */
    FTYP_ENDDEF,       /* Ends a macro definition. */
    FTYP_ENDFOR,       /* Terminates the @code{FOR} function template block */
    FTYP_ENDIF,        /* Terminate the @code{IF} Template Block */
    FTYP_ENDWHILE,     /* Terminate the @code{WHILE} Template Block */
    FTYP_ESAC,         /* Terminate the @code{CASE} Template Block */
    FTYP_EXPR,         /* Evaluate and emit an Expression */
    FTYP_FOR,          /* Emit a template block multiple times */
    FTYP_IF,           /* Conditionally Emit a Template Block */
    FTYP_INCLUDE,      /* Read in and emit a template block */
    FTYP_INVOKE,       /* Invoke a User Defined Macro */
    FTYP_SELECT,       /* Selection block for CASE function */
    FTYP_TEXT,         /* A block of text to be emitted. */
    FTYP_UNKNOWN,      /* Either a user macro or a value name. */
    FTYP_WHILE,        /* Conditionally loop over a Template Block */

    FTYP_SELECT_COMPARE_FULL          = 0x8000,  /* *==* */
    FTYP_SELECT_COMPARE_SKP_START     = 0x8001,  /* *==  */
    FTYP_SELECT_COMPARE_SKP_END       = 0x8002,  /*  ==* */
    FTYP_SELECT_COMPARE               = 0x8003,  /*  ==  */

    FTYP_SELECT_EQUIVALENT_FULL       = 0x8004,  /* *=*  */
    FTYP_SELECT_EQUIVALENT_SKP_START  = 0x8005,  /* *=   */
    FTYP_SELECT_EQUIVALENT_SKP_END    = 0x8006,  /*  =*  */
    FTYP_SELECT_EQUIVALENT            = 0x8007,  /*  =   */

    FTYP_SELECT_MATCH_FULL            = 0x8008,  /* *~~* */
    FTYP_SELECT_MATCH_SKP_START       = 0x8009,  /* *~~  */
    FTYP_SELECT_MATCH_SKP_END         = 0x800A,  /*  ~~* */
    FTYP_SELECT_MATCH                 = 0x800B,  /*  ~~  */

    FTYP_SELECT_EQV_MATCH_FULL        = 0x800C,  /* *~*  */
    FTYP_SELECT_EQV_MATCH_SKP_START   = 0x800D,  /* *~   */
    FTYP_SELECT_EQV_MATCH_SKP_END     = 0x800E,  /*  ~*  */
    FTYP_SELECT_EQV_MATCH             = 0x800F,  /*  ~   */

    FTYP_SELECT_MATCH_ANYTHING        = 0x801C,  /*  *   */
    FTYP_SELECT_MATCH_EXISTENCE       = 0x801D,  /*  @   */
    FTYP_SELECT_MATCH_NONEXISTENCE    = 0x801E   /* !@   */
} teFuncType;

/*
 *  The function processing procedures.
 */
tHdlrProc mFunc_Bogus;
tHdlrProc mFunc_Case;
tHdlrProc mFunc_Debug;
tHdlrProc mFunc_Define;
tHdlrProc mFunc_Expr;
tHdlrProc mFunc_For;
tHdlrProc mFunc_If;
tHdlrProc mFunc_Include;
tHdlrProc mFunc_Invoke;
tHdlrProc mFunc_Text;
tHdlrProc mFunc_Unknown;
tHdlrProc mFunc_While;

/*
 *  Template Loading Functions
 */
tLoadProc mLoad_Ending; /* generic block loading ending */
tLoadProc mLoad_Bogus;
tLoadProc mLoad_Case;
tLoadProc mLoad_Comment;
tLoadProc mLoad_Debug;
tLoadProc mLoad_Define;
tLoadProc mLoad_Expr;
tLoadProc mLoad_For;
tLoadProc mLoad_If;
tLoadProc mLoad_Include;
tLoadProc mLoad_Unknown;
tLoadProc mLoad_While;

/* tpParse.c use only * * * * * * * * * * * * * * * *
 *
 *  Parsing function tables for load processing (template scanning phase)
 */
tpLoadProc apLoadProc[ FUNC_CT ] = {
    /* BOGUS     */ mLoad_Bogus,
    /* CASE      */ mLoad_Case,
    /* COMMENT   */ mLoad_Comment,
    /* DEBUG     */ mLoad_Debug,
    /* DEFINE    */ mLoad_Define,
    /* ELIF      */ mLoad_Bogus   /*dynamic*/,
    /* ELSE      */ mLoad_Bogus   /*dynamic*/,
    /* ENDDEF    */ mLoad_Bogus   /*dynamic*/,
    /* ENDFOR    */ mLoad_Bogus   /*dynamic*/,
    /* ENDIF     */ mLoad_Bogus   /*dynamic*/,
    /* ENDWHILE  */ mLoad_Bogus   /*dynamic*/,
    /* ESAC      */ mLoad_Bogus   /*dynamic*/,
    /* EXPR      */ mLoad_Expr,
    /* FOR       */ mLoad_For,
    /* IF        */ mLoad_If,
    /* INCLUDE   */ mLoad_Include,
    /* INVOKE    */ mLoad_Unknown /*default*/,
    /* SELECT    */ mLoad_Bogus   /*dynamic*/,
    /* TEXT      */ mLoad_Unknown /*default*/,
    /* UNKNOWN   */ mLoad_Unknown,
    /* WHILE     */ mLoad_While
};

/*
 *  This global pointer is used to switch parsing tables.
 *  The block functions (CASE, DEFINE, FOR, and IF) change this to point
 *  to their tables that include relevant additional functions.
 */
tpLoadProc* papLoadProc = apLoadProc;

/*
 *  name-to-function type mapping table.
 *  This table must be sorted alphabetically by the content
 *  of the naming string.
 */
typedef struct name_type tNameType;
struct name_type {
    size_t      cmpLen;  /* compare length (sans NUL) */
    tCC*        pName;   /* ptr to name */
    teFuncType  fType;   /* function type enum */
};

/*
 *  Define all the strings that are used to determine the function enumeration
 *  number.  These are used in a table separated by aliases and sorted by these
 *  ASCII values.
 */
tSCC zFnStrg[120] =
    "CASE\0"     "#\0"        "DEBUG\0"    "DEFINE\0"   "ELIF\0"
    "ELSE\0"     "ENDDEF\0"   "ENDFOR\0"   "ENDIF\0"    "ENDWHILE\0"
    "ESAC\0"     "-\0"        "?\0"        "%\0"        ";\0"
    "(\0"        "`\0"        "\"\0"       "'\0"        ".\0"
    "FOR\0"      "IF\0"       "INCLUDE\0"  "INVOKE\0"   "~\0"
    "=\0"        "*\0"        "!\0"        "+\0"        "WHILE\0";

/*
 *  The number of names by which the macros go.
 *  Some have multiple names (aliases, e.g. selection clauses).
 */
#define FUNC_ALIAS_LOW_INDEX    0
#define FUNC_ALIAS_HIGH_INDEX   14
#define FUNC_NAMES_LOW_INDEX    15
#define FUNC_NAMES_HIGH_INDEX   29
#define FUNCTION_NAME_CT        30

/* * * * * * * * tpParse.c use only * * * * * * * * * * * * * * *
 *
 *  And now, the table separated by aliasing and then sorted by string content
 */
tNameType nameTypeTable[ FUNCTION_NAME_CT ] = {
    {  1, zFnStrg +110, FTYP_SELECT },
    {  1, zFnStrg + 76, FTYP_EXPR },
    {  1, zFnStrg +  5, FTYP_COMMENT },
    {  1, zFnStrg + 68, FTYP_EXPR },
    {  1, zFnStrg + 78, FTYP_EXPR },
    {  1, zFnStrg + 72, FTYP_EXPR },
    {  1, zFnStrg +108, FTYP_SELECT },
    {  1, zFnStrg +112, FTYP_SELECT },
    {  1, zFnStrg + 64, FTYP_EXPR },
    {  1, zFnStrg + 80, FTYP_EXPR },
    {  1, zFnStrg + 70, FTYP_EXPR },
    {  1, zFnStrg +106, FTYP_SELECT },
    {  1, zFnStrg + 66, FTYP_EXPR },
    {  1, zFnStrg + 74, FTYP_EXPR },
    {  1, zFnStrg +104, FTYP_SELECT },

    {  4, zFnStrg +  0, FTYP_CASE },
    {  5, zFnStrg +  7, FTYP_DEBUG },
    {  6, zFnStrg + 13, FTYP_DEFINE },
    {  4, zFnStrg + 20, FTYP_ELIF },
    {  4, zFnStrg + 25, FTYP_ELSE },
    {  6, zFnStrg + 30, FTYP_ENDDEF },
    {  6, zFnStrg + 37, FTYP_ENDFOR },
    {  5, zFnStrg + 44, FTYP_ENDIF },
    {  8, zFnStrg + 50, FTYP_ENDWHILE },
    {  4, zFnStrg + 59, FTYP_ESAC },
    {  3, zFnStrg + 82, FTYP_FOR },
    {  2, zFnStrg + 86, FTYP_IF },
    {  7, zFnStrg + 89, FTYP_INCLUDE },
    {  6, zFnStrg + 97, FTYP_INVOKE },
    {  5, zFnStrg +114, FTYP_WHILE } };

char const * const apzFuncNames[ FUNC_CT ] = {
    "Bogus",     zFnStrg+0,   "COMMENT",   zFnStrg+7,   zFnStrg+13,
    zFnStrg+20,  zFnStrg+25,  zFnStrg+30,  zFnStrg+37,  zFnStrg+44,
    zFnStrg+50,  zFnStrg+59,  "EXPR",      zFnStrg+82,  zFnStrg+86,
    zFnStrg+89,  zFnStrg+97,  "SELECT",    "Text",      "Unknown",
    zFnStrg+114 };

#define FUNCTION_CKSUM ((unsigned short)0xDA33)

/* * * * * * * * tpProcess.c use only * * * * * * * * * * * * * *
 *
 *  Template Processing Function Table
 *
 *  Pointers to the procedure to call when the function code
 *  is encountered.
 */
static tpHdlrProc  apHdlrProc[ FUNC_CT ] = {
    /* BOGUS     */ mFunc_Bogus,
    /* CASE      */ mFunc_Case,
    /* COMMENT   */ mFunc_Bogus,
    /* DEBUG     */ mFunc_Debug,
    /* DEFINE    */ mFunc_Define,
    /* ELIF      */ mFunc_Bogus,
    /* ELSE      */ mFunc_Bogus,
    /* ENDDEF    */ mFunc_Bogus,
    /* ENDFOR    */ mFunc_Bogus,
    /* ENDIF     */ mFunc_Bogus,
    /* ENDWHILE  */ mFunc_Bogus,
    /* ESAC      */ mFunc_Bogus,
    /* EXPR      */ mFunc_Expr,
    /* FOR       */ mFunc_For,
    /* IF        */ mFunc_If,
    /* INCLUDE   */ mFunc_Include,
    /* INVOKE    */ mFunc_Invoke,
    /* SELECT    */ mFunc_Bogus,
    /* TEXT      */ mFunc_Text,
    /* UNKNOWN   */ mFunc_Unknown,
    /* WHILE     */ mFunc_While
};

/* * * * * * * * * * tpLoad.c use only * * * * * * * * * * * * * *
 *
 *  Template Unloading Function Table
 *
 *  Pointers to the procedure to call when the function code
 *  is encountered in a template being unloaded.
 */

tUnloadProc mUnload_Define, mUnload_Select;

static tpUnloadProc  apUnloadProc[ FUNC_CT ] = {
    NULL,           NULL,           NULL,           NULL,
    mUnload_Define, NULL,           NULL,           NULL,
    NULL,           NULL,           NULL,           NULL,
    NULL,           NULL,           NULL,           NULL,
    NULL,           mUnload_Select, NULL,           NULL,
    NULL
};
#endif /* AUTOGEN_FUNCTIONS_H_GUARD */
