# - Find Webkit
# Find the Webkit includes and library
#
#  WEBKIT_INCLUDE_DIR - Where to find webkit include sub-directory.
#  WEBKIT_LIBRARIES   - List of libraries when using Webkit.
#  WEBKIT_FOUND       - True if Webkit found.

SET(WEBKIT_VERSION 1.0)
if(DEFINED Webkit_FIND_VERSION)
    SET(WEBKIT_VERSION ${Webkit_FIND_VERSION})
endif()

SET(WEBKIT_INCLUDE_DIR WEBKIT_INCLUDE_DIR-NOTFOUND)
SET(WEBKIT_LIBRARY WEBKIT_LIBRARY-NOTFOUND)
SET(WEBKIT_LIBRARIES WEBKIT_LIBRARIES-NOTFOUND)

FIND_PATH(WEBKIT_INCLUDE_DIR webkit/webkit.h
    PATH_SUFFIXES "webkitgtk-${WEBKIT_VERSION}"
)

SET(WEBKIT_NAMES "webkitgtk-${WEBKIT_VERSION}")
FIND_LIBRARY(WEBKIT_LIBRARY
    NAMES ${WEBKIT_NAMES}
)

# Handle the QUIETLY and REQUIRED arguments and set WEBKIT_FOUND to
# TRUE if all listed variables are TRUE.
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(
    WEBKIT DEFAULT_MSG
    WEBKIT_LIBRARY WEBKIT_INCLUDE_DIR
)

IF(WEBKIT_FOUND)
    SET( WEBKIT_LIBRARIES ${WEBKIT_LIBRARY} )
ELSE(WEBKIT_FOUND)
    SET( WEBKIT_LIBRARIES )
ENDIF(WEBKIT_FOUND)

MARK_AS_ADVANCED(WEBKIT_LIBRARY WEBKIT_LIBRARIES WEBKIT_INCLUDE_DIR)
