/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.rest.internal;

import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.voice.VoiceManager;
import org.eclipse.smarthome.core.voice.text.InterpretationException;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.openhab.ui.habot.card.Card;
import org.openhab.ui.habot.card.internal.CardRegistry;
import org.openhab.ui.habot.nlp.ChatReply;
import org.openhab.ui.habot.nlp.ItemResolver;
import org.openhab.ui.habot.nlp.internal.AnswerFormatter;
import org.openhab.ui.habot.nlp.internal.OpenNLPInterpreter;
import org.openhab.ui.habot.notification.internal.NotificationService;
import org.openhab.ui.habot.notification.internal.webpush.Subscription;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RolesAllowed(value={"user", "administrator"})
@Path(value="habot")
@Api(value="habot")
@Component
public class HABotResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(HABotResource.class);
    private static final String OPENNLP_HLI = "opennlp";
    private VoiceManager voiceManager;
    private LocaleService localeService;
    private NotificationService notificationService;
    private CardRegistry cardRegistry;
    private ItemResolver itemResolver;
    public static final String PATH_HABOT = "habot";

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setVoiceManager(VoiceManager voiceManager) {
        this.voiceManager = voiceManager;
    }

    public void unsetVoiceManager(VoiceManager voiceManager) {
        this.voiceManager = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setLocaleService(LocaleService localeService) {
        this.localeService = localeService;
    }

    public void unsetLocaleService(LocaleService localeService) {
        this.localeService = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void unsetNotificationService(NotificationService notificationService) {
        this.notificationService = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setCardRegistry(CardRegistry cardRegistry) {
        this.cardRegistry = cardRegistry;
    }

    public void unsetCardRegistry(CardRegistry cardRegistry) {
        this.cardRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setItemNamedAttributesResolver(ItemResolver itemResolver) {
        this.itemResolver = itemResolver;
    }

    protected void unsetItemNamedAttributesResolver(ItemResolver itemResolver) {
        this.itemResolver = null;
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/greet")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves a first greeting message from the bot in the specified or configured language.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ChatReply.class), @ApiResponse(code=500, message="There is no support for the configured language")})
    public Response greet(@HeaderParam(value="Accept-Language") @ApiParam(value="language (will use the default if omitted)") String language) {
        Locale locale = this.localeService.getLocale(null);
        AnswerFormatter answerFormatter = new AnswerFormatter(locale);
        String greeting = answerFormatter.getRandomAnswer("greeting");
        ChatReply reply = new ChatReply(locale);
        reply.setAnswer(greeting);
        return Response.ok((Object)reply).build();
    }

    @POST
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/chat")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Send a query to HABot to interpret.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ChatReply.class), @ApiResponse(code=500, message="An interpretation error occured")})
    public Response chat(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @ApiParam(value="human language query", required=true) String query) throws Exception {
        Locale locale = this.localeService.getLocale(null);
        OpenNLPInterpreter hli = (OpenNLPInterpreter)this.voiceManager.getHLI(OPENNLP_HLI);
        if (hli == null) {
            throw new InterpretationException("The OpenNLP interpreter is not available");
        }
        ChatReply reply = hli.reply(locale, query);
        return Response.ok((Object)reply).build();
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/attributes")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all item named attributes.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ChatReply.class), @ApiResponse(code=500, message="An error occurred")})
    public Response getAttributes(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) throws Exception {
        Locale locale = this.localeService.getLocale(null);
        this.itemResolver.setLocale(locale);
        HashMap attributesByItemName = new HashMap();
        this.itemResolver.getAllItemNamedAttributes().entrySet().stream().forEach(entry -> {
            Set set = attributesByItemName.put(((Item)entry.getKey()).getName(), (Set)entry.getValue());
        });
        return Response.ok(attributesByItemName).build();
    }

    @POST
    @Path(value="/notifications/subscribe")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Subscribes a new client for push notifications.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="An error occured")})
    public Response webPushSubscribe(String subscriptionJson) throws Exception {
        Gson gson = new Gson();
        Subscription subscription = (Subscription)gson.fromJson(subscriptionJson, Subscription.class);
        this.notificationService.addSubscription(subscription);
        Response testNotificationResponse = this.notificationService.sendNotification(subscription, "{ \"body\": \"Congratulations, push notifications are working properly! \ud83c\udf89\ud83d\udc4c\" }").get();
        this.logger.debug("Test notification response: {}", (Object)testNotificationResponse.toString());
        this.logger.debug("Test notification response headers: {}", (Object)testNotificationResponse.getStringHeaders());
        this.logger.debug("Test notification response body: {}", testNotificationResponse.readEntity(String.class));
        return Response.ok((Object)testNotificationResponse.getStatusInfo()).build();
    }

    @GET
    @Path(value="/notifications/vapid")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets or generates the public VAPID key used for push notifications.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="An error occured")})
    public Response webPushConfig() throws Exception {
        String publicVAPIDKey = this.notificationService.getVAPIDPublicKey();
        return Response.ok((Object)publicVAPIDKey).build();
    }

    @GET
    @Path(value="/cards")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all cards of the card deck.", response=Card.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="An error occured")})
    public Response getAllCards() {
        Collection<Card> cards = this.cardRegistry.getNonEphemeral();
        return Response.ok(cards).build();
    }

    @GET
    @Path(value="/cards/{cardUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a card from the card deck by its UID.", response=Card.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="The card with the provided UID doesn't exist"), @ApiResponse(code=500, message="An error occured")})
    public Response getCardByUid(@PathParam(value="cardUID") @ApiParam(value="cardUID", required=true) String cardUID) {
        Card card = (Card)this.cardRegistry.get(cardUID);
        if (card == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)card).build();
    }

    @POST
    @Path(value="/cards")
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates a new card in the card deck.")
    @ApiResponses(value={@ApiResponse(code=200, message="The card was created"), @ApiResponse(code=500, message="An error occured")})
    public Response createCard(@ApiParam(value="card", required=true) Card card) {
        card.updateTimestamp();
        card.setEphemeral(false);
        Card existingCard = (Card)this.cardRegistry.get(card.getUID());
        if (existingCard != null && existingCard.isEphemeral()) {
            this.cardRegistry.remove(card.getUID());
        }
        Card createdCard = this.cardRegistry.add(card);
        return Response.ok((Object)createdCard).build();
    }

    @PUT
    @Path(value="/cards/{cardUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates a card in the card deck.")
    public Response updateCard(@PathParam(value="cardUID") @ApiParam(value="cardUID", required=true) String cardUID, @ApiParam(value="card", required=true) Card card) {
        if (!card.getUID().equals(cardUID)) {
            throw new InvalidParameterException("The card UID in the body of the request should match the UID in the URL");
        }
        card.updateTimestamp();
        Card updatedCard = (Card)this.cardRegistry.update(card);
        return Response.ok((Object)updatedCard).build();
    }

    @DELETE
    @Path(value="/cards/{cardUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a card from the card deck.")
    public Response deleteCard(@PathParam(value="cardUID") @ApiParam(value="cardUID", required=true) @NonNull String cardUID) {
        this.cardRegistry.remove(cardUID);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/cards/{cardUID}/bookmark")
    @ApiOperation(value="Sets a bookmark on a card.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="The card with the provided UID doesn't exist"), @ApiResponse(code=500, message="An error occured")})
    public Response setCardBookmark(@PathParam(value="cardUID") @ApiParam(value="cardUID", required=true) String cardUID) {
        Card card = (Card)this.cardRegistry.get(cardUID);
        if (card == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        card.setBookmark(true);
        this.cardRegistry.update(card);
        return Response.ok().build();
    }

    @GET
    @Path(value="/cards/recent")
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates a new card in the card deck.")
    @ApiResponses(value={@ApiResponse(code=200, message="The card was created"), @ApiResponse(code=500, message="An error occured")})
    public Response createCard(@QueryParam(value="skip") int skip, @QueryParam(value="count") int count) {
        Collection<Card> cards = this.cardRegistry.getRecent(skip, count);
        return Response.ok(cards).build();
    }

    @DELETE
    @Path(value="/cards/{cardUID}/bookmark")
    @ApiOperation(value="Removes the bookmark on a card.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="The card with the provided UID doesn't exist"), @ApiResponse(code=500, message="An error occured")})
    public Response unsetCardBookmark(@PathParam(value="cardUID") @ApiParam(value="cardUID", required=true) String cardUID) {
        Card card = (Card)this.cardRegistry.get(cardUID);
        if (card == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        card.setBookmark(false);
        this.cardRegistry.update(card);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/cards/{cardUID}/timestamp")
    @ApiOperation(value="Updates the timestamp on a card to the current time")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="The card with the provided UID doesn't exist"), @ApiResponse(code=500, message="An error occured")})
    public Response updateCardTimestamp(@PathParam(value="cardUID") @ApiParam(value="cardUID", required=true) String cardUID) {
        Card card = (Card)this.cardRegistry.get(cardUID);
        if (card == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        card.updateTimestamp();
        this.cardRegistry.update(card);
        return Response.ok().build();
    }

    @POST
    @Path(value="/compat/cards")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates a new card in the card deck (compatibility endpoint).")
    @ApiResponses(value={@ApiResponse(code=200, message="The card was created"), @ApiResponse(code=500, message="An error occured")})
    public Response createCard(@ApiParam(value="card", required=true) String card) {
        Gson gson = new Gson();
        return this.createCard((Card)gson.fromJson(card, Card.class));
    }

    @POST
    @Path(value="/compat/cards/{cardUID}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates a card in the card deck (compatibility endpoint).")
    public Response updateCard(@PathParam(value="cardUID") @ApiParam(value="cardUID", required=true) String cardUID, @ApiParam(value="card", required=true) String card) {
        Gson gson = new Gson();
        return this.updateCard(cardUID, (Card)gson.fromJson(card, Card.class));
    }

    @POST
    @Path(value="/compat/cards/{cardUID}/delete")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a card from the card deck (compatibility endpoint).")
    public Response deleteCardPost(@PathParam(value="cardUID") @ApiParam(value="cardUID", required=true) @NonNull String cardUID) {
        return this.deleteCard(cardUID);
    }

    @POST
    @Path(value="/compat/cards/{cardUID}/unbookmark")
    @ApiOperation(value="Removes the bookmark on a card (compatibility endpoint).")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="The card with the provided UID doesn't exist"), @ApiResponse(code=500, message="An error occured")})
    public Response unsetCardBookmarkCompat(@PathParam(value="cardUID") @ApiParam(value="cardUID", required=true) @NonNull String cardUID) {
        return this.unsetCardBookmark(cardUID);
    }

    public boolean isSatisfied() {
        return this.localeService != null && this.voiceManager != null && this.notificationService != null && this.cardRegistry != null;
    }
}

