/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp.internal.skill;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationHelper;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.model.persistence.extensions.PersistenceExtensions;
import org.openhab.ui.habot.card.Card;
import org.openhab.ui.habot.card.Component;
import org.openhab.ui.habot.card.internal.CardRegistry;
import org.openhab.ui.habot.nlp.AbstractItemIntentInterpreter;
import org.openhab.ui.habot.nlp.Intent;
import org.openhab.ui.habot.nlp.IntentInterpretation;
import org.openhab.ui.habot.nlp.ItemResolver;
import org.openhab.ui.habot.nlp.Skill;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Reference;

@org.osgi.service.component.annotations.Component(service={Skill.class})
public class HistoryLastChangesSkill
extends AbstractItemIntentInterpreter {
    private CardRegistry cardRegistry;

    @Override
    public String getIntentId() {
        return "get-history-last-changes";
    }

    @Override
    public IntentInterpretation interpret(Intent intent, String language) {
        HistoricItem historicItem;
        Item item;
        IntentInterpretation interpretation = new IntentInterpretation();
        Set<Item> matchedItems = this.findItems(intent);
        if (intent.getEntities().isEmpty()) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("general_failure"));
            return interpretation;
        }
        if (matchedItems == null || matchedItems.isEmpty()) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("answer_nothing_found"));
            interpretation.setHint(this.answerFormatter.getStandardTagHint(intent.getEntities()));
            return interpretation;
        }
        Set<String> tags = intent.getEntities().entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + ":" + (String)e.getValue()).collect(Collectors.toSet());
        Card card = new Card("HbCard");
        card.addTags(tags);
        card.updateTimestamp();
        card.setEphemeral(true);
        card.setAddToDeckDenied(true);
        Component timeline = new Component("HbTimeline");
        if (matchedItems.size() == 1) {
            item = (Item)matchedItems.stream().findFirst().get();
            historicItem = PersistenceExtensions.previousState((Item)item, (boolean)false);
            if (historicItem == null) {
                interpretation.setAnswer(this.answerFormatter.getRandomAnswer("answer_nothing_found"));
                interpretation.setHint(this.answerFormatter.getRandomAnswer("no_historical_data"));
                return interpretation;
            }
        } else {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("multiple_items_error"));
            return interpretation;
        }
        card.setTitle(item.getLabel());
        card.setSubtitle(item.getName());
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        Component pastTimelineEntry = new Component("HbTimelineEntry");
        pastTimelineEntry.addConfig("title", this.formatState(item, historicItem.getState()));
        pastTimelineEntry.addConfig("subtitle", dateFormat.format(historicItem.getTimestamp()));
        timeline.addComponent("main", pastTimelineEntry);
        Component nowTimelineEntry = new Component("HbTimelineEntry");
        nowTimelineEntry.addConfig("title", this.formatState(item, historicItem.getState()));
        nowTimelineEntry.addConfig("subtitle", dateFormat.format(new Date()));
        timeline.addComponent("main", nowTimelineEntry);
        card.addComponent("main", timeline);
        this.cardRegistry.add(card);
        interpretation.setAnswer(this.answerFormatter.getRandomAnswer("info_found_simple"));
        interpretation.setCard(card);
        return interpretation;
    }

    private String formatState(Item item, State state) {
        if (item.getStateDescription() != null) {
            StateDescription stateDescription = item.getStateDescription();
            if (stateDescription != null) {
                String pattern = stateDescription.getPattern();
                if (pattern != null) {
                    try {
                        String transformedState = TransformationHelper.transform((BundleContext)FrameworkUtil.getBundle(HistoryLastChangesSkill.class).getBundleContext(), (String)pattern, (String)state.toString());
                        if (transformedState != null && transformedState.equals(state.toString())) {
                            return state.format(pattern);
                        }
                        return transformedState;
                    }
                    catch (NoClassDefFoundError | TransformationException ex) {
                        return state.toString();
                    }
                }
                return state.toString();
            }
            return state.toString();
        }
        return state.toString();
    }

    @Reference
    protected void setItemResolver(ItemResolver itemResolver) {
        this.itemResolver = itemResolver;
    }

    protected void unsetItemResolver(ItemResolver itemResolver) {
        this.itemResolver = null;
    }

    @Reference
    protected void setCardRegistry(CardRegistry cardRegistry) {
        this.cardRegistry = cardRegistry;
    }

    protected void unsetCardRegistry(CardRegistry cardRegistry) {
        this.cardRegistry = null;
    }
}

