/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp.internal.skill;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.types.Command;
import org.openhab.ui.habot.card.CardBuilder;
import org.openhab.ui.habot.nlp.AbstractItemIntentInterpreter;
import org.openhab.ui.habot.nlp.Intent;
import org.openhab.ui.habot.nlp.IntentInterpretation;
import org.openhab.ui.habot.nlp.ItemResolver;
import org.openhab.ui.habot.nlp.Skill;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Skill.class})
public class ActivateObjectSkill
extends AbstractItemIntentInterpreter {
    private CardBuilder cardBuilder;
    private EventPublisher eventPublisher;

    @Override
    public String getIntentId() {
        return "activate-object";
    }

    @Override
    public IntentInterpretation interpret(Intent intent, String language) {
        IntentInterpretation interpretation = new IntentInterpretation();
        Set<Item> matchedItems = this.findItems(intent);
        if (intent.getEntities().isEmpty()) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("general_failure"));
            return interpretation;
        }
        if (matchedItems == null || matchedItems.isEmpty()) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("nothing_activated"));
            interpretation.setHint(this.answerFormatter.getStandardTagHint(intent.getEntities()));
        } else {
            interpretation.setMatchedItems(matchedItems);
            List<Item> filteredItems = matchedItems.stream().filter(i -> !(i instanceof GroupItem) && i.getAcceptedCommandTypes().contains(OnOffType.class)).collect(Collectors.toList());
            interpretation.setCard(this.cardBuilder.buildCard(intent, filteredItems));
            if (filteredItems.isEmpty()) {
                interpretation.setAnswer(this.answerFormatter.getRandomAnswer("nothing_activated"));
                interpretation.setHint(this.answerFormatter.getStandardTagHint(intent.getEntities()));
            } else if (filteredItems.size() == 1) {
                if (filteredItems.get(0).getState().equals(OnOffType.ON)) {
                    interpretation.setAnswer(this.answerFormatter.getRandomAnswer("switch_already_on"));
                } else {
                    this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)filteredItems.get(0).getName(), (Command)OnOffType.ON));
                    interpretation.setAnswer(this.answerFormatter.getRandomAnswer("switch_activated"));
                }
            } else {
                for (Item item : filteredItems) {
                    this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)OnOffType.ON));
                }
                interpretation.setAnswer(this.answerFormatter.getRandomAnswer("switches_activated", (Map<String, String>)ImmutableMap.of((Object)"count", (Object)String.valueOf(filteredItems.size()))));
            }
        }
        return interpretation;
    }

    @Reference
    protected void setCardBuilder(CardBuilder cardBuilder) {
        this.cardBuilder = cardBuilder;
    }

    protected void unsetCardBuilder(CardBuilder cardBuilder) {
        this.cardBuilder = null;
    }

    @Reference
    protected void setItemResolver(ItemResolver itemResolver) {
        this.itemResolver = itemResolver;
    }

    protected void unsetItemResolver(ItemResolver itemResolver) {
        this.itemResolver = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }
}

