/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp.internal;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.voice.text.HumanLanguageInterpreter;
import org.eclipse.smarthome.core.voice.text.InterpretationException;
import org.openhab.ui.habot.nlp.ChatReply;
import org.openhab.ui.habot.nlp.Intent;
import org.openhab.ui.habot.nlp.IntentInterpretation;
import org.openhab.ui.habot.nlp.ItemNamedAttribute;
import org.openhab.ui.habot.nlp.ItemResolver;
import org.openhab.ui.habot.nlp.Skill;
import org.openhab.ui.habot.nlp.UnsupportedLanguageException;
import org.openhab.ui.habot.nlp.internal.IntentTrainer;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={HumanLanguageInterpreter.class}, immediate=true, name="org.openhab.opennlphli", property={"service.config.description.uri=voice:opennlphli", "service.config.label=OpenNLP Interpreter for HABot", "service.config.category=voice"})
public class OpenNLPInterpreter
implements HumanLanguageInterpreter {
    public static final Set<Locale> SUPPORTED_LOCALES = Collections.unmodifiableSet(new HashSet<Locale>(Arrays.asList(Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN)));
    private IntentTrainer intentTrainer = null;
    private Locale currentLocale = null;
    private String tokenizerId = null;
    private ItemRegistry itemRegistry;
    private ItemResolver itemResolver;
    private EventPublisher eventPublisher;
    private HashMap<String, Skill> skills = new HashMap();
    private @NonNull RegistryChangeListener<Item> registryChangeListener = new RegistryChangeListener<Item>(){

        public void added(Item element) {
            OpenNLPInterpreter.this.intentTrainer = null;
        }

        public void removed(Item element) {
            OpenNLPInterpreter.this.intentTrainer = null;
        }

        public void updated(Item oldElement, Item element) {
            OpenNLPInterpreter.this.intentTrainer = null;
        }
    };

    public String getId() {
        return "opennlp";
    }

    public String getLabel(Locale locale) {
        return "HABot OpenNLP Interpreter";
    }

    public String interpret(Locale locale, String text) throws InterpretationException {
        ChatReply reply = this.reply(locale, text);
        if (reply == null) {
            return null;
        }
        return reply.getAnswer();
    }

    protected InputStream getNameSamples() throws UnsupportedLanguageException {
        StringBuilder nameSamplesDoc = new StringBuilder();
        Map<Item, Set<ItemNamedAttribute>> itemAttributes = this.itemResolver.getAllItemNamedAttributes();
        Stream attributes = itemAttributes.values().stream().flatMap(a -> a.stream());
        attributes.forEach(attribute -> {
            if (attribute.getType() == ItemNamedAttribute.AttributeType.LOCATION) {
                nameSamplesDoc.append(String.format("<START:location> %s <END>%n", attribute.getValue()));
            } else {
                nameSamplesDoc.append(String.format("<START:object> %s <END>%n", attribute.getValue()));
            }
        });
        return IOUtils.toInputStream((String)nameSamplesDoc.toString());
    }

    public ChatReply reply(Locale locale, String text) throws InterpretationException {
        IntentInterpretation intentInterpretation;
        Intent intent;
        if (!locale.equals(this.currentLocale) || this.intentTrainer == null) {
            try {
                this.itemResolver.setLocale(locale);
                this.intentTrainer = new IntentTrainer(locale.getLanguage(), this.skills.values().stream().sorted(new Comparator<Skill>(){

                    @Override
                    public int compare(Skill o1, Skill o2) {
                        if (o1.getIntentId().equals("get-status")) {
                            return -1;
                        }
                        if (o2.getIntentId().equals("get-status")) {
                            return 1;
                        }
                        return o1.getIntentId().compareTo(o2.getIntentId());
                    }
                }).collect(Collectors.toList()), this.getNameSamples(), this.tokenizerId);
                this.currentLocale = locale;
            }
            catch (Exception e) {
                InterpretationException fe = new InterpretationException("Error during trainer initialization: " + e.getMessage());
                fe.initCause((Throwable)e);
                throw fe;
            }
        }
        ChatReply reply = new ChatReply(locale, text);
        if (this.itemResolver.getMatchingItems(text, null).findAny().isPresent()) {
            intent = new Intent("get-status");
            intent.setEntities(new HashMap<String, String>());
            intent.getEntities().put("object", text.toLowerCase());
        } else if (this.itemResolver.getMatchingItems(null, text).findAny().isPresent()) {
            intent = new Intent("get-status");
            intent.setEntities(new HashMap<String, String>());
            intent.getEntities().put("location", text.toLowerCase());
        } else {
            intent = this.intentTrainer.interpret(text);
        }
        reply.setIntent(intent);
        Skill skill = this.skills.get(intent.getName());
        if (skill != null && (intentInterpretation = skill.interpret(intent, locale.getLanguage())) != null) {
            reply.setAnswer(intentInterpretation.getAnswer());
            if (intentInterpretation.getHint() != null) {
                reply.setHint(intentInterpretation.getHint());
            }
            if (intentInterpretation.getMatchedItems() != null) {
                reply.setMatchedItems(intentInterpretation.getMatchedItems().stream().map(i -> i.getName()).collect(Collectors.toList()).toArray(new String[0]));
            }
            if (intentInterpretation.getCard() != null) {
                reply.setCard(intentInterpretation.getCard());
            }
        }
        return reply;
    }

    public String getGrammar(Locale locale, String format) {
        throw new UnsupportedOperationException();
    }

    public Set<Locale> getSupportedLocales() {
        return SUPPORTED_LOCALES;
    }

    public Set<String> getSupportedGrammarFormats() {
        return Collections.emptySet();
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        if (this.itemRegistry == null) {
            this.itemRegistry = itemRegistry;
            this.itemRegistry.addRegistryChangeListener(this.registryChangeListener);
        }
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        if (itemRegistry == this.itemRegistry) {
            this.itemRegistry.removeRegistryChangeListener(this.registryChangeListener);
            this.itemRegistry = null;
        }
    }

    @Reference
    protected void setItemResolver(ItemResolver itemResolver) {
        this.itemResolver = itemResolver;
    }

    protected void unsetItemResolver(ItemResolver itemResolver) {
        this.itemResolver = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        if (this.eventPublisher == null) {
            this.eventPublisher = eventPublisher;
        }
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        if (eventPublisher == this.eventPublisher) {
            this.eventPublisher = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addSkill(Skill skill) {
        this.skills.put(skill.getIntentId(), skill);
        this.intentTrainer = null;
    }

    protected void removeSkill(Skill skill) {
        this.skills.remove(skill.getIntentId());
        this.intentTrainer = null;
    }

    @Activate
    protected void activate(Map<String, Object> configProps, BundleContext bundleContext) {
        if (configProps.containsKey("tokenizer")) {
            this.tokenizerId = configProps.get("tokenizer").toString();
        }
        this.intentTrainer = null;
    }

    @Modified
    protected void modified(Map<String, Object> configProps) {
        if (configProps.containsKey("tokenizer")) {
            this.tokenizerId = configProps.get("tokenizer").toString();
        }
        this.intentTrainer = null;
    }

    @Deactivate
    protected void deactivate() {
    }
}

