/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.Metadata;
import org.eclipse.smarthome.core.items.MetadataKey;
import org.eclipse.smarthome.core.items.MetadataRegistry;
import org.openhab.ui.habot.nlp.ItemNamedAttribute;
import org.openhab.ui.habot.nlp.ItemResolver;
import org.openhab.ui.habot.nlp.UnsupportedLanguageException;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedAttributesItemResolver
implements ItemResolver {
    private final Logger logger = LoggerFactory.getLogger(NamedAttributesItemResolver.class);
    private static final Set<String> LOCATION_CATEGORIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("cellar", "livingroom", "kitchen", "bedroom", "bath", "toilet", "closet", "dressing", "office", "groundfloor", "firstfloor", "attic", "corridor", "garage", "garden", "terrace", "greenhouse", "pantry")));
    private ItemRegistry itemRegistry;
    private MetadataRegistry metadataRegistry;
    private Map<Item, Set<ItemNamedAttribute>> itemAttributes;
    private Locale currentLocale = null;
    ResourceBundle tagAttributes;
    private @NonNull RegistryChangeListener<Item> registryChangeListener = new RegistryChangeListener<Item>(){

        public void added(Item element) {
            NamedAttributesItemResolver.this.logger.debug("Invalidating cached item named attributes");
            NamedAttributesItemResolver.this.itemAttributes = null;
        }

        public void removed(Item element) {
            NamedAttributesItemResolver.this.logger.debug("Invalidating cached item named attributes");
            NamedAttributesItemResolver.this.itemAttributes = null;
        }

        public void updated(Item oldElement, Item element) {
            NamedAttributesItemResolver.this.logger.debug("Invalidating cached item named attributes");
            NamedAttributesItemResolver.this.itemAttributes = null;
        }
    };
    private @NonNull RegistryChangeListener<Metadata> metadataRegistryChangeListener = new RegistryChangeListener<Metadata>(){

        public void added(Metadata element) {
            if (element.getUID().getNamespace() == "habot") {
                NamedAttributesItemResolver.this.logger.debug("Invalidating cached item named attributes");
                NamedAttributesItemResolver.this.itemAttributes = null;
            }
        }

        public void removed(Metadata element) {
            if (element.getUID().getNamespace() == "habot") {
                NamedAttributesItemResolver.this.logger.debug("Invalidating cached item named attributes");
                NamedAttributesItemResolver.this.itemAttributes = null;
            }
        }

        public void updated(Metadata oldElement, Metadata element) {
            if (element.getUID().getNamespace() == "habot") {
                NamedAttributesItemResolver.this.logger.debug("Invalidating cached item named attributes");
                NamedAttributesItemResolver.this.itemAttributes = null;
            }
        }
    };

    @Override
    public void setLocale(Locale locale) {
        if (!locale.equals(this.currentLocale)) {
            this.currentLocale = locale;
            this.logger.debug("Language set to: {} - invalidating cached item named attributes", (Object)locale.getLanguage());
            this.itemAttributes = null;
            this.tagAttributes = ResourceBundle.getBundle("tagattributes", locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
        }
    }

    @Override
    public Map<Item, Set<ItemNamedAttribute>> getAllItemNamedAttributes() throws UnsupportedLanguageException {
        if (this.currentLocale == null) {
            throw new UnsupportedLanguageException(this.currentLocale);
        }
        if (this.itemAttributes == null) {
            this.updateItemNamedAttributes();
        }
        return this.itemAttributes;
    }

    public Set<ItemNamedAttribute> getItemNamedAttributes(Item item) throws UnsupportedLanguageException {
        if (this.currentLocale == null) {
            throw new UnsupportedLanguageException(this.currentLocale);
        }
        if (this.itemAttributes == null) {
            this.updateItemNamedAttributes();
        }
        return this.itemAttributes.get(item);
    }

    @Override
    public Stream<Item> getMatchingItems(String object, String location) {
        return this.itemAttributes.entrySet().stream().filter(entry -> {
            boolean objectMatch = false;
            boolean locationMatch = false;
            if (object != null && ((Set)entry.getValue()).stream().anyMatch(a -> a.getValue().equalsIgnoreCase(object))) {
                objectMatch = true;
            }
            if (location != null && ((Set)entry.getValue()).stream().anyMatch(a -> a.getValue().equalsIgnoreCase(location))) {
                locationMatch = true;
            }
            return object != null && location != null ? objectMatch && locationMatch : objectMatch || locationMatch;
        }).map(entry -> (Item)entry.getKey());
    }

    private void updateItemNamedAttributes() {
        this.itemAttributes = new HashMap<Item, Set<ItemNamedAttribute>>();
        for (Item item : this.itemRegistry.getAll()) {
            Metadata metadata = (Metadata)this.metadataRegistry.get((Object)new MetadataKey("habot", item.getName()));
            boolean inheritAttributes = true;
            if (metadata != null && metadata.getConfiguration().containsKey("inheritAttributes")) {
                inheritAttributes = (Boolean)metadata.getConfiguration().get("inheritAttributes");
            }
            if (!item.getTags().isEmpty()) {
                for (String tag : item.getTags()) {
                    if (tag.split(":").length != 2) continue;
                    String type = tag.startsWith("location:") ? "location" : "object";
                    try {
                        String semanticTagNamedAttributes = this.tagAttributes.getString(tag.split(":")[1].toLowerCase());
                        String[] stringArray = semanticTagNamedAttributes.split(",");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String tagAttribute = stringArray[n2];
                            this.addItemAttribute(item, type, tagAttribute.trim(), ItemNamedAttribute.AttributeSource.TAG, false, inheritAttributes);
                            ++n2;
                        }
                    }
                    catch (MissingResourceException e) {
                        this.logger.debug("No named attributes found for tag {}", (Object)tag);
                    }
                }
            } else {
                String category = item.getCategory();
                if (category != null) {
                    if (metadata != null && metadata.getConfiguration().containsKey("useCategory") && metadata.getConfiguration().get("useCategory").equals(false)) {
                        this.logger.info("Ignoring category for item {}", (Object)item.getName());
                    } else {
                        category = category.toLowerCase();
                        try {
                            String categoryNamedAttributes = this.tagAttributes.getString(category);
                            String[] stringArray = categoryNamedAttributes.split(",");
                            int n = stringArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                String tagAttribute = stringArray[n3];
                                this.addItemAttribute(item, LOCATION_CATEGORIES.contains(category) ? "location" : "object", tagAttribute.trim(), ItemNamedAttribute.AttributeSource.CATEGORY, false, inheritAttributes);
                                ++n3;
                            }
                        }
                        catch (MissingResourceException e) {
                            this.logger.debug("No named attributes found for category {}", (Object)category);
                        }
                    }
                }
            }
            if (metadata == null || metadata.getValue().isEmpty()) continue;
            String type = "object";
            if (item instanceof GroupItem && item.getTags().stream().anyMatch(t -> t.startsWith("location:"))) {
                type = "location";
            }
            if (metadata.getConfiguration().containsKey("type")) {
                type = metadata.getConfiguration().get("type").toString();
            }
            String[] stringArray = metadata.getValue().split(",");
            int n = stringArray.length;
            int n4 = 0;
            while (n4 < n) {
                String moniker = stringArray[n4];
                this.addItemAttribute(item, type, moniker.trim(), ItemNamedAttribute.AttributeSource.METADATA, false, inheritAttributes);
                ++n4;
            }
        }
    }

    private void addItemAttribute(Item item, String type, String value, ItemNamedAttribute.AttributeSource source, boolean isInherited, boolean inheritToGroupMembers) {
        Set<ItemNamedAttribute> attributes = this.itemAttributes.get(item);
        if (attributes == null) {
            attributes = new HashSet<ItemNamedAttribute>();
        }
        ItemNamedAttribute attribute = new ItemNamedAttribute(type, value, isInherited, source);
        attributes.add(attribute);
        if (item instanceof GroupItem && inheritToGroupMembers) {
            for (Item groupMemberItem : ((GroupItem)item).getMembers(i -> true)) {
                this.addItemAttribute(groupMemberItem, type, value, source, true, true);
            }
        }
        this.itemAttributes.put(item, attributes);
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        if (this.itemRegistry == null) {
            this.itemRegistry = itemRegistry;
            this.itemRegistry.addRegistryChangeListener(this.registryChangeListener);
        }
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        if (itemRegistry == this.itemRegistry) {
            this.itemRegistry.removeRegistryChangeListener(this.registryChangeListener);
            this.itemRegistry = null;
        }
    }

    @Reference
    protected void setMetadataRegistry(MetadataRegistry metadataRegistry) {
        if (this.metadataRegistry == null) {
            this.metadataRegistry = metadataRegistry;
            this.metadataRegistry.addRegistryChangeListener(this.metadataRegistryChangeListener);
        }
    }

    protected void unsetMetadataRegistry(MetadataRegistry metadataRegistry) {
        if (metadataRegistry == this.metadataRegistry) {
            this.metadataRegistry.removeRegistryChangeListener(this.metadataRegistryChangeListener);
            this.metadataRegistry = null;
        }
    }
}

