/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;

public class AnswerFormatter {
    ResourceBundle answers;
    Locale locale;

    public AnswerFormatter(Locale locale) {
        this.locale = locale;
        this.answers = ResourceBundle.getBundle("answers", locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
    }

    public AnswerFormatter(String language) {
        this.locale = new Locale(language);
        this.answers = ResourceBundle.getBundle("answers", this.locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
    }

    public String getRandomAnswer(String key, Map<String, String> placeholderValues) {
        String alternativesStr = this.answers.getString(key);
        String[] alternatives = alternativesStr.split("\\|");
        Random random = new Random();
        String answer = alternatives[random.nextInt(alternatives.length)].trim();
        if (placeholderValues != null) {
            for (String placeholder : placeholderValues.keySet()) {
                answer = answer.replace("{" + placeholder + "}", placeholderValues.get(placeholder));
            }
        }
        return answer;
    }

    public String getRandomAnswer(String key) {
        return this.getRandomAnswer(key, null);
    }

    public String getStandardTagHint(Map<String, String> entities) {
        return this.getRandomAnswer("standard_hint", (Map<String, String>)ImmutableMap.of((Object)"attributes", (Object)String.join((CharSequence)" & ", (CharSequence[])entities.entrySet().stream().filter(e -> ((String)e.getKey()).equals("object") || ((String)e.getKey()).equals("location")).map(e -> String.format("\"%s\"", e.getValue())).toArray(String[]::new))));
    }
}

