/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp;

public class ItemNamedAttribute {
    AttributeType type;
    String value;
    boolean inherited;
    AttributeSource source;

    public ItemNamedAttribute(AttributeType type, String value, boolean inherited, AttributeSource source) {
        this.type = type;
        this.value = value;
        this.inherited = inherited;
        this.source = source;
    }

    public ItemNamedAttribute(String type, String value, boolean inherited, AttributeSource source) {
        this.type = type == "location" ? AttributeType.LOCATION : AttributeType.OBJECT;
        this.value = value;
        this.inherited = inherited;
        this.source = source;
    }

    public ItemNamedAttribute(String type, String value, AttributeSource source) {
        this.type = type == "location" ? AttributeType.LOCATION : AttributeType.OBJECT;
        this.value = value;
        this.inherited = false;
        this.source = source;
    }

    public AttributeType getType() {
        return this.type;
    }

    public void setType(AttributeType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public AttributeSource getSource() {
        return this.source;
    }

    public void setSource(AttributeSource source) {
        this.source = source;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inherited ? 1231 : 1237);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemNamedAttribute other = (ItemNamedAttribute)obj;
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static enum AttributeSource {
        LABEL,
        CATEGORY,
        TAG,
        METADATA;

    }

    public static enum AttributeType {
        OBJECT,
        LOCATION;

    }
}

