/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.dashboard.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HABotHttpContext
implements HttpContext {
    private final Logger logger = LoggerFactory.getLogger(HABotHttpContext.class);
    private HttpContext defaultHttpContext;
    private String resourcesBase;
    private boolean useGzipCompression;

    public HABotHttpContext(HttpContext defaultHttpContext, String resourcesBase, boolean useGzipCompression) {
        this.defaultHttpContext = defaultHttpContext;
        this.resourcesBase = resourcesBase;
        this.useGzipCompression = useGzipCompression;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.useGzipCompression && this.isGzipVersionAvailable(request.getRequestURI())) {
            response.addHeader("Content-Encoding", "gzip");
        }
        return this.defaultHttpContext.handleSecurity(request, response);
    }

    public URL getResource(String name) {
        this.logger.debug("Requesting resource: {}", (Object)name);
        URL defaultResource = this.defaultHttpContext.getResource(name);
        if (this.useGzipCompression && this.isGzipVersionAvailable(name)) {
            try {
                return new URL(String.valueOf(defaultResource.toString()) + ".gz");
            }
            catch (MalformedURLException e) {
                return defaultResource;
            }
        }
        if (name.equals(this.resourcesBase) || name.equals(String.valueOf(this.resourcesBase) + "/") || !name.contains(".")) {
            return this.defaultHttpContext.getResource(String.valueOf(this.resourcesBase) + "/index.html");
        }
        return defaultResource;
    }

    public String getMimeType(String name) {
        return this.defaultHttpContext.getMimeType(name);
    }

    private boolean isGzipVersionAvailable(String name) {
        if (!name.endsWith(".css") && !name.contains("/js/")) {
            return false;
        }
        if (name.contains("app.") || name.contains("vendor.") || name.contains("charts.")) {
            return true;
        }
        return name.contains("0.") && name.endsWith(".css");
    }
}

