/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.card.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.openhab.ui.habot.card.Card;
import org.openhab.ui.habot.card.internal.CardProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={CardRegistry.class}, immediate=true)
public class CardRegistry
extends AbstractRegistry<Card, String, CardProvider> {
    private final Logger logger = LoggerFactory.getLogger(CardRegistry.class);

    public CardRegistry() {
        super(CardProvider.class);
    }

    public Collection<Card> getCardByTags(Set<String> tags) {
        ArrayList<Card> filteredCards = new ArrayList<Card>();
        for (Card card : this.getAll()) {
            if (!this.cardHasTags(card, tags)) continue;
            filteredCards.add(card);
        }
        return filteredCards;
    }

    public Collection<Card> getCardMatchingAttributes(@Nullable String object, @Nullable String location) {
        ArrayList<Card> filteredCards = new ArrayList<Card>();
        for (Card card : this.getAll()) {
            if (!this.cardMatchesAttributes(card, object, location)) continue;
            filteredCards.add(card);
        }
        return filteredCards;
    }

    public Card add(Card element) {
        Comparator byTimestamp = (e1, e2) -> e2.getTimestamp().compareTo(e1.getTimestamp());
        List oldCards = this.getAll().stream().filter(card -> card.isEphemeral()).sorted(byTimestamp).skip(10L).collect(Collectors.toList());
        for (Card card2 : oldCards) {
            this.logger.info("Removing old ephemeral card {}", (Object)card2.getUID());
            this.remove(card2.getUID());
        }
        return (Card)super.add((Identifiable)element);
    }

    public Collection<Card> getRecent(int skip, int count) {
        int limit = count < 1 ? 10 : count;
        Comparator byTimestamp = (e1, e2) -> e2.getTimestamp().compareTo(e1.getTimestamp());
        List<Card> recentCards = this.getAll().stream().sorted(byTimestamp).skip(skip).limit(limit).collect(Collectors.toList());
        return recentCards;
    }

    public Collection<Card> getNonEphemeral() {
        return this.getAll().stream().filter(c -> !c.isEphemeral()).collect(Collectors.toList());
    }

    private boolean cardHasTags(Card card, @Nullable Set<String> tags) {
        return tags != null && card.getTags() != null && card.getTags().equals(tags);
    }

    private boolean cardMatchesAttributes(Card card, @Nullable String object, @Nullable String location) {
        boolean objectMatches = (object == null || object.isEmpty()) ^ card.hasObjectAttribute(object);
        boolean locationMatches = (location == null || location.isEmpty()) ^ card.hasLocationAttribute(location);
        return objectMatches && locationMatches;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedProvider(CardProvider provider) {
        super.setManagedProvider((ManagedProvider)provider);
    }

    protected void unsetManagedProvider(CardProvider provider) {
        super.unsetManagedProvider((ManagedProvider)provider);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        super.setEventPublisher(eventPublisher);
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        super.unsetEventPublisher(eventPublisher);
    }
}

