/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.card;

import java.util.Arrays;
import java.util.Collection;
import java.util.IllegalFormatConversionException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.Metadata;
import org.eclipse.smarthome.core.items.MetadataKey;
import org.eclipse.smarthome.core.items.MetadataRegistry;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationHelper;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.openhab.ui.habot.card.Card;
import org.openhab.ui.habot.card.Component;
import org.openhab.ui.habot.card.internal.CardRegistry;
import org.openhab.ui.habot.nlp.Intent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Reference;

@org.osgi.service.component.annotations.Component(service={CardBuilder.class}, immediate=true)
public class CardBuilder {
    private CardRegistry cardRegistry;
    private MetadataRegistry metadataRegistry;

    public Card buildCard(Intent intent, Collection<Item> matchedItems) {
        Card card;
        block38: {
            Supplier<Stream> matchingNonGroupItems;
            block36: {
                String location;
                String object = intent.getEntities().get("object");
                Collection cardsInRegistry = this.cardRegistry.getCardMatchingAttributes(object, location = intent.getEntities().get("location")).stream().filter(c -> !c.isNotReuseableInChat() && !c.isEphemeral()).collect(Collectors.toList());
                if (cardsInRegistry.size() > 0) {
                    Card existingCard = (Card)cardsInRegistry.iterator().next();
                    existingCard.updateTimestamp();
                    this.cardRegistry.update(existingCard);
                    return existingCard;
                }
                card = new Card("HbCard");
                if (object != null) {
                    card.addObjectAttribute(object);
                }
                if (location != null) {
                    card.addLocationAttribute(location);
                }
                card.setEphemeral(true);
                card.addConfig("bigger", true);
                card.updateTimestamp();
                matchingNonGroupItems = () -> matchedItems.stream().filter(i -> !(i instanceof GroupItem));
                if (matchingNonGroupItems.get().count() != 1L) break block36;
                Item item2 = (Item)matchingNonGroupItems.get().findFirst().get();
                Metadata metadata = (Metadata)this.metadataRegistry.get((Object)new MetadataKey("habot", item2.getName()));
                card.setTitle(item2.getLabel());
                card.setSubtitle(item2.getName());
                switch (item2.getType()) {
                    case "Switch": {
                        Component switchComponent = new Component("HbSwitch");
                        switchComponent.addConfig("item", item2.getName());
                        card.addComponent("right", switchComponent);
                        break;
                    }
                    case "Dimmer": {
                        boolean buildKnob;
                        boolean bl = buildKnob = metadata != null && metadata.getConfiguration().containsKey("control") && metadata.getConfiguration().get("control").equals("knob");
                        if (item2.hasTag("capability:Switchable")) {
                            Component dimmerSwitchComponent = new Component("HbSwitch");
                            dimmerSwitchComponent.addConfig("item", item2.getName());
                            card.addComponent("right", dimmerSwitchComponent);
                        } else if (!buildKnob) {
                            Component dimmerValueComponent = new Component("HbSingleItemValue");
                            dimmerValueComponent.addConfig("item", item2.getName());
                            card.addComponent("right", dimmerValueComponent);
                        }
                        Component dimmerContainerComponent = new Component("HbContainer");
                        dimmerContainerComponent.addConfig("classes", new String[]{"full-width", "text-center"});
                        if (buildKnob) {
                            Component knobComponent = new Component("HbKnob");
                            knobComponent.addConfig("item", item2.getName());
                            knobComponent.addConfig("size", "200px");
                            knobComponent.addConfig("textSize", "2rem");
                            knobComponent.addConfig("color", "primary");
                            dimmerContainerComponent.addComponent("main", knobComponent);
                        } else {
                            Component sliderComponent = new Component("HbSlider");
                            sliderComponent.addConfig("item", item2.getName());
                            dimmerContainerComponent.addComponent("main", sliderComponent);
                        }
                        card.addComponent("main", dimmerContainerComponent);
                        break;
                    }
                    case "Rollershutter": {
                        Component shutterValueComponent = new Component("HbSingleItemValue");
                        shutterValueComponent.addConfig("item", item2.getName());
                        card.addComponent("right", shutterValueComponent);
                        Component shutterContainerComponent = new Component("HbContainer");
                        shutterContainerComponent.addConfig("classes", new String[]{"full-width", "text-center"});
                        Component shutterControlComponent = new Component("HbShutterControl");
                        shutterControlComponent.addConfig("item", item2.getName());
                        shutterControlComponent.addConfig("size", "lg");
                        shutterControlComponent.addConfig("rounded", true);
                        shutterControlComponent.addConfig("glossy", true);
                        shutterControlComponent.addConfig("push", true);
                        shutterControlComponent.addConfig("stopIcon", "close");
                        shutterContainerComponent.addComponent("main", shutterControlComponent);
                        card.addComponent("main", shutterContainerComponent);
                        break;
                    }
                    case "Player": {
                        Component playerContainerComponent = new Component("HbContainer");
                        playerContainerComponent.addConfig("classes", new String[]{"full-width", "text-center"});
                        Component playerComponent = new Component("HbPlayer");
                        playerComponent.addConfig("item", item2.getName());
                        playerComponent.addConfig("size", "lg");
                        playerContainerComponent.addComponent("main", playerComponent);
                        card.addComponent("main", playerContainerComponent);
                        break;
                    }
                    case "Color": {
                        Component colorPickerComponent = new Component("HbColorPicker");
                        colorPickerComponent.addConfig("item", item2.getName());
                        card.addComponent("right", colorPickerComponent);
                        Component brightnessDimmerComponent = new Component("HbSwitch");
                        brightnessDimmerComponent.addConfig("item", item2.getName());
                        card.addComponent("right", brightnessDimmerComponent);
                        Component brightnessDimmerContainerComponent = new Component("HbContainer");
                        brightnessDimmerContainerComponent.addConfig("classes", new String[]{"full-width", "text-center"});
                        Component brightnessSliderComponent = new Component("HbSlider");
                        brightnessSliderComponent.addConfig("item", item2.getName());
                        brightnessDimmerContainerComponent.addComponent("main", brightnessSliderComponent);
                        card.addComponent("main", brightnessDimmerContainerComponent);
                        break;
                    }
                    default: {
                        String formattedState;
                        if (item2.getType() == "Image" || metadata != null && metadata.getConfiguration().containsKey("imageSitemap")) {
                            Component singleImageComponent = new Component("HbImage");
                            singleImageComponent.addConfig("item", item2.getName());
                            card.addComponent("media", singleImageComponent);
                            break;
                        }
                        try {
                            formattedState = this.formatState(item2, item2.getState());
                        }
                        catch (TransformationException e1) {
                            formattedState = item2.getState().toString();
                        }
                        Component singleItemComponent = new Component("HbSingleItemValue");
                        singleItemComponent.addConfig("item", item2.getName());
                        if (formattedState.length() < 10) {
                            card.addComponent("right", singleItemComponent);
                            break;
                        }
                        card.addComponent("main", singleItemComponent);
                        break;
                    }
                }
                break block38;
            }
            GroupItem commonGroup = this.getMatchingGroup(matchedItems);
            if (commonGroup != null) {
                card.setTitle(commonGroup.getLabel());
                Item baseItem = commonGroup.getBaseItem();
                if (baseItem != null && baseItem.getType() == "Switch") {
                    Component switchComponent = new Component("HbSwitch");
                    switchComponent.addConfig("item", commonGroup.getName());
                    card.addComponent("right", switchComponent);
                } else if (!commonGroup.getState().toString().isEmpty()) {
                    Component singleItemComponent = new Component("HbSingleItemValue");
                    singleItemComponent.addConfig("item", commonGroup.getName());
                    card.addComponent("right", singleItemComponent);
                }
            } else {
                card.setTitle(String.join((CharSequence)", ", intent.getEntities().values()));
            }
            card.setSubtitle(String.valueOf(matchingNonGroupItems.get().count()) + " items");
            Component list = new Component("HbList");
            matchingNonGroupItems.get().forEach(item -> {
                Metadata metadata = (Metadata)this.metadataRegistry.get((Object)new MetadataKey("habot", item.getName()));
                Component listItem = new Component("HbListItem");
                listItem.addConfig("item", item.getName());
                listItem.addConfig("label", item.getLabel());
                if (metadata != null) {
                    for (String configKey : Arrays.asList("label", "sublabel", "leftIcon", "leftLetter", "leftColor")) {
                        if (!metadata.getConfiguration().containsKey(configKey)) continue;
                        listItem.addConfig(configKey, metadata.getConfiguration().get(configKey));
                    }
                }
                list.addComponent("items", listItem);
            });
            card.addComponent("list", list);
        }
        this.cardRegistry.add(card);
        return card;
    }

    public Card buildChartCard(Intent intent, Collection<Item> matchedItems, String period) {
        String object = intent.getEntities().get("object");
        String location = intent.getEntities().get("location");
        Card card = new Card("HbCard");
        if (object != null) {
            card.addObjectAttribute(object);
        }
        if (location != null) {
            card.addLocationAttribute(location);
        }
        card.setEphemeral(true);
        card.addConfig("bigger", true);
        card.updateTimestamp();
        Supplier<Stream> matchingNonGroupItems = () -> matchedItems.stream().filter(i -> !(i instanceof GroupItem));
        if (matchingNonGroupItems.get().count() == 1L) {
            Item item = (Item)matchingNonGroupItems.get().findFirst().get();
            card.setTitle(item.getLabel());
            card.setSubtitle(String.valueOf(period) + " - " + item.getName());
        } else {
            GroupItem commonGroup = this.getMatchingGroup(matchedItems);
            if (commonGroup != null) {
                card.setTitle(commonGroup.getLabel());
                Item baseItem = commonGroup.getBaseItem();
                if (baseItem != null && baseItem.getType() == "Switch") {
                    Component switchComponent = new Component("HbSwitch");
                    switchComponent.addConfig("item", commonGroup.getName());
                    card.addComponent("right", switchComponent);
                } else if (!commonGroup.getState().toString().isEmpty()) {
                    Component singleItemComponent = new Component("HbSingleItemValue");
                    singleItemComponent.addConfig("item", commonGroup.getName());
                    card.addComponent("right", singleItemComponent);
                }
            } else {
                card.setTitle(intent.getEntities().entrySet().stream().filter(e -> !((String)e.getKey()).equals("period")).map(e -> (String)e.getValue()).collect(Collectors.joining(", ")));
            }
            card.setSubtitle(String.valueOf(period) + " - " + matchingNonGroupItems.get().count() + " items");
        }
        Component chart = new Component("HbChartImage");
        chart.addConfig("items", matchingNonGroupItems.get().map(i -> i.getName()).collect(Collectors.toList()).toArray(new String[0]));
        chart.addConfig("period", period);
        Component analyzeButton = new Component("HbAnalyzeActionButton");
        analyzeButton.addConfig("items", chart.getConfig().get("items"));
        analyzeButton.addConfig("period", chart.getConfig().get("period"));
        card.addComponent("media", chart);
        card.addComponent("actions", analyzeButton);
        this.cardRegistry.add(card);
        return card;
    }

    private GroupItem getMatchingGroup(Collection<Item> items) {
        Optional<Item> groupItem = items.stream().filter(i -> i instanceof GroupItem).filter(g -> items.stream().allMatch(i -> i.getName().equals(g.getName()) || ((GroupItem)g).getAllMembers().stream().anyMatch(i2 -> i2.getName().contains(i.getName())))).findFirst();
        return groupItem.isPresent() ? (GroupItem)groupItem.get() : null;
    }

    private String formatState(Item item, State state) throws TransformationException {
        if (item.getStateDescription() != null) {
            try {
                StateDescription stateDescription = item.getStateDescription();
                if (stateDescription != null) {
                    String pattern = stateDescription.getPattern();
                    if (pattern != null) {
                        String transformedState = TransformationHelper.transform((BundleContext)FrameworkUtil.getBundle(CardBuilder.class).getBundleContext(), (String)pattern, (String)state.toString());
                        if (transformedState == null) {
                            return state.toString();
                        }
                        if (transformedState.equals(state.toString())) {
                            return state.format(pattern);
                        }
                        return transformedState;
                    }
                    return state.toString();
                }
                return state.toString();
            }
            catch (IllegalFormatConversionException e) {
                return state.toString();
            }
        }
        return state.toString();
    }

    @Reference
    protected void setCardRegistry(CardRegistry cardRegistry) {
        this.cardRegistry = cardRegistry;
    }

    protected void unsetCardRegistry(CardRegistry cardRegistry) {
        this.cardRegistry = null;
    }

    @Reference
    protected void setMetadataRegistry(MetadataRegistry metadataRegistry) {
        this.metadataRegistry = metadataRegistry;
    }

    protected void unsetMetadataRegistry(MetadataRegistry metadataRegistry) {
        this.metadataRegistry = null;
    }
}

