/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.card;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.openhab.ui.habot.card.Component;

@NonNullByDefault
public class Card
extends Component
implements Identifiable<String> {
    String uid;
    @Nullable String title;
    @Nullable String subtitle;
    Set<String> objects = new HashSet<String>();
    Set<String> locations = new HashSet<String>();
    Set<String> tags = new HashSet<String>();
    boolean bookmarked;
    boolean notReuseableInChat;
    boolean addToDeckDenied;
    boolean ephemeral;
    @Nullable Date timestamp;

    public Card(String name) {
        super(name);
        this.uid = UUID.randomUUID().toString();
    }

    public Card(String uid, String name) {
        super(name);
        this.uid = uid;
    }

    public String getUID() {
        return this.uid;
    }

    public @Nullable String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public @Nullable String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(@Nullable String subtitle) {
        this.subtitle = subtitle;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Set<String> getObjectAttributes() {
        return this.objects;
    }

    public Set<String> getLocationAttributes() {
        return this.tags;
    }

    public boolean isBookmarked() {
        return this.bookmarked;
    }

    public void setBookmark(boolean bookmarked) {
        this.bookmarked = bookmarked;
    }

    public boolean isNotReuseableInChat() {
        return this.notReuseableInChat;
    }

    public void setNotReuseableInChat(boolean notReuseableInChat) {
        this.notReuseableInChat = notReuseableInChat;
    }

    public boolean isAddToDeckDenied() {
        return this.addToDeckDenied;
    }

    public void setAddToDeckDenied(boolean addToDeckDenied) {
        this.addToDeckDenied = addToDeckDenied;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public void setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
    }

    public @Nullable Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public void updateTimestamp() {
        this.timestamp = new Date();
    }

    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addTags(Collection<String> tags) {
        this.tags.addAll(tags);
    }

    public void addTags(String ... tags) {
        this.tags.addAll(Arrays.asList(tags));
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public void removeAllTags() {
        this.tags.clear();
    }

    public void addObjectAttribute(String object) {
        this.objects.add(object);
    }

    public void addObjectAttributes(Collection<String> objects) {
        this.objects.addAll(objects);
    }

    public void addObjectAttributes(String ... objects) {
        this.objects.addAll(Arrays.asList(objects));
    }

    public void removeObjectAttribute(String object) {
        this.objects.remove(object);
    }

    public boolean hasObjectAttribute(@Nullable String object) {
        if (this.objects == null || object == null || object.isEmpty()) {
            return false;
        }
        return this.objects.stream().anyMatch(o -> o.equalsIgnoreCase(object));
    }

    public void addLocationAttribute(String location) {
        this.locations.add(location);
    }

    public void addLocationAttributes(Collection<String> locations) {
        this.locations.addAll(locations);
    }

    public void addLocationAttributes(String ... locations) {
        this.locations.addAll(Arrays.asList(locations));
    }

    public void removeLocationAttribute(String location) {
        this.locations.remove(location);
    }

    public boolean hasLocationAttribute(@Nullable String location) {
        if (this.locations == null || location == null || location.isEmpty()) {
            return false;
        }
        return this.locations.stream().anyMatch(o -> o.equalsIgnoreCase(location));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Card other = (Card)obj;
        return this.getUID().equals(other.getUID());
    }
}

