angular.module('templates-app', ['automation/eventEdit.tpl.html', 'automation/rules.tpl.html', 'automation/scheduler.tpl.html', 'binding/zwave.tpl.html', 'chart/chart.tpl.html', 'chart/chartMenu.tpl.html', 'chart/chartSave.tpl.html', 'chart/chartSaveAxis.tpl.html', 'chart/chartSaveGeneral.tpl.html', 'chart/chartSaveItem.tpl.html', 'configuration/bindingConfig.tpl.html', 'configuration/eshConfigParam.tpl.html', 'configuration/extensionsConfig.tpl.html', 'configuration/itemConfig.tpl.html', 'configuration/itemEdit.tpl.html', 'configuration/itemLink.tpl.html', 'configuration/itemWidget.tpl.html', 'configuration/servicesConfig.tpl.html', 'configuration/thingAttributesZWave.tpl.html', 'configuration/thingConfig.tpl.html', 'configuration/thingConfigMenu.tpl.html', 'configuration/thingDiscovery.tpl.html', 'configuration/thingWizard.tpl.html', 'configuration/thingWizardConfigure.tpl.html', 'configuration/thingWizardDiscovery.tpl.html', 'configuration/thingWizardSelectBinding.tpl.html', 'configuration/thingWizardSelectThing.tpl.html', 'dashboard/dashboard.tpl.html', 'dashboard/dashboardButtonProperties.tpl.html', 'dashboard/dashboardButtonWidget.tpl.html', 'dashboard/dashboardChartProperties.tpl.html', 'dashboard/dashboardChartWidget.tpl.html', 'dashboard/dashboardFloorplanProperties.tpl.html', 'dashboard/dashboardFloorplanWidget.tpl.html', 'dashboard/dashboardGaugeProperties.tpl.html', 'dashboard/dashboardGaugeWidget.tpl.html', 'dashboard/dashboardGeneralProperties.tpl.html', 'dashboard/dashboardGroupBarProperties.tpl.html', 'dashboard/dashboardGroupBarWidget.tpl.html', 'dashboard/dashboardGroupProperties.tpl.html', 'dashboard/dashboardGroupWidget.tpl.html', 'dashboard/dashboardImageProperties.tpl.html', 'dashboard/dashboardMenu.tpl.html', 'dashboard/dashboardProperties.tpl.html', 'dashboard/dashboardWidgetProperties.tpl.html', 'floorplan/floorplanEditor.tpl.html', 'floorplan/floorplanHotspotProperties.tpl.html', 'floorplan/floorplanProperties.tpl.html', 'home/home.tpl.html', 'persistence/persistence.tpl.html', 'sitemap/sitemap.tpl.html', 'tools/zwave/logInfo.tpl.html', 'tools/zwave/logReader.tpl.html', 'tools/zwave/zwaveNetwork.tpl.html', 'user/userChart.tpl.html', 'user/userConfig.tpl.html', 'user/userGeneral.tpl.html']);

angular.module("automation/eventEdit.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("automation/eventEdit.tpl.html",
    "<div class=modal-header> <h3 class=modal-title i18n=schedule.EditTitle></h3> </div> <div class=modal-body> <ul class=\"nav nav-tabs\"> <li role=presentation ng-class=\"{'active': tabDisplayed=='event'}\" ng-click=\"tabDisplayed='event'\"><a href=#>Event</a></li> <li role=presentation ng-class=\"{'active': tabDisplayed=='rule'}\" ng-click=\"tabDisplayed='rule'\"><a href=#>Rule</a> </li> </ul> <div ng-show=\"tabDisplayed=='event'\"> <form class=form-horizontal role=form> <div class=form-group> <label for=inputLabel class=control-label i18n=schedule.EditLabel></label> <div> <input ng-model=event.label class=form-control id=inputLabel i18n-attr=\"{placeholder: 'habmin.itemSelectLabel'}\"> </div> </div> <div class=form-group> <label class=control-label i18n=schedule.EditStart></label> <p class=input-group> <input class=form-control datetime-picker=\"dd MMM yyyy HH:mm\" ng-model=event.start is-open=\"startOpen\"> <span class=input-group-btn> <button type=button class=\"btn btn-default\" ng-click=\"startOpen=true\"> <i class=\"fa fa-calendar\"></i> </button> </span> </p> </div> <div class=form-group> <label class=control-label i18n=schedule.EditDaily></label> <div> <form-select-yes-no ng-model=event.daily placeholder=\"Label\"> </div> </div> <div class=form-group> <label for=inputRepeat class=control-label i18n=schedule.EditRepeat></label> <div> <ui-select id=inputRepeat ng-model=event.repeat theme=bootstrap search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'schedule.EditRepeat'}\"> {{$select.selected.label}} </ui-select-match> <ui-select-choices repeat=\"repeat.period as repeat in repeater\"> <span>{{repeat.label}}</span> </ui-select-choices> </ui-select> </div> </div> <div class=form-group> <label for=inputCategory class=control-label i18n=habmin.itemEditCategory></label> <div> <ui-select id=inputCategory ng-model=item.category theme=bootstrap search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'habmin.itemSelectCategory'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.id}}></habmin-icon> {{$select.selected.name}} </ui-select-match> <ui-select-choices repeat=\"category.id as category in categories | orderBy: 'name'\"> <habmin-icon class=\"fa fa-fw\" category={{category.id}}></habmin-icon> <span>{{category.name}}</span> </ui-select-choices> </ui-select> </div> </div> </form> </div> <div class=modal-footer> <button type=button class=\"btn btn-primary\" ng-click=ok() i18n=common.save></button> <button type=button class=\"btn btn-warning\" ng-click=cancel() i18n=common.cancel></button> </div></div>");
}]);

angular.module("automation/rules.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("automation/rules.tpl.html",
    "<div class=col-sm-4> <div class=\"panel panel-default\">  <div class=panel-heading> <button type=button class=\"btn btn-default\" ng-confirm-click=newRule() ng-confirm-if=isDirty data-i18n-attr=\"{'ngConfirmMessage': 'rule.UnsavedChangesCheck','ngConfirmTitle': 'rule.UnsavedChangesTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes'}\" data-rulename={{selectedRule.name}}> <span class=\"fa fa-plus\"></span> <span i18n=common.new></span> </button> <button type=button ng-confirm-click=deleteRule() ng-class=\"{'btn btn-default':true, 'disabled':!selectedRule}\" data-i18n-attr=\"{'ngConfirmMessage': 'rule.DeleteRuleCheck','ngConfirmTitle': 'rule.DeleteRuleTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes'}\" data-rulename={{selectedRule.name}}> <span class=\"fa fa-trash-o\"></span> <span i18n=common.delete></span> </button> </div>  <div class=list-group resize-panel> <div ng-repeat=\"choice in blockRules\"> <a role=presentation ng-class=\"{'list-group-item':true, 'active':choice==selectedRule}\" ng-confirm-click=selectBlock(choice) ng-confirm-if=$parent.isDirty data-i18n-attr=\"{'ngConfirmMessage': 'rule.UnsavedChangesCheck','ngConfirmTitle': 'rule.UnsavedChangesTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes'}\" data-rulename={{selectedRule.name}}&quot;> <span class=\"fa fa-fw fa-puzzle-piece\"></span> <span>{{choice.name}}</span> </a> </div> <div ng-repeat=\"choice in codeRules\"> <a role=presentation ng-class=\"{'list-group-item':true, 'active':choice==selectedRule}\" ng-confirm-click=selectRule(choice) ng-confirm-if=$parent.isDirty data-i18n-attr=\"{'ngConfirmMessage': 'rule.UnsavedChangesCheck','ngConfirmTitle': 'rule.UnsavedChangesTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes'}\" rulename={{selectedRule.name}}&quot;> <span class=\"fa fa-fw fa-code\"></span> <span>{{choice.name}}</span> </a> </div>  <div ng-if=\"rulesTotal==-1\" class=\"list-group-item text-center\"> <span class=\"fa fa-spin fa-refresh\"></span> <span i18n=common.loading></span> </div> <div ng-if=\"rulesTotal==0\" class=\"list-group-item text-center\"> <span class=\"fa fa-exclamation-triangle text-warning\"></span> <span i18n=rule.NoRules></span> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>  <div class=col-sm-8>  <div class=\"panel panel-default\"> <div class=panel-heading style=padding:3px> <button type=button ng-class=\"{'btn btn-sm btn-default':true, 'disabled':!isDirty}\" ng-click=saveRule()> <span class=\"fa fa-floppy-o\"></span> <span i18n=common.save></span> </button> <button type=button ng-class=\"{'btn btn-sm btn-default':true, 'disabled':!isDirty}\" ng-click=cancelRule()> <span class=\"fa fa-times\"></span> <span i18n=common.cancel></span> </button> <div class=pull-right> <button type=button ng-class=\"{'btn btn-sm btn-default':true, 'active':editSource==false, 'disabled':selectedRule.type=='code'}\" ng-click=showRule()> <span class=\"fa fa-puzzle-piece\"></span> <span i18n=rule.Rule></span> </button> <button type=button ng-class=\"{'btn btn-sm btn-default':true, 'active':editSource==true}\" ng-click=showSource()> <span class=\"fa fa-code\"></span> <span i18n=rule.Source></span> </button> </div> </div>  <div resize-panel> <ng-blockly ng-show=!editSource> </ng-blockly> <div style=height:100% ng-if=editSource ng-model=codeEditor ui-ace=aceOptions> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("automation/scheduler.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("automation/scheduler.tpl.html",
    "<!DOCTYPE html> <div class=col-sm-4> <div class=\"panel panel-default\">  <div class=panel-heading> <button type=button class=\"btn btn-default\"> <span class=\"fa fa-folder-o\"></span> <span i18n=common.new></span> </button> <button type=button class=\"btn btn-default disabled\"> <span class=\"fa fa-trash-o\"></span> <span i18n=common.delete></span> </button> </div>  <div class=\"list-group habmin-list\" resize-panel> <div ng-repeat=\"choice in events.events\"> <a role=presentation class=list-group-item ng-class=\"{'active':choice==selectedEvent}\" ng-click=\"\"> <span class=\"fa fa-fw fa-puzzle-piece\"></span> <span>{{choice.title}}</span> </a> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>  <div class=col-sm-8>  <div class=\"panel panel-default\"> <div class=panel-heading> <button type=button class=\"btn btn-default\" ng-click=\"stepDate('today')\"> <span i18n1=common.new>today</span> </button> <div class=btn-group> <button type=button class=\"btn btn-default\" ng-click=\"stepDate('prev')\"> <span class=\"fa fa-angle-left\"></span> </button> <button type=button class=\"btn btn-default\" ng-click=\"stepDate('next')\"> <span class=\"fa fa-angle-right\"></span> </button> </div> <div class=\"pull-right btn-group\"> <button type=button class=\"btn btn-default\" ng-class=\"{'active': view=='timeline'}\" ng-click=\"changeView('timeline')\"> <span class=\"fa fa-clock-o\"></span> <span i18n1=common.new>Timeline</span> </button> <button type=button class=\"btn btn-default\" ng-class=\"{'active': view=='agendaDay'}\" ng-click=\"changeView('agendaDay')\"> <span class=\"fa fa-calendar-o\"></span> <span i18n1=common.new>Day</span> </button> <button type=button class=\"btn btn-default\" ng-class=\"{'active': view=='agendaWeek'}\" ng-click=\"changeView('agendaWeek')\"> <span class=\"fa fa-calendar-o\"></span> <span i18n1=common.delete>Week</span> </button> </div> </div>  <div resize-panel> <div ng-show=\"view!='timeline'\" ui-calendar=calendarCfg ng-model=eventSources calendar=calendar> </div> <vis-timeline ng-show=\"view=='timeline'\" data=timelineData options=timelineOptions events=graphEvents></vis-timeline> </div> </div> </div>");
}]);

angular.module("binding/zwave.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("binding/zwave.tpl.html",
    "<!DOCTYPE html> <div class=col-sm-4 sidepanel-pane=side> <div class=\"panel panel-default\">  <div class=panel-heading>  <div class=\"btn-group dropdown\"> <button type=button class=\"btn btn-default dropdown-toggle\" data-toggle=dropdown> <span class=\"fa fa-cog\"></span> <span i18n=zwave.zwaveNetworkTools></span> <span class=caret></span> <span class=sr-only>Dropdown</span> </button> <ul class=dropdown-menu role=menu> <li><a ng-click=\"zwaveAction('binding/network', 'Heal')\"> <span class=\"fa fa-fw fa-ambulance\"></span> <span i18n=zwave.zwaveNetworkHeal></span> </a></li> <li role=presentation class=divider></li> <li><a ng-click=\"zwaveAction('binding/network', 'Include')\"> <span class=\"fa fa-fw fa-sign-in\"></span> <span i18n=zwave.zwaveNetworkInclude></span> </a></li> <li><a ng-click=\"zwaveAction('binding/network', 'Exclude')\"> <span class=\"fa fa-fw fa-sign-out\"></span> <span i18n=zwave.zwaveNetworkExclude></span> </a></li> <li role=presentation class=divider></li> <li><a ng-confirm-click=\"zwaveAction('binding/network', 'SoftReset')\" i18n-attr=\"{'ngConfirmMessage': 'zwave.zwaveSoftResetConfirmMessage','ngConfirmTitle': 'zwave.zwaveSoftResetConfirmTitle','ngConfirmNoBtn': 'common.cancel', 'ngConfirmYesBtn': 'common.ok'}\"> <span class=\"fa fa-fw fa-power-off\"></span> <span i18n=zwave.zwaveNetworkReset></span> </a></li> <li><a ng-click=networkReplicate()> <span class=\"fa fa-fw fa-copy fa-fw\"></span> <span i18n=zwave.zwaveNetworkReplicate></span> </a></li> <li role=presentation class=divider></li> <li><a ng-confirm-click=\"zwaveAction('binding/network', 'HardReset')\" ng-confirm-icon=danger i18n-attr=\"{'ngConfirmMessage': 'zwave.zwaveHardResetConfirmMessage','ngConfirmTitle': 'zwave.zwaveHardResetConfirmTitle','ngConfirmNoBtn': 'common.cancel', 'ngConfirmYesBtn': 'common.ok'}\"> <span class=\"fa fa-fw fa-exclamation-triangle\"></span> <span i18n=zwave.zwaveNetworkDefault></span> </a></li> </ul> </div> </div>  <div class=\"list-group habmin-list\" resize-panel> <div ng-repeat=\"device in devices | orderObjectBy:'deviceID'\"> <a role=presentation ng-class=\"{'list-group-item':true, 'active': device.device==devEdit.device}\" ng-click=selectDevice(device) sidepanel-click=main> <habmin-icon class=icon-lg icon={{device.icon}}></habmin-icon> <span>{{device.label}}</span> <span class=pull-right> <span popover={{stateHeal(device)}} popover-trigger=mouseenter popover-placement=top popover-append-to-body=true popover-popup-delay=500> <span ng-class=\"{'text-success': device.healState=='OK','text-danger': device.healState =='ERROR','text-warning': device.healState =='RUN','text-muted': device.healState =='WAIT'}\"> <span class=\"fa fa-ambulance\"></span> </span> </span> <span popover={{stateOnline(device)}} popover-trigger=mouseenter popover-placement=top popover-append-to-body=true popover-popup-delay=500> <span ng-class=\"{'text-success': device.state=='OK','text-danger': device.state=='ERROR','text-warning': device.state =='WARNING','text-muted': device.state =='INITIALIZING'}\"> <span class=\"fa fa-rss\"></span> </span> </span> </span> <br> <span ng-class=\"{'small': true, 'text-warning': device.typeUnknown}\">{{device.type}}</span> <span class=pull-right> <span popover={{device.powerInfo}} popover-trigger=mouseenter popover-placement=top popover-append-to-body=true popover-popup-delay=500> <span ng-class=\"{'text-success': device.batteryLevel>=40,'text-danger': device.batteryLevel==0,'text-muted': device.batteryLevel=='UNK','text-warning': device.batteryLevel<40}\"> <span ng-class=device.batteryIcon></span> </span> </span> </span> </a> </div>  <div ng-if=\"deviceCnt==-1\" class=\"list-group-item text-center\"> <span class=\"fa fa-spin fa-refresh\"></span> <span i18n=common.loading></span> </div> <div ng-if=\"deviceCnt==0\" class=\"list-group-item text-center\"> <span class=\"fa fa-exclamation-triangle text-warning\"></span> <span i18n=zwave.zwaveNoDevices></span> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>  <div class=col-sm-8 sidepanel-pane=main> <div class=\"panel panel-default\">  <div class=panel-heading> <div class=\"btn-group dropdown\"> <button type=button ng-class=\"{'disabled': !devEdit.label}\" class=\"btn btn-default dropdown-toggle\" data-toggle=dropdown> <span class=\"fa fa-cog\"></span> <span i18n=zwave.zwaveDeviceTools></span> <span class=caret></span> <span class=sr-only>Dropdown</span> </button> <ul class=dropdown-menu role=menu> <li> <a ng-click=\"setView('CONFIG')\"> <span class=\"fa fa-fw fa-wrench\"></span> <span i18n=zwave.zwaveDeviceConfiguration></span> </a> </li> <li> <a ng-click=\"setView('NETWORK')\"> <span class=\"fa fa-fw fa-sitemap\"></span> <span i18n=zwave.zwaveDeviceNetworkDiagram></span> </a> </li> <li role=presentation class=divider></li> <li> <a ng-click=\"zwaveAction('nodes/'+devEdit.device+'/', 'Heal')\"> <span class=\"fa fa-fw fa-ambulance\"></span> <span i18n=zwave.zwaveDeviceHeal></span> </a> </li> <li ng-class1=\"{'disabled':devEdit.nodeStage!='FAILED'}\"> <a ng-confirm-click=\"zwaveAction('nodes/'+devEdit.device+'/', 'Delete')\" i18n-attr=\"{'ngConfirmMessage': 'zwave.zwaveRemoveFailedText','ngConfirmTitle': 'zwave.zwaveRemoveFailedTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes'}\" nodenumber={{devEdit.id}}> <span class=\"fa fa-fw fa-trash-o\"></span> <span i18n=zwave.zwaveDeviceKill></span> </a> </li> <li> <a ng-click=\"zwaveAction('nodes/'+devEdit.device+'/parameters/', 'Refresh');zwaveAction('nodes/'+devEdit.device+'/associations/', 'Refresh')\"> <span class=\"fa fa-fw fa-refresh\"></span> <span i18n=zwave.zwaveDeviceRefresh></span> </a> </li> </ul> </div> <button ng-show=\"deviceDisplay=='CONFIG'\" type=button ng-click=deviceSave() ng-class=\"{'btn btn-default':true, 'disabled':!isDirty}\"> <span class=\"fa fa-floppy-o\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.save></span> </button> <button ng-show=\"deviceDisplay=='CONFIG'\" type=button ng-click=deviceCancel() ng-class=\"{'btn btn-default':true, 'disabled':!isDirty}\"> <span class=\"fa fa-times\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.cancel></span> </button> <div ng-hide=!devEdit.label class=\"btn-group pull-right\"> <div class=text-right>{{devEdit.label}}</div> <div class=\"text-right small\"><span i18n=zwave.zwaveNode></span>&nbsp;<span>{{devEdit.nodeID}}</span>:&nbsp;<span class=hidden-xs>{{devEdit.type}}</span></div> </div> </div>  <div ng-show=\"deviceDisplay=='CONFIG'\" class=\"list-group habmin-list\" resize-panel>  <div ng-show=devEdit.information> <a role=presentation ng-class=\"{'list-group-item':true, 'active': panelDisplayed=='INFO'}\" ng-click=\"showPanel('INFO')\"> <span class=\"fa fa-fw fa-info\"></span> <span i18n=zwave.zwaveInformation></span> </a> </div> <div ng-show=devEdit.information uib-collapse=\"panelDisplayed!='INFO'\"> <binding-config template={{devEdit.deviceInfo}} binding-change=changeNotification binding-data=deviceData> </binding-config> <binding-config template={{devEdit.information}} binding-change=changeNotification binding-data=infoData> </binding-config> </div>  <div ng-show=devEdit.configuration> <a role=presentation ng-class=\"{'list-group-item':true, 'active': panelDisplayed=='CONFIG'}\" ng-click=\"showPanel('CONFIG')\"> <span class=\"fa fa-fw fa-wrench\"></span> <span i18n=zwave.zwaveConfiguration></span> </a> </div> <div ng-show=devEdit.configuration uib-collapse=\"panelDisplayed!='CONFIG'\"> <binding-config template={{devEdit.configuration}} binding-change=changeNotification binding-data=configData> </binding-config> </div>  <div ng-show=devEdit.associations> <a role=presentation ng-class=\"{'list-group-item':true, 'active': panelDisplayed=='ASSOC'}\" ng-click=\"showPanel('ASSOC')\"> <span class=\"fa fa-fw fa-link\"></span> <span i18n=zwave.zwaveAssociations></span> </a> </div> <div ng-show=devEdit.associations uib-collapse=\"panelDisplayed!='ASSOC'\"> <div ng-repeat=\"choice in devEdit.associations\"> {{choice.label}} <binding-config template={{choice.associations}} binding-change=changeNotification binding-data=xData> </binding-config> </div> </div>  <div ng-show=devEdit.wakeup> <a role=presentation ng-class=\"{'list-group-item':true, 'active': panelDisplayed=='WAKE'}\" ng-click=\"showPanel('WAKE')\"> <span class=\"fa fa-fw fa-moon-o\"></span> <span i18n=zwave.zwaveWakeup></span> </a> </div> <div ng-show=devEdit.wakeup uib-collapse=\"panelDisplayed!='WAKE'\"> <binding-config template={{devEdit.wakeup}} binding-change=changeNotification binding-data=wakeupData>> </binding-config> </div> </div>  <div ng-show=\"deviceDisplay=='NETWORK'\" class=panel-body style=padding:3px resize-panel> <vis-network data=networkNodes options=networkOptions events=networkEvents></vis-network> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("chart/chart.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("chart/chart.tpl.html",
    "<div class=\"panel panel-default\">  <div class=panel-heading style=padding:3px> <div class=\"btn-group btn-group-sm\" role=group> <button type=button class=\"btn btn-sm btn-default\" ng-disabled=!graphLoaded ng-click=stepWindow(-1)> <span class=\"fa fa-backward\"></span> </button> <button type=button class=\"btn btn-sm btn-default\" ng-disabled=!graphLoaded ng-click=stepWindow(1)> <span class=\"fa fa-forward\"></span> </button> <button type=button class=\"btn btn-sm btn-default\" ng-disabled=!graphLoaded ng-click=setNow()> <span class=\"fa fa-fast-forward\"></span> </button> <button type=button class=\"btn btn-sm btn-default\" ng-disabled=!graphLoaded ng-click=zoomWindow(0.10)> <span class=\"fa fa-search-minus\"></span> </button> <button type=button class=\"btn btn-sm btn-default\" ng-disabled=!graphLoaded ng-click=zoomWindow(-0.10)> <span class=\"fa fa-search-plus\"></span> </button> </div> <div class=\"btn-group btn-group-sm\"> <button type=button class=\"btn btn-sm btn-default\" ng-disabled=!graphLoaded ng-class=\"{active:graphWindow=='day'}\" ng-click=\"setWindow('day')\"> <span class=calendar-stack> <span class=\"fa fa-calendar-o\"></span> <span class=calendar-day>1</span> </span> <span class=\"hidden-xs hidden-sm\">Day</span> </button> <button type=button class=\"btn btn-sm btn-default\" ng-disabled=!graphLoaded ng-class=\"{active:graphWindow=='week'}\" ng-click=\"setWindow('week')\"> <span class=calendar-stack> <span class=\"fa fa-calendar-o\"></span> <span class=calendar-day>7</span> </span> <span class=\"hidden-xs hidden-sm\">Week</span> </button> <button type=button class=\"btn btn-sm btn-default\" ng-disabled=!graphLoaded ng-class=\"{active:graphWindow=='month'}\" ng-click=\"setWindow('month')\"> <span class=calendar-stack> <span class=\"fa fa-calendar-o\"></span> <span class=calendar-day>30</span> </span> <span class=\"hidden-xs hidden-sm\">Month</span> </button> </div> <div class=\"pull-right btn-group btn-group-sm\"> <button type=button class=\"btn btn-sm btn-default\" ng-disabled=!graphLoaded ng-click=\"liveupdate=!liveupdate\" ng-class=\"{'btn-success':liveupdate}\"> <span class=\"fa fa-video-camera\"></span> </button> <button type=button class=\"btn btn-sm btn-default\" ng-disabled=!graphLoaded ng-click=refreshChart()> <span class=\"fa fa-refresh\"></span> </button> </div> <div ng-show=graphLoaded class=\"pull-right hidden-xs hidden-sm\"> <h6>{{graphTimeline}}&nbsp;</h6> </div> </div>  <div class=panel-body style=padding:3px resize-panel> <habmin-chart ng-show=true style=display:inline-block;height:100%;width:100% items=graphItems() chart=selectedChart().id liveupdate=liveupdate service=persistenceService() events=graphEvents> </habmin-chart> </div> <div ng-show=\"chartLoading==true\" class=chart-loading><span class=\"fa fa-spin fa-circle-o-notch\"></span></div>  <div class=\"panel-footer panel-footer-none\"> </div> </div>");
}]);

angular.module("chart/chartMenu.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("chart/chartMenu.tpl.html",
    "<ul class=\"nav navbar-nav\"> <li class=\"dropdown items-menu\" ng-class=\"{'open': itemListOpen}\"> <a class=navbar-button ng-init=\"itemListOpen=false\" ng-click=\"itemListOpen=!itemListOpen\"> <i class=\"fa fa-list-alt\"></i> </a> <ul class=\"dropdown-menu dropdown-right\"> <li class=search-form> <div class=\"input-group input-group-sm\"> <span class=input-group-addon><span class=\"fa fa-filter\"></span></span> <input class=form-control placeholder={{filterDefaultString}} ng-model=filter.text ng-model-options=\"{debounce: 500}\"> <span class=input-group-addon ng-click=\"filter.text=''\"> <span class=\"fa fa-minus-circle\"></span> </span> </div> </li> <li>  <ul class=\"menu scroll-body\" slimscroll=\"{size: 3, height:'100%'}\"> <li ng-repeat=\"item in items | filter:filterFunction\"> <a role=presentation ng-show=item.label ng-hide=item.filter class=list-group-item ng-class=\"{'active':item.selected}\" ng-click=selectItem(item)> <habmin-icon class=\"fa fa-fw\" category={{item.category}}></habmin-icon> <span>{{item.label}}</span> <span class=pull-right> <span ng-show=item.selected class=\"fa fa-check-square-o\"></span> </span> </a> </li> </ul> </li> <li class=footer> <button type=button class=\"btn btn-xs btn-default\" ng-click=\"itemListOpen=false\"> <span class=\"fa fa-fw fa-times text-danger\"></span> <span i18n=common.close></span> </button> <button type=button class=\"btn btn-xs btn-default\" ng-click=clearList()> <span class=\"fa fa-fw fa-eraser\"></span> <span i18n=common.clear></span> </button> <button type=button class=\"btn btn-xs btn-default\" ng-click=doGraph()> <span class=\"fa fa-fw fa-check text-success\"></span> <span i18n=common.ok></span> </button> </li> </ul> </li> <li class=dropdown uib-dropdown ng-if=\"services.length > 1\"> <a class=dropdown-toggle uib-dropdown-toggle> <i class=\"fa fa-database\"></i> </a> <ul class=dropdown-menu uib-dropdown-menu role=menu> <li ng-repeat=\"service in services\"> <a ng-click=selectService(service)> <span class=\"fa fa-fw fa-database\"></span> <span>{{service.label}}</span> </a> </li> </ul> </li> <li ng-if=\"services!=null && services.length==0\"> <a class=navbar-button role=button> <i class=\"fa fa-warning text-warning\"></i> </a> </li> <li> <a class=navbar-button role=button ng-click=saveChart() tooltip-placement=bottom tooltip={{tooltipSave}} tooltip-popup-delay=500 tooltip-enable=true tooltip-trigger tooltip-animation=false> <i class=\"fa fa-save\"></i> </a> </li> <li> <a class=navbar-button role=button tooltip-placement=bottom tooltip={{tooltipDelete}} tooltip-popup-delay=500 tooltip-enable=true tooltip-trigger tooltip-animation=false ng-confirm-click=deleteChart() ng-confirm-icon=warning i18n-attr=\"{'ngConfirmMessage': 'chart.DeleteChartCheck','ngConfirmTitle': 'chart.DeleteChart','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes' }\"> <i class=\"fa fa-trash-o\"></i> </a> </li> </ul>");
}]);

angular.module("chart/chartSave.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("chart/chartSave.tpl.html",
    "<div class=modal-header> <h3 class=modal-title i18n=chart.SaveChartTitle></h3> </div> <div class=modal-body> <div class=row> <div class=col-xs-6> <ul class=\"nav nav-pills nav-stacked\"> <li ng-class=\"{'active':showTab==0}\"> <a ng-click=\"showTab=0\"> <span i18n=chart.SaveGeneral></span> </a> </li> <li ng-class=\"{'active':showTab==1}\"><a ng-click=\"showTab=1\"> <span i18n=chart.SaveLeftAxis></span> </a> </li> <li ng-class=\"{'active':showTab==2}\"> <a ng-click=\"showTab=2\"> <span i18n=chart.SaveRightAxis></span> </a> </li> <li ng-class=\"{'active':showTab==item.item}\" ng-repeat=\"item in items\"> <a ng-click=\"$parent.showTab=item.item\"> <div>{{item.label}}</div> <div class=small>{{item.item}}</div> </a> </li> </ul> </div> <div class=col-xs-6> <chart-save-general ng-show=\"showTab==0\" model=general></chart-save-general> <chart-save-axis ng-show=\"showTab==1\" model=leftaxis></chart-save-axis> <chart-save-axis ng-show=\"showTab==2\" model=rightaxis></chart-save-axis> <chart-save-item ng-repeat=\"item in items\" model=choice ng-show=\"showTab==item.item\"></chart-save-item> </div> </div> </div> <div class=modal-footer> <button type=button class=\"btn btn-primary\" ng-click=ok() i18n=common.save></button> <button type=button class=\"btn btn-warning\" ng-click=cancel() i18n=common.cancel></button> </div>");
}]);

angular.module("chart/chartSaveAxis.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("chart/chartSaveAxis.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputLabel class=control-label i18n=chart.SaveAxesLabel></label> <div> <input ng-model=model.label class=form-control id=inputLabel placeholder=Label> </div> </div> <div class=form-group> <label for=inputDecimalPlaces class=control-label i18n=chart.SaveAxesDecimals></label> <div> <input type=number class=form-control id=inputDecimalPlaces ng-model=model.format placeholder=format> </div> </div> <div class=form-group> <label for=inputMinimum class=control-label i18n=chart.SaveAxesMinimum></label> <div> <input type=number ng-model=model.minimum class=form-control id=inputMinimum placeholder=minimum> </div> </div> <div class=form-group> <label for=inputMaximum class=control-label i18n=chart.SaveAxesMaximum></label> <div> <input type=number ng-model=model.maximum class=form-control id=inputMaximum placeholder=maximum> </div> </div> <div class=form-group> <label class=control-label i18n=chart.SaveAxesTextColor></label> <div> <pick-a-color id=inputColor ng-model=model.textColor></pick-a-color> </div> </div> <div class=form-group> <label class=control-label i18n=chart.SaveAxesLineColor></label> <div> <pick-a-color id=inputLineColor ng-model=model.lineColor></pick-a-color> </div> </div> <div class=form-group> <label class=control-label i18n=chart.SaveAxesLineStyle>Line Style</label> <div> <select-line-style id=inputLineStyle ng-model=model.lineStyle></select-line-style> </div> </div> </form>");
}]);

angular.module("chart/chartSaveGeneral.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("chart/chartSaveGeneral.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputName class=control-label i18n=chart.SaveName></label> <div> <input ng-model=model.name class=form-control id=inputName placeholder=Name> </div> </div> <div class=form-group> <label for=inputTitle class=control-label i18n=chart.SaveTitle></label> <div> <input ng-model=model.title class=form-control id=inputTitle placeholder=Title> </div> </div> <div class=form-group> <label for=inputPeriod class=control-label i18n=chart.SavePeriod></label> <div> <select ng-model=model.period class=form-control id=inputPeriod> <option value=3600 i18n=common.period1Hour></option> <option value=7200 i18n=common.period2Hours></option> <option value=10800 i18n=common.period3Hours></option> <option value=14400 i18n=common.period4Hours></option> <option value=21600 i18n=common.period6Hours></option> <option value=32400 i18n=common.period9Hours></option> <option value=43200 i18n=common.period12Hours></option> <option value=86400 i18n=common.period1Day></option> <option value=172800 i18n=common.period2Days></option> <option value=259200 i18n=common.period3Days></option> <option value=345600 i18n=common.period4Days></option> <option value=432000 i18n=common.period5Days></option> <option value=604800 i18n=common.period1Week></option> <option value=1209600 i18n=common.period2Weeks></option> <option value=1814400 i18n=common.period3Weeks></option> <option value=2419200 i18n=common.period1Month></option> <option value=5184000 i18n=common.period2Months></option> <option value=7776000 i18n=common.period3Months></option> <option value=10454400 i18n=common.period4Months></option> <option value=15724800 i18n=common.period6Months></option> <option value=23095800 i18n=common.period9Months></option> <option value=31536000 i18n=common.period1Year></option> </select> </div> </div> <div class=form-group> <label for=inputLegend class=control-label i18n=chart.SaveLegend></label> <div> <select ng-model=model.legend class=form-control id=inputLegend> <option value=false i18n=common.no></option> <option value=true i18n=common.yes></option> </select> </div> </div> </form>");
}]);

angular.module("chart/chartSaveItem.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("chart/chartSaveItem.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputLabel class=control-label i18n=chart.SaveItemLabel></label> <div> <input ng-model=model.label class=form-control id=inputLabel placeholder=Label> </div> </div> <div class=form-group> <label for=inputDecimalPlaces class=control-label i18n=chart.SaveItemDecimals></label> <div> <input type=number class=form-control id=inputDecimalPlaces ng-model=model.format placeholder=format> </div> </div> <div class=form-group> <label for=inputAxis class=control-label i18n=chart.SaveItemAxes></label> <div> <select ng-model=model.axis class=form-control id=inputAxis> <option value=left i18n=chart.ItemLeftAxis></option> <option value=right i18n=chart.ItemRightAxis></option> </select> </div> </div> <div class=form-group> <label for=inputStyle class=control-label i18n=chart.SaveItemStyle></label> <div> <select ng-model=model.chart class=form-control id=inputStyle> <option value=line i18n=chart.SaveItemStyleLine></option> <option value=bar i18n=chart.SaveItemStyleBar></option> </select> </div> </div> <div class=form-group> <label class=control-label i18n=chart.SaveItemLineColor></label> <div> <pick-a-color id=inputColor ng-model=model.lineColor></pick-a-color> </div> </div> <div class=form-group> <label for=inputLineWidth class=control-label i18n=chart.SaveItemLineWidth></label> <div> <input type=number class=form-control id=inputLineWidth ng-model=model.lineWidth placeholder=width> </div> </div> <div class=form-group> <label class=control-label i18n=chart.SaveItemLineStyle></label> <div> <select-line-style id=inputLineStyle ng-model=model.lineStyle></select-line-style> </div> </div> <div class=form-group> <label for=inputFill class=control-label i18n=chart.SaveItemFill></label> <div> <select ng-model=model.axis class=form-control id=inputFill> <option value=none i18n=chart.ItemFillNone></option> <option value=top i18n=chart.ItemFillTop></option> <option value=bottom i18n=chart.ItemFillBottom></option> </select> </div> </div> <div class=form-group> <label class=control-label i18n=chart.SaveItemFillColor></label> <div> <pick-a-color id=fillColor ng-model=model.fillColor></pick-a-color> </div> </div> <div class=form-group> <label for=inputPoints class=control-label i18n=chart.SaveItemPointType></label> <div> <select ng-model=model.axis class=form-control id=inputPoints> <option value=none i18n=chart.ItemPointsNone></option> <option value=circle i18n=chart.ItemPointsCircle></option> <option value=square i18n=chart.ItemPointsSquare></option> </select> </div> </div> <div class=form-group> <label for=inputPointSize class=control-label i18n=chart.SaveItemPointSize></label> <div> <input type=number class=form-control id=inputPointSize ng-model=model.pointsSize placeholder=size> </div> </div> <div class=form-group> <label for=inputRepeatTime class=control-label i18n=chart.SaveItemRepeatTime></label> <div> <input type=number class=form-control id=inputRepeatTime placeholder=\"repeat time\"> </div> </div> </form>");
}]);

angular.module("configuration/bindingConfig.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/bindingConfig.tpl.html",
    "<div class=col-sm-4> <div class=\"panel panel-default\">  <div class=panel-heading> <span i18n=binding.InstalledBindings></span> </div>  <div class=\"list-group habmin-list\" resize-panel>  <div ng-if=\"bindingsCnt>0\" ng-repeat=\"binding in bindings | orderBy:'name'\" class=list-group-item ng-class=\"{'active': binding==selectedBinding}\" ng-click=selectBinding(binding)> <li role=presentation> <table style=\"background-color: transparent\"> <tr> <td class=text-large rowspan=2> <habmin-icon class=\"fa fa-fw\" icon={{binding.icon}}></habmin-icon> </td> <td> <span>{{binding.name}}&nbsp;</span> </td> </tr> <tr> <td class=\"text-muted small\">{{binding.author}}</td> </tr> </table> </li> </div>  <div ng-if=\"bindingsCnt==-1\" class=\"list-group-item text-center\"> <span class=\"fa fa-spin fa-refresh\"></span> <span i18n=common.loading></span> </div> <div ng-if=\"bindingsCnt==0\" class=\"list-group-item text-center\"> <span class=\"fa fa-exclamation-triangle text-warning\"></span> <span i18n=binding.NoneFound></span> </div> </div>  <div class=\"panel-footer panel-footer-none\"></div> </div> </div>  <div class=col-sm-8> <div class=\"panel panel-default\">  <div class=panel-heading> <h3 class=\"panel-title pull-left\"> <span i18n=binding.Information></span> &nbsp; <span> <i>{{selectedBinding.name}}</i> </span> </h3> <div class=\"pull-right btn-group dropdown\"> <button type=button class=\"btn btn-default dropdown-toggle\" data-toggle=dropdown> <span class=\"fa fa-cog\"></span> <span i18n=habmin.Tools></span> <span class=caret></span> <span class=sr-only>Dropdown</span> </button> <ul class=dropdown-menu role=menu> <li ng-repeat=\"config in selectedThingConfig.parameters\"> <a ng-if=\"config.groupName=='actions'\" ng-click=doAction(config)> <span class=\"fa fa-fw\"></span> <span class=\"fa fa-fw fa-user-plus\"></span> <span>{{config.label}}</span> </a> </li> <li> <a ng-click=\"showAdvancedSettings=!showAdvancedSettings\"> <span class=\"fa fa-fw\" ng-class=\"{'fa-check-square-o': showAdvancedSettings}\"></span> <span class=\"fa fa-fw fa-user-plus\"></span> <span i18n=habmin.AdvancedMode></span> </a> </li> </ul> </div> <div class=clearfix></div> </div>  <div class=\"list-group habmin-list\" resize-panel> <form name=thingConfigForm novalidate ng-show=selectedBinding style=\"height: 100%\">  <div> <a role=presentation class=\"list-group-item config-panel-title\" ng-class=\"{'active': panelDisplayed=='DESCRIPTION'}\" ng-click=\"setPanelDisplayed('DESCRIPTION')\"> <span class=\"fa fa-fw fa-book\"></span> <span i18n=habmin.Description></span> </a> </div> <div uib-collapse=\"panelDisplayed!='DESCRIPTION'\" class=panel-form> <div class=habmin-info> <label i18n=habmin.Description></label> <div class=\"well well-sm\" ng-bind-html=selectedBinding.description></div> </div> <div class=habmin-info> <label i18n=binding.Author></label> <div class=\"well well-sm\">{{selectedBinding.author}}</div> </div> </div>  <div> <a role=presentation ng-class=\"{'list-group-item config-panel-title':true, 'active': panelDisplayed=='THINGS'}\" ng-click=\"setPanelDisplayed('THINGS')\"> <span class=\"fa fa-fw fa-plug\"></span> <span i18n=binding.ThingTypes></span> </a> </div> <div uib-collapse=\"panelDisplayed!='THINGS'\" class=panel-form> <table class=\"table table-striped\"> <tr ng-repeat=\"thingType in thingTypes | orderBy: 'label'\" class=row ng-if=bindingThingType(thingType)> <td> <div> {{thingType.label}} <span ng-if=thingType.properties.dbReference> <a ng-href=http://www.cd-jackson.com/index.php/zwave/zwave-device-database/zwave-device-list/devicesummary/{{thingType.properties.dbReference}} target=_blank> <span class=\"fa fa-database\"></span> </a> </span> </div> <div class=small>{{thingType.properties.vendor}} {{thingType.properties.modelId}}</div> <div class=\"small single-line\" ng-bind-html=thingType.description></div> </td> </tr> </table> </div>  <div ng-repeat=\"group in bindingConfig.parameterGroups\"> <div> <a role=presentation ng-class=\"{'list-group-item list-group-item-heading':true, 'active': panelDisplayed=='CONFIG-{{group.name}}'}\" ng-click=\"setPanelDisplayed('CONFIG-{{group.name}}')\" ng-if=configGroupAdvanced(group)||showAdvancedSettings> <habmin-icon class=fa-fw cfgcontext={{group.context}}></habmin-icon> <span>{{group.label}}</span> </a> </div> <div uib-collapse=\"$parent.panelDisplayed!='CONFIG-{{group.name}}'\" class=panel-form> <div ng-repeat=\"config in bindingConfig.parameters\"> <div class=form-group ng-if=\"configGroupFilter(config, group.name) && (!config.advanced||showAdvancedSettings)\"> <ng-include src=\"'configuration/eshConfigParam.tpl.html'\"></ng-include> </div> </div> </div> </div>  <div ng-if=bindingHasUngroupedParams()> <div> <a role=presentation ng-class=\"{'list-group-item list-group-item-heading':true, 'active': panelDisplayed=='CONFIG-ungrouped'}\" ng-click=\"setPanelDisplayed('CONFIG-ungrouped')\"> <span class=\"fa fa-fw fa-wrench\"></span> <span i18n=habmin.Configuration></span> </a> </div> <div uib-collapse=\"$parent.panelDisplayed!='CONFIG-ungrouped'\" class=panel-form> <div ng-repeat=\"config in bindingConfig.parameters\"> <div class=form-group ng-if=\"configGroupFilter(config, null) && (!config.advanced||showAdvancedSettings)\"> <ng-include src=\"'configuration/eshConfigParam.tpl.html'\"></ng-include> </div> </div> </div> </div> </form> </div>  <div class=\"panel-footer panel-footer-none\"></div> </div> </div>");
}]);

angular.module("configuration/eshConfigParam.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/eshConfigParam.tpl.html",
    "<label for=CONFIGLABEL-{{cfgType}}-{{config.name}} class=control-label> {{config.label}} </label> <div ng-show=\"cfgStatus.type=='PENDING'\" class=pull-right> <span class=\"label label-warning label-as-badge small\" i18n=thing.Pending></span> </div> <div ng-if=\"config.options!=null && config.options.length!=0 && config.multiple==true\">  <ui-select id=CONFIGLABEL-{{cfgType}}-{{config.name}} ng-model=cfgModel theme=bootstrap name={{config.name}} search-enabled=false multiple limit={{config.multipleLimit}} ng-disabled=config.readOnly> <ui-select-match> {{$item.label}} </ui-select-match> <ui-select-choices repeat=\"option.value as option in config.options\"> <span>{{option.label}}</span> </ui-select-choices> </ui-select> </div> <div ng-if=\"config.options!=null && config.options.length!=0 && config.multiple!=true && config.limitToOptions==true\">  <ui-select id=CONFIGLABEL-{{cfgType}}-{{config.name}} ng-model=cfgModel theme=bootstrap name={{config.name}} search-enabled=false ng-disabled=config.readOnly on-keypress=onComboKeypress> <ui-select-match> {{$select.selected.label}} </ui-select-match> <ui-select-choices repeat=\"option.value as option in config.options\"> <span>{{option.label}}</span> </ui-select-choices> </ui-select> </div> <div ng-if=\"config.options!=null && config.options.length!=0 && config.multiple!=true && config.limitToOptions==false\">  <bootstrap-combo id=CONFIGLABEL-{{cfgType}}-{{config.name}} name={{config.name}} ng-dirty ng-required={{config.required}} ng-model=cfgModel data-dropdown-data=config.options> </bootstrap-combo></div> <div ng-if=\"(config.options==null || config.options.length==0) && config.context=='password'\"> <input id=CONFIGLABEL-{{cfgType}}-{{config.name}} type=password config-parameter={{config}} class=form-control name={{config.name}} ng-dirty ng-required={{config.required}} ng-model=cfgModel> </div> <div ng-if=\"config.options==null || config.options.length==0\"> <input id=CONFIGLABEL-{{cfgType}}-{{config.name}} config-parameter={{config}} class=form-control name={{config.name}} ng-dirty ng-required={{config.required}} ng-model=cfgModel> </div> <p class=\"help-block single-line\" ng-hide=\"config.description==null || config.description.length==0\"> <span class=text-muted ng-bind-html=config.description></span> <span show-overflow class=\"ellipsis text-info fa fa-ellipsis-h\" ng-help-dialog ng-help-title={{config.label}} ng-help-message={{config.description}}> </span> </p>");
}]);

angular.module("configuration/extensionsConfig.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/extensionsConfig.tpl.html",
    "<div class=col-sm-4> <div class=\"panel panel-default\">  <div class=panel-heading> <span i18n=extensions.ExtensionTypes></span> </div>  <div class=\"list-group habmin-list\" resize-panel>  <div ng-if=\"typesCnt>0\" ng-repeat=\"extensionType in extensionTypes | orderBy:'label'\" class=list-group-item ng-class=\"{'active': extensionType==selectedType}\" ng-click=selectType(extensionType)> <li role=presentation> <span>{{extensionType.label}}&nbsp;</span> </li> </div>  <div ng-if=\"typesCnt==-1\" class=\"list-group-item text-center\"> <span class=\"fa fa-spin fa-refresh\"></span> <span i18n=common.loading></span> </div> <div ng-if=\"typesCnt==0\" class=\"list-group-item text-center\"> <span class=\"fa fa-exclamation-triangle text-warning\"></span> <span i18n=binding.NoneFound></span> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>  <div class=col-sm-8> <div class=\"panel panel-default\">  <div class=panel-heading> <span i18n=extensions.Extensions></span> </div>  <div class=\"list-group habmin-list\" resize-panel>  <div ng-if=\"extensionsCnt>0\" class=list-group-item ng-class=\"{'active': extension==selectedType}\" ng-repeat=\"extension in extensions | filter: {type: selectedType.id} | orderBy:'label'\"> <li role=presentation>  <span ng-if=\"extension.version.substring(0, 2)=='0.'\" class=\"label label-success small\">SmartHome</span> <span ng-if=\"extension.version.substring(0, 2)=='1.'\" class=\"label label-warning small\">openHAB-1</span> <span ng-if=\"extension.version.substring(0, 2)=='2.'\" class=\"label label-success small\">openHAB-2</span> <span ng-show=extension.inprogress> <span class=\"fa fa-fw fa-spin fa-circle-o-notch text-warning\"></span> </span> <span ng-hide=extension.inprogress> <span ng-if=extension.installed class=\"fa fa-fw fa-check-circle-o text-success\"></span> <span ng-if=!extension.installed class=\"fa fa-fw fa-circle-o text-muted\"></span> </span> <span>{{extension.label}}&nbsp;  <span ng-if=\"extension.version.substring(0, 2)!='1.' && extension.id.substring(0,8)=='binding-'\"> <a ng-href=http://docs.openhab.org/addons/bindings/{{extension.id.substring(8)}}/readme.html target=_blank> <span class=\"fa fa-book\"></span> </a> </span> </span> <span class=pull-right ng-hide=extension.inprogress> <button type=button class=\"btn btn-xs btn-default\" ng-if=!extension.installed ng-click=installExtension(extension)> <span class=\"fa fa-fw fa-plus-circle text-success\"></span> <span i18n=extensions.Install></span> </button> <button type=button class=\"btn btn-xs btn-default\" ng-if=extension.installed ng-click=uninstallExtension(extension)> <span class=\"fa fa-fw fa-trash text-danger\"></span> <span i18n=extensions.Uninstall></span> </button> </span> </li> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("configuration/itemConfig.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/itemConfig.tpl.html",
    "<div class=col-sm-4> <div class=\"panel panel-default\">  <div class=panel-heading>  <div id=custom-search-form class=input-group> <span class=input-group-addon><span class=\"fa fa-filter\"></span></span> <input class=form-control placeholder={{filterDefaultString}} ng-model=filter.text ng-model-options=\"{debounce: 500}\"> <span class=input-group-addon> <span class=\"fa fa-minus-circle text-danger\" ng-click=\"filter.text=''\"></span> </span> </div> </div>  <div class=\"list-group habmin-list\" resize-panel>  <div ng-if=\"itemsCnt>0\" class=list-group-item ng-class=\"{'active': item==selectedItem}\" ng-click=selectItem(item) ng-repeat=\"item in items | filter:filterFunction\"> <li role=presentation> <table style=\"background-color: transparent\"> <tr> <td class=text-large rowspan=3> <habmin-icon class=\"fa fa-fw\" category={{item.category}}></habmin-icon> </td> <td> <span>{{item.label}}&nbsp;</span> </td> </tr> <tr> <td class=\"text-muted small\"> &nbsp;{{getParentThingItem(item).label}} </td> </tr> <tr> <td class=\"text-muted small\"> <habmin-icon class=\"fa fa-fw\" itemtype={{item.type}}></habmin-icon> &nbsp;{{item.type}} </td> </tr> </table> </li> </div>  <div ng-if=\"bindingsCnt==-1\" class=\"list-group-item text-center\"> <span class=\"fa fa-spin fa-refresh\"></span> <span i18n=common.loading></span> </div> <div ng-if=\"bindingsCnt==0\" class=\"list-group-item text-center\"> <span class=\"fa fa-exclamation-triangle text-warning\"></span> <span i18n=binding.NoneFound></span> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>  <div class=col-sm-8> <div class=\"panel panel-default\">  <div class=panel-heading> <button type=button class=\"btn btn-default\" ng-class=\"{'btn-success': formLoaded&&itemConfigForm.modified}\" ng-click=itemSave() ng-disabled=\"!formLoaded || !itemConfigForm.modified\"> <span class=\"fa fa-floppy-o\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.save></span> </button> <button type=button class=\"btn btn-default\" ng-click=itemConfigForm.reset() ng-disabled=\"!formLoaded || !itemConfigForm.modified\"> <span class=\"fa fa-times\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.cancel></span> </button> <button type=button class=\"btn btn-default\" ng-disabled=\"!formLoaded || newItem\" ng-confirm-click=itemDelete() ng-confirm-icon=warning i18n-attr=\"{'ngConfirmMessage': 'item.DeleteCheck','ngConfirmTitle': 'item.Delete','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes' }\"> <span class=\"fa fa-trash\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.delete></span> </button> <div class=pull-right> {{selectedItem.name}} </div> </div>  <div class=\"list-group habmin-list\" resize-panel> <div ng-if=selectedItem> <div class=habmin-info> <label>Name</label> <div class=\"well well-sm\"> {{selectedItem.name}} </div> </div> <div class=habmin-info> <label>Label</label> <div class=\"well well-sm\"> {{selectedItem.label}} </div> </div> <div class=habmin-info> <label>Format</label> <div class=\"well well-sm\"> {{selectedItem.stateDescription.format}} </div> </div> <div class=habmin-info> <label>Type</label> <div class=\"well well-sm\"> {{selectedItem.type}} </div> </div> <div class=habmin-info> <label>Category</label> <div class=\"well well-sm\"> {{selectedItem.category}} </div> </div> <div class=habmin-info> <label>Tags</label> <div class=\"well well-sm\"> <p ng-repeat=\"tag in selectedItem.tags\"> {{tag}} </p> </div> </div> <div class=habmin-info> <label>Groups</label> <div class=\"well well-sm\"> <p ng-repeat=\"group in selectedItem.groupNames\"> {{group}} </p> </div> </div> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("configuration/itemEdit.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/itemEdit.tpl.html",
    "<div class=modal-header> <h3 class=modal-title i18n=item.EditTitle></h3> </div> <div class=modal-body> <form class=form role=form> <div class=form-group> <label for=inputName class=control-label i18n=item.EditName></label> <div> <input ng-model=item.name class=form-control id=inputName ng-disabled=!newItem i18n-attr=\"{placeholder: 'item.SelectName'}\"> </div> </div> <div class=form-group> <label for=inputLabel class=control-label i18n=item.EditLabel></label> <div> <input ng-model=item.label class=form-control id=inputLabel i18n-attr=\"{placeholder: 'item.SelectLabel'}\"> </div> </div> <div class=form-group> <label for=inputType class=control-label i18n=item.EditType></label> <div> <ui-select id=inputType ng-model=item.type theme=bootstrap search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'item.SelectType'}\"> <habmin-icon class=\"fa fa-fw\" itemtype={{$select.selected.id}}></habmin-icon> {{$select.selected.name}} </ui-select-match> <ui-select-choices repeat=\"type.id as type in itemtypes | orderBy: 'name'\"> <habmin-icon class=\"fa fa-fw\" itemtype={{type.id}}></habmin-icon> <span>{{type.name}}</span> </ui-select-choices> </ui-select> </div> </div> <div class=form-group> <label for=inputCategory class=control-label i18n=item.EditCategory></label> <div> <ui-select id=inputCategory ng-model=item.category theme=bootstrap search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'item.SelectCategory'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.id}}></habmin-icon> {{$select.selected.name}} </ui-select-match> <ui-select-choices repeat=\"category.id as category in categories | orderBy: 'name'\"> <habmin-icon class=\"fa fa-fw\" category={{category.id}}></habmin-icon> <span>{{category.name}}</span> </ui-select-choices> </ui-select> </div> </div> <div class=form-group> <label for=inputTags class=control-label i18n=item.EditTags></label> <div> <ui-select id=inputTags multiple tagging tagging-label=\"(custom 'new' label)\" ng-model=item.tags theme=bootstrap sortable> <ui-select-match placeholder=\"Select colors...\">{{$item}}</ui-select-match> <ui-select-choices repeat=\"color in availableColors | filter:$select.search\"> {{color}} </ui-select-choices> </ui-select> </div> </div> <div class=form-group> <label for=inputGroups class=control-label i18n=item.EditGroups></label> <div> <ui-select id=inputGroups ng-model=item.groupNames theme=bootstrap search-enabled=false multiple> <ui-select-match i18n-attr=\"{placeholder: 'item.SelectGroup'}\"> <habmin-icon class=\"fa fa-fw\" category={{$item.category}}></habmin-icon> {{$item.label}} </ui-select-match> <ui-select-choices repeat=\"group.name as group in items | filter: {type: 'GroupItem'} | orderBy: 'label'\"> <habmin-icon class=\"fa fa-fw\" category={{group.category}}></habmin-icon> <span>{{group.label}}</span> </ui-select-choices> </ui-select> </div> </div> </form> </div> <div class=modal-footer> <button type=button class=\"btn btn-primary\" ng-click=ok() i18n=common.save></button> <button type=button class=\"btn btn-warning\" ng-click=cancel() i18n=common.cancel></button> </div>");
}]);

angular.module("configuration/itemLink.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/itemLink.tpl.html",
    "<div class=modal-header> <h3 class=modal-title i18n=item.LinkTitle></h3> </div> <div class=modal-body> <form class=form role=form> <div class=form-group> <label for=inputItem class=control-label i18n=item.EditName></label> <div> <ui-select id=inputItem ng-model=result.name theme=bootstrap search-enabled=true> <ui-select-match i18n-attr=\"{placeholder: 'item.SelectName'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.category}}></habmin-icon> <span>{{$select.selected.name}}</span> </ui-select-match> <ui-select-choices repeat=\"item.name as item in items | orderBy: 'name' | filter: $select.search\"> <habmin-icon class=\"fa fa-fw\" category={{item.category}}></habmin-icon> <span>{{item.label}}</span><br> <span class=small>{{item.name}}</span> </ui-select-choices> </ui-select> </div> </div> </form> </div> <div class=modal-footer> <button type=button ng-disabled=choiceSelected class=\"btn btn-primary\" ng-click=ok() i18n=common.save></button> <button type=button class=\"btn btn-warning\" ng-click=cancel() i18n=common.cancel></button> </div>");
}]);

angular.module("configuration/itemWidget.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/itemWidget.tpl.html",
    "<span ng-switch=getItem(item).type> <span ng-switch-when=Switch> <span ng-if=channel.channelType.stateDescription.readOnly> {{getValue(channel, getItem(item).state)}} </span> <span ng-if=!channel.channelType.stateDescription.readOnly> <toggle-switch ng-model=getItem(item).state on-label=ON on-value=ON off-label=OFF off-value=OFF></toggle-switch> </span> </span> <span ng-switch-when=Dimmer> <toggle-switch ng-model=getItem(item).state on-label=ON on-value=ON off-label=OFF off-value=OFF></toggle-switch> </span> <span ng-switch-default> {{getValue(channel, getItem(item).state)}} </span> </span>");
}]);

angular.module("configuration/servicesConfig.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/servicesConfig.tpl.html",
    "<div class=col-sm-4> <div class=\"panel panel-default\">  <div class=panel-heading> <span i18n=services.Services></span> {{panelDisplayed}} </div>  <div class=\"list-group habmin-list\" resize-panel>  <div ng-repeat=\"serviceType in serviceTypes | orderBy:'label'\"> <div> <a role=presentation class=\"list-group-item config-panel-title\" ng-class=\"{'active': $parent.panelDisplayed=='SVC-'+serviceType.id}\" ng-click=\"$parent.panelDisplayed='SVC-'+serviceType.id\"> <span class=\"fa fa-fw fa-book\"></span> {{serviceType.label}} </a> </div> <div uib-collapse=\"panelDisplayed!='SVC-'+serviceType.id\"> <div class=list-group-item ng-class=\"{'active': service==selectedService}\" ng-click=selectService(service) ng-repeat=\"service in services | filter: {category: serviceType.id} | orderBy:'label'\"> <li role=presentation> {{service.label}} </li> </div> </div> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>  <div class=col-sm-8> <div class=\"panel panel-default\">  <div class=panel-heading> <button type=button class=\"btn btn-default\" ng-class=\"{'btn-success': formLoaded&&configForm.modified}\" ng-click=configSave() ng-disabled=\"!formLoaded || !configForm.modified\"> <span class=\"fa fa-floppy-o\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.save></span> </button> <button type=button class=\"btn btn-default\" ng-click=configForm.reset() ng-disabled=\"!formLoaded || !configForm.modified\"> <span class=\"fa fa-times\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.cancel></span> </button> </div>  <div class=\"list-group habmin-list\" resize-panel> <form name=configForm novalidate ng-show=selectedService style=height:100%>  <div ng-repeat=\"group in serviceConfig.parameterGroups\"> <div> <a role=presentation class=\"list-group-item list-group-item-heading\" ng-class=\"{'active': $parent.cfgPanelDisplayed=='CONFIG-'+group.name}\" ng-click=\"$parent.cfgPanelDisplayed='CONFIG-'+group.name\" ng-if=configGroupAdvanced(group)||showAdvancedSettings> <habmin-icon class=fa-fw cfgcontext={{group.context}}></habmin-icon> <span>{{group.label}} {{$parent.cfgPanelDisplayed}}</span> </a> </div> <div uib-collapse=\"$parent.cfgPanelDisplayed!='CONFIG-{{group.name}}'\" class=panel-form> <div ng-repeat=\"config in serviceConfig.parameters\"> <div class=form-group ng-if=\"configGroupFilter(config, group.name) && (!config.advanced||showAdvancedSettings)\"> <ng-include ng-init=\"cfgType='CONFIG';cfgModel=serviceConfiguration[config.name]\" src=\"'configuration/eshConfigParam.tpl.html'\"></ng-include> </div> </div> </div> </div>  <div ng-if=hasUngroupedParams()> <div> <a role=presentation class=\"list-group-item list-group-item-heading\" ng-class=\"{'active': $parent.cfgPanelDisplayed=='CONFIG-ungrouped'}\" ng-click=\"$parent.cfgPanelDisplayed='CONFIG-ungrouped'\"> <span class=\"fa fa-fw fa-wrench\"></span> <span i18n=thing.Configuration></span> </a> </div> <div uib-collapse=\"$parent.cfgPanelDisplayed!='CONFIG-ungrouped'\" class=panel-form> <div ng-repeat=\"config in serviceConfig.parameters\"> <div class=form-group ng-if=\"configGroupFilter(config, null) && (!config.advanced||showAdvancedSettings)\"> <ng-include ng-init=\"cfgType='CONFIG';cfgModel=serviceConfiguration[config.name]\" src=\"'configuration/eshConfigParam.tpl.html'\"></ng-include> </div> </div> </div> </div> </form> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("configuration/thingAttributesZWave.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/thingAttributesZWave.tpl.html",
    "<div class=row> <div class=col-md-4 i18n=zwave.Manufacturer></div> <div class=col-md-8 ng-if=\"selectedThing.properties['zwave_manufacturer']\"> {{dec2hex(selectedThing.properties['zwave_manufacturer'], 4)}} <span class=\"fa fa-quote-left\"></span> <span ng-switch on=\"selectedThing.properties['zwave_manufacturer']\"> <span ng-switch-when=65535>Not defined</span> <span ng-switch-when=40>2B Electronics</span> <span ng-switch-when=155>2gig Technologies Inc.</span> <span ng-switch-when=42>3e Technologies</span> <span ng-switch-when=34>A-1 Components</span> <span ng-switch-when=279>Abilia</span> <span ng-switch-when=1>ACT - Advanced Control Technologies</span> <span ng-switch-when=257>ADOX, Inc.</span> <span ng-switch-when=364>Advanced Optronic Devices Co.,Ltd</span> <span ng-switch-when=158>Adventure Interactive</span> <span ng-switch-when=134>AEON Labs</span> <span ng-switch-when=273>Airline Mechanical Co., Ltd.</span> <span ng-switch-when=136>Airvent SAM S.p.A.</span> <span ng-switch-when=148>Alarm.com</span> <span ng-switch-when=294>Alertme</span> <span ng-switch-when=59>Allegion</span> <span ng-switch-when=560>Alphonsus Tech</span> <span ng-switch-when=412>Amdocs</span> <span ng-switch-when=90>American Grid, Inc.</span> <span ng-switch-when=120>anyCOMM Corporation</span> <span ng-switch-when=324>Applied Micro Electronics \\\"AME\\\" BV</span> <span ng-switch-when=41>Asia Heading</span> <span ng-switch-when=561>ASITEQ</span> <span ng-switch-when=297>ASSA ABLOY</span> <span ng-switch-when=315>AstraLink</span> <span ng-switch-when=308>AT&T</span> <span ng-switch-when=43>Atech</span> <span ng-switch-when=580>Athom BV</span> <span ng-switch-when=341>Avadesign Technology Co., Ltd.</span> <span ng-switch-when=326>Axesstel Inc</span> <span ng-switch-when=24>Balboa Instruments</span> <span ng-switch-when=566>Bandi Comm Tech Inc.</span> <span ng-switch-when=516>Beijing Sino-American Boyi Software Development Co., Ltd</span> <span ng-switch-when=593>Beijing Universal Energy Huaxia Technology Co.,Ltd</span> <span ng-switch-when=406>Bellatrix Systems, Inc.</span> <span ng-switch-when=138>BeNext</span> <span ng-switch-when=44>BeSafer</span> <span ng-switch-when=331>BFT S.p.A.</span> <span ng-switch-when=82>Bit7 Inc.</span> <span ng-switch-when=144>Black & Decker</span> <span ng-switch-when=531>BMS Evler LTD</span> <span ng-switch-when=35>Boca Devices</span> <span ng-switch-when=348>Bosch Security Systems, Inc</span> <span ng-switch-when=312>BRK Brands, Inc.</span> <span ng-switch-when=45>Broadband Energy Networks Inc.</span> <span ng-switch-when=586>BTSTAR(HK) TECHNOLOGY COMPANY LIMITED</span> <span ng-switch-when=325>Buffalo Inc.</span> <span ng-switch-when=400>Building 36 Technologies</span> <span ng-switch-when=38>BuLogics</span> <span ng-switch-when=361>Bönig und Kallenbach oHG</span> <span ng-switch-when=156>Cameo Communications Inc.</span> <span ng-switch-when=46>Carrier</span> <span ng-switch-when=11>CasaWorks</span> <span ng-switch-when=579>casenio AG</span> <span ng-switch-when=358>CBCC Domotique SAS</span> <span ng-switch-when=582>CentraLite Systems, Inc</span> <span ng-switch-when=334>Check-It Solutions Inc.</span> <span ng-switch-when=278>Chromagic Technologies Corporation</span> <span ng-switch-when=130>Cisco Consumer Business Group</span> <span ng-switch-when=398>Climax Technology, Ltd.</span> <span ng-switch-when=512>Cloud Media</span> <span ng-switch-when=47>Color Kinetics Incorporated</span> <span ng-switch-when=320>Computime</span> <span ng-switch-when=283>Connected Object</span> <span ng-switch-when=377>ConnectHome</span> <span ng-switch-when=25>ControlThink LC</span> <span ng-switch-when=15>ConvergeX Ltd.</span> <span ng-switch-when=125>CoolGuard</span> <span ng-switch-when=121>Cooper Lighting</span> <span ng-switch-when=26>Cooper Wiring Devices</span> <span ng-switch-when=157>Coventive Technologies Inc.</span> <span ng-switch-when=20>Cyberhouse</span> <span ng-switch-when=103>CyberTAN Technology, Inc.</span> <span ng-switch-when=48>Cytech Technology Pre Ltd.</span> <span ng-switch-when=2>Danfoss</span> <span ng-switch-when=396>Dawon DNS</span> <span ng-switch-when=522>Decoris Intelligent System Limited</span> <span ng-switch-when=319>Defacontrols BV</span> <span ng-switch-when=49>Destiny Networks</span> <span ng-switch-when=373>Devolo</span> <span ng-switch-when=259>Diehl AKO</span> <span ng-switch-when=50>Digital 5, Inc.</span> <span ng-switch-when=590>Digital Home Systems Pty Ltd,</span> <span ng-switch-when=552>DigitalZone</span> <span ng-switch-when=264>D-Link</span> <span ng-switch-when=295>DMP (Digital Monitoring Products)</span> <span ng-switch-when=375>Domino sistemi d.o.o.</span> <span ng-switch-when=526>Domitech Products, LLC</span> <span ng-switch-when=524>Dongguan Zhou Da Electronics Co.,Ltd</span> <span ng-switch-when=381>DRACOR Inc.</span> <span ng-switch-when=388>Dragon Tech Industrial, Ltd.</span> <span ng-switch-when=547>DTV Research Unipessoal, Lda</span> <span ng-switch-when=306>DynaQuip Controls</span> <span ng-switch-when=583>EASY SAVER Co., Inc</span> <span ng-switch-when=380>EbV</span> <span ng-switch-when=363>Echostar</span> <span ng-switch-when=330>Ecolink</span> <span ng-switch-when=343>EcoNet Controls</span> <span ng-switch-when=269>e-Home AUTOMATION</span> <span ng-switch-when=135>Eka Systems</span> <span ng-switch-when=51>Electronic Solutions</span> <span ng-switch-when=543>Elexa Consumer Products Inc.</span> <span ng-switch-when=52>El-Gev Electronics LTD</span> <span ng-switch-when=27>ELK Products, Inc.</span> <span ng-switch-when=523>Embedded System Design Limited</span> <span ng-switch-when=53>Embedit A/S</span> <span ng-switch-when=333>Enblink Co. Ltd</span> <span ng-switch-when=537>Enwox Technologies s.r.o.</span> <span ng-switch-when=111>Erone</span> <span ng-switch-when=352>Essence Security</span> <span ng-switch-when=328>Eurotronics</span> <span ng-switch-when=96>Everspring</span> <span ng-switch-when=275>Evolve</span> <span ng-switch-when=54>Exceptional Innovations</span> <span ng-switch-when=4>Exhausto</span> <span ng-switch-when=159>Exigent Sensors</span> <span ng-switch-when=30>Express Controls</span> <span ng-switch-when=563>eZEX Corporation</span> <span ng-switch-when=133>Fakro</span> <span ng-switch-when=362>Fantem</span> <span ng-switch-when=271>Fibargroup</span> <span ng-switch-when=397>Flextronics</span> <span ng-switch-when=36>Flue Sentinel</span> <span ng-switch-when=55>Foard Systems</span> <span ng-switch-when=399>Focal Point Limited</span> <span ng-switch-when=311>FollowGood Technology Company Ltd.</span> <span ng-switch-when=519>Forest Group Nederland B.V</span> <span ng-switch-when=132>FortrezZ LLC</span> <span ng-switch-when=285>Foxconn</span> <span ng-switch-when=272>Frostdale</span> <span ng-switch-when=602>GES</span> <span ng-switch-when=555>GKB Security Corporation</span> <span ng-switch-when=394>Globalchina-Tech</span> <span ng-switch-when=345>Goap</span> <span ng-switch-when=118>Goggin Research</span> <span ng-switch-when=104>Good Way Technology Co., Ltd</span> <span ng-switch-when=153>GreenWave Reality Inc.</span> <span ng-switch-when=395>Grib</span> <span ng-switch-when=365>Guangzhou Ruixiang M&E Co., Ltd</span> <span ng-switch-when=344>GuangZhou Zeewave Information Technology Co., Ltd.</span> <span ng-switch-when=588>Hankook Gas Kiki CO.,LTD.</span> <span ng-switch-when=604>Hauppauge</span> <span ng-switch-when=115>Hawking Technologies Inc.</span> <span ng-switch-when=527>Herald Datanetics Limited</span> <span ng-switch-when=23>HiTech Automation</span> <span ng-switch-when=385>Holion Electronic Engineering Co., Ltd</span> <span ng-switch-when=318>Holtec Electronics BV</span> <span ng-switch-when=13>Home Automated Living</span> <span ng-switch-when=154>Home Automation Europe</span> <span ng-switch-when=91>Home Automation Inc.</span> <span ng-switch-when=56>Home Director</span> <span ng-switch-when=112>Homemanageables, Inc.</span> <span ng-switch-when=80>Homepro</span> <span ng-switch-when=354>HomeScenario</span> <span ng-switch-when=12>HomeSeer Technologies</span> <span ng-switch-when=573>Honest Technology Co., Ltd.</span> <span ng-switch-when=57>Honeywell</span> <span ng-switch-when=89>Horstmann Controls Limited</span> <span ng-switch-when=545>HOSEOTELNET</span> <span ng-switch-when=384>Huapin Information Technology Co.,Ltd</span> <span ng-switch-when=587>Huawei Technologies Co., Ltd.</span> <span ng-switch-when=124>Hunter Douglas</span> <span ng-switch-when=536>iAutomade Pte Ltd</span> <span ng-switch-when=17>iCOM Technology b.v.</span> <span ng-switch-when=262>iControl</span> <span ng-switch-when=262>Icontrol Networks</span> <span ng-switch-when=357>ID-RF</span> <span ng-switch-when=414>iEXERGY GmbH</span> <span ng-switch-when=86>Impact Technologies and Products</span> <span ng-switch-when=97>Impact Technologies BV</span> <span ng-switch-when=299>Infusion Development</span> <span ng-switch-when=108>Ingersoll Rand (Schlage)</span> <span ng-switch-when=287>Ingersoll Rand (was Ecolink)</span> <span ng-switch-when=598>Inkel Corp.</span> <span ng-switch-when=58>Inlon Srl</span> <span ng-switch-when=321>Innoband Technologies, Inc</span> <span ng-switch-when=119>INNOVUS</span> <span ng-switch-when=256>Insignia</span> <span ng-switch-when=6>Intel</span> <span ng-switch-when=28>IntelliCon</span> <span ng-switch-when=114>Interactive Electronics Systems (IES)</span> <span ng-switch-when=5>Intermatic</span> <span ng-switch-when=19>Internet Dom</span> <span ng-switch-when=95>IQ-Group</span> <span ng-switch-when=530>iRevo</span> <span ng-switch-when=595>iungo.nl B.V.</span> <span ng-switch-when=291>IWATSU</span> <span ng-switch-when=99>Jasco Products</span> <span ng-switch-when=346>Jin Tao Bao</span> <span ng-switch-when=356>JSW Pacific Corporation</span> <span ng-switch-when=532>Kaipule Technology Co., Ltd.</span> <span ng-switch-when=145>Kamstrup A/S</span> <span ng-switch-when=106>Kellendonk Elektronik</span> <span ng-switch-when=276>Kichler</span> <span ng-switch-when=372>Kopera Development Inc.</span> <span ng-switch-when=570>KUMHO ELECTRIC, INC</span> <span ng-switch-when=81>Lagotek Corporation</span> <span ng-switch-when=371>Leak Intelligence, LLC</span> <span ng-switch-when=391>LEVION Technologies Gmbh</span> <span ng-switch-when=29>Leviton</span> <span ng-switch-when=21>Lexel</span> <span ng-switch-when=347>LG Electronics</span> <span ng-switch-when=548>LifeShield, LLC</span> <span ng-switch-when=60>Lifestyle Networks</span> <span ng-switch-when=528>Light Engine Limited</span> <span ng-switch-when=335>Linear Corp</span> <span ng-switch-when=378>Liveguard Ltd.</span> <span ng-switch-when=314>Living Style Enterprises, Ltd.</span> <span ng-switch-when=350>Locstar Technology Co., Ltd</span> <span ng-switch-when=127>Logitech</span> <span ng-switch-when=37>Loudwater Technologies, LLC</span> <span ng-switch-when=113>LS Control</span> <span ng-switch-when=98>LVI Produkter AB</span> <span ng-switch-when=405>M2M Solution</span> <span ng-switch-when=110>Manodo / KTC</span> <span ng-switch-when=61>Marmitek BV</span> <span ng-switch-when=62>Martec Access Products</span> <span ng-switch-when=146>Martin Renz GmbH</span> <span ng-switch-when=143>MB Turn Key Design</span> <span ng-switch-when=351>McoHome Technology Co., Ltd</span> <span ng-switch-when=546>MCT CO., LTD</span> <span ng-switch-when=39>Meedio, LLC</span> <span ng-switch-when=263>MegaChips</span> <span ng-switch-when=557>Mercury Corporation</span> <span ng-switch-when=122>Merten</span> <span ng-switch-when=568>Milanity, Inc.</span> <span ng-switch-when=274>MITSUMI</span> <span ng-switch-when=413>MOBILUS MOTOR Spólka z o.o.</span> <span ng-switch-when=562>MODACOM CO., LTD.</span> <span ng-switch-when=141>Modstrøm</span> <span ng-switch-when=14>Mohito Networks</span> <span ng-switch-when=514>Monoprice</span> <span ng-switch-when=126>Monster Cable</span> <span ng-switch-when=293>Motion Control Systems</span> <span ng-switch-when=63>Motorola</span> <span ng-switch-when=290>MSK - Miyakawa Seisakusho</span> <span ng-switch-when=131>MTC Maintronic Germany</span> <span ng-switch-when=323>myStrom</span> <span ng-switch-when=366>Nanjing Easthouse Electrical Co., Ltd.</span> <span ng-switch-when=289>Napco Security Technologies, Inc.</span> <span ng-switch-when=109>Nefit</span> <span ng-switch-when=393>Ness Corporation Pty Ltd</span> <span ng-switch-when=307>Netgear</span> <span ng-switch-when=515>Newland Communication Science Technology Co., Ltd.</span> <span ng-switch-when=376>Nexia Home Intelligence</span> <span ng-switch-when=117>NextEnergy</span> <span ng-switch-when=389>Ningbo Sentek Electronics Co., Ltd</span> <span ng-switch-when=594>North China University of Technology</span> <span ng-switch-when=150>NorthQ</span> <span ng-switch-when=64>Novar Electrical Devices and Systems (EDS)</span> <span ng-switch-when=525>Novateqni HK Ltd</span> <span ng-switch-when=281>Omnima Limited</span> <span ng-switch-when=332>OnSite Pro</span> <span ng-switch-when=65>OpenPeak Inc.</span> <span ng-switch-when=260>Panasonic Electric Works Co., Ltd.</span> <span ng-switch-when=599>PARATECH</span> <span ng-switch-when=370>PassivSystems Limited</span> <span ng-switch-when=317>Pella</span> <span ng-switch-when=581>permundo GmbH</span> <span ng-switch-when=316>Philio Technology Corp</span> <span ng-switch-when=336>Physical Graph Corporation</span> <span ng-switch-when=123>PiTech</span> <span ng-switch-when=270>Poly-control</span> <span ng-switch-when=340>Popp & Co</span> <span ng-switch-when=368>Powerhouse Dynamics</span> <span ng-switch-when=116>PowerLinx</span> <span ng-switch-when=22>PowerLynx</span> <span ng-switch-when=66>Pragmatic Consulting Inc.</span> <span ng-switch-when=296>Prodrive Technologies</span> <span ng-switch-when=353>Promixis, LLC</span> <span ng-switch-when=93>Pulse Technologies (Aspalis)</span> <span ng-switch-when=149>Qees</span> <span ng-switch-when=298>Qolsys</span> <span ng-switch-when=304>Quby</span> <span ng-switch-when=355>Queenlock Ind. Co., Ltd.</span> <span ng-switch-when=322>Rademacher Geräte-Elektronik GmbH & Co. KG</span> <span ng-switch-when=152>Radio Thermostat Company of America (RTC)</span> <span ng-switch-when=142>Raritan</span> <span ng-switch-when=542>Red Bee Co. Ltd</span> <span ng-switch-when=100>Reitz-Group.de</span> <span ng-switch-when=556>Remote Solution</span> <span ng-switch-when=21076>Remotec</span> <span ng-switch-when=16>Residential Control Systems, Inc. (RCS)</span> <span ng-switch-when=534>RET Nanjing Intelligence System CO.,Ltd</span> <span ng-switch-when=339>Revolv Inc</span> <span ng-switch-when=327>R-import Ltd.</span> <span ng-switch-when=571>ROC-Connect, Inc.</span> <span ng-switch-when=407>RPE Ajax LLC (dbs Secur Ltd)</span> <span ng-switch-when=101>RS Scene Automation</span> <span ng-switch-when=572>SafeTech Products</span> <span ng-switch-when=513>Samsung Electronics Co., Ltd.</span> <span ng-switch-when=558>Samsung SDS</span> <span ng-switch-when=147>San Shih Electrical Enterprise Co., Ltd.</span> <span ng-switch-when=300>SANAV</span> <span ng-switch-when=31>Scientia Technologies, Inc.</span> <span ng-switch-when=286>Secure Wireless</span> <span ng-switch-when=359>SecureNet Technologies</span> <span ng-switch-when=386>Securifi Ltd.</span> <span ng-switch-when=105>Seluxit</span> <span ng-switch-when=67>Senmatic A/S</span> <span ng-switch-when=410>Sensative AB</span> <span ng-switch-when=68>Sequoia Technology LTD</span> <span ng-switch-when=337>Sercomm Corp</span> <span ng-switch-when=533>Shangdong Smart Life Data System Co.,Ltd</span> <span ng-switch-when=574>Shanghai Dorlink Intelligent Technologies Co.,Ltd</span> <span ng-switch-when=517>Shanghai Longchuang Eco-energy Systems Co., Ltd</span> <span ng-switch-when=267>Sharp</span> <span ng-switch-when=538>SHENZHEN AOYA INDUSTRY CO. LTD</span> <span ng-switch-when=540>Shenzhen iSurpass Technology Co. ,Ltd</span> <span ng-switch-when=541>Shenzhen Kaadas Intelligent Technology Co., Ltd</span> <span ng-switch-when=529>Shenzhen Liao Wang Tong Da Technology Ltd</span> <span ng-switch-when=600>Shenzhen Neo Electronics Co., Ltd</span> <span ng-switch-when=592>Shenzhen Tripath Digital Audio Equipment Co.,Ltd</span> <span ng-switch-when=129>SIEGENIA-AUBI KG</span> <span ng-switch-when=0>Sigma Designs (Former Zensys)</span> <span ng-switch-when=69>Sine Wireless</span> <span ng-switch-when=70>Smart Products, Inc.</span> <span ng-switch-when=591>Smartly AS</span> <span ng-switch-when=258>SMK Manufacturing Inc.</span> <span ng-switch-when=71>Somfy</span> <span ng-switch-when=596>Spectrum Brands</span> <span ng-switch-when=292>Square Connect</span> <span ng-switch-when=539>ST&T Electric Corporation</span> <span ng-switch-when=601>Starkoff</span> <span ng-switch-when=569>Stelpro</span> <span ng-switch-when=535>Strattec Advanced Logic,LLC</span> <span ng-switch-when=360>STRATTEC Security Corporation</span> <span ng-switch-when=261>Sumitomo</span> <span ng-switch-when=84>Superna</span> <span ng-switch-when=401>Swann Communications Pty Ltd</span> <span ng-switch-when=9>Sylvania</span> <span ng-switch-when=310>Systech Corporation</span> <span ng-switch-when=565>TAEWON Lighting Co., Ltd.</span> <span ng-switch-when=390>Team Digital Limited</span> <span ng-switch-when=137>Team Precision PCL</span> <span ng-switch-when=576>Technicolor</span> <span ng-switch-when=10>Techniku</span> <span ng-switch-when=303>Tecom Co., Ltd.</span> <span ng-switch-when=18>Tell It Online</span> <span ng-switch-when=374>Telldus Technologies AB</span> <span ng-switch-when=72>Telsey</span> <span ng-switch-when=382>Telular</span> <span ng-switch-when=92>Terra Optima B.V. (tidligere Primair Services)</span> <span ng-switch-when=268>There Corporation</span> <span ng-switch-when=411>ThermoFloor</span> <span ng-switch-when=554>TIMEVALVE, Inc.</span> <span ng-switch-when=280>TKB Home</span> <span ng-switch-when=284>TKH Group / Eminent</span> <span ng-switch-when=139>Trane Corporation</span> <span ng-switch-when=102>TrickleStar</span> <span ng-switch-when=107>Tricklestar Ltd. (former Empower Controls Ltd.)</span> <span ng-switch-when=85>Tridium</span> <span ng-switch-when=73>Twisthink</span> <span ng-switch-when=338>UFairy G.R. Tech</span> <span ng-switch-when=403>Universal Devices, Inc</span> <span ng-switch-when=32>Universal Electronics Inc.</span> <span ng-switch-when=387>Universe Future</span> <span ng-switch-when=521>UTC Fire and Security Americas Corp</span> <span ng-switch-when=266>VDA</span> <span ng-switch-when=408>Venstar Inc.</span> <span ng-switch-when=140>Vera Control</span> <span ng-switch-when=128>Vero Duco</span> <span ng-switch-when=567>Vestel Elektronik Ticaret ve Sanayi A.S.</span> <span ng-switch-when=83>Viewsonic</span> <span ng-switch-when=94>ViewSonic Corporation</span> <span ng-switch-when=7>Vimar CRS</span> <span ng-switch-when=392>Vipa-Star</span> <span ng-switch-when=265>Vision Security</span> <span ng-switch-when=74>Visualize</span> <span ng-switch-when=88>Vitelec</span> <span ng-switch-when=342>Vivint</span> <span ng-switch-when=379>Vs-Safety AS</span> <span ng-switch-when=75>Watt Stopper</span> <span ng-switch-when=8>Wayne Dalton</span> <span ng-switch-when=415>Webee Life</span> <span ng-switch-when=369>WeBeHome AB</span> <span ng-switch-when=282>Wenzhou MTLC Electric Appliances Co.,Ltd.</span> <span ng-switch-when=87>Whirlpool</span> <span ng-switch-when=329>wiDom</span> <span ng-switch-when=349>Willis Electric Co., Ltd.</span> <span ng-switch-when=301>Wilshine Holding Co., Ltd</span> <span ng-switch-when=383>Wink Inc.</span> <span ng-switch-when=151>Wintop</span> <span ng-switch-when=578>Winytechnology</span> <span ng-switch-when=409>Wireless Maingate AB</span> <span ng-switch-when=76>Woodward Labs</span> <span ng-switch-when=3>Wr@p</span> <span ng-switch-when=559>WRT Intelligent Technology CO., LTD.</span> <span ng-switch-when=302>Wuhan NWD Technology Co., Ltd.</span> <span ng-switch-when=77>Xanboo</span> <span ng-switch-when=78>Zdata, LLC.</span> <span ng-switch-when=367>Zhejiang Jiuxing Electric Co Ltd</span> <span ng-switch-when=313>Zhome</span> <span ng-switch-when=305>Zipato</span> <span ng-switch-when=288>Zonoff</span> <span ng-switch-when=79>Z-Wave Technologia</span> <span ng-switch-when=277>Z-Wave.Me</span> <span ng-switch-when=589>Z-works Inc.</span> <span ng-switch-when=33>Zykronix</span> <span ng-switch-when=309>ZyXEL</span> <span ng-switch-default>Unknown Manufacturer</span> <span class=\"fa fa-quote-right\"></span> </span></div> </div> <div class=row> <div class=col-md-4 i18n=zwave.TypeId></div> <div class=col-md-8 ng-if=\"selectedThing.properties['zwave_devicetype']\"> {{dec2hex(selectedThing.properties['zwave_devicetype'],4)}}:{{dec2hex(selectedThing.properties['zwave_deviceid'],4)}} </div> </div> <div class=row> <div class=col-md-4 i18n=zwave.FirmwareVersion></div> <div class=col-md-8>{{selectedThing.properties['zwave_version']}}</div> </div> <div class=row ng-if=\"selectedThing.properties['zwave_plus_devicetype']\"> <div class=col-md-4 i18n=zwave.ZWavePlusDeviceType></div> <div class=col-md-8>{{selectedThing.properties['zwave_plus_devicetype']}}</div> </div> <div class=row ng-if=\"selectedThing.properties['zwave_plus_roletype']\"> <div class=col-md-4 i18n=zwave.ZWavePlusRoleType></div> <div class=col-md-8>{{selectedThing.properties['zwave_plus_roletype']}}</div> </div> <div class=row> <div class=col-md-4 i18n=zwave.BasicClass></div> <div class=col-md-8>{{selectedThing.properties['zwave_class_basic']}}</div> </div> <div class=row> <div class=col-md-4 i18n=zwave.GenericClass></div> <div class=col-md-8>{{selectedThing.properties['zwave_class_generic']}}</div> </div> <div class=row> <div class=col-md-4 i18n=zwave.SpecificClass></div> <div class=col-md-8>{{selectedThing.properties['zwave_class_specific']}}</div> </div> <div class=row> <div class=col-md-4 i18n=zwave.UsingSecurity></div> <div class=col-md-8> <span ng-switch=\"selectedThing.properties['zwave_secure']\"> <span ng-switch-when=true class=\"fa fa-check-circle-o text-success\"></span> <span ng-switch-when=false class=\"fa fa-times-circle-o text-danger\"></span> <span ng-switch-default class=\"fa fa-question-circle-o text-warning\"></span> </span> </div> </div> <div class=row> <div class=col-md-4 i18n=zwave.Routing></div> <div class=col-md-8> <span ng-switch=\"selectedThing.properties['zwave_routing']\"> <span ng-switch-when=true class=\"fa fa-check-circle-o text-success\"></span> <span ng-switch-when=false class=\"fa fa-times-circle-o text-danger\"></span> <span ng-switch-default class=\"fa fa-question-circle-o text-warning\"></span> </span> </div> </div> <div class=row> <div class=col-md-4 i18n=zwave.Listening></div> <div class=col-md-8> <span ng-switch=\"selectedThing.properties['zwave_listening']\"> <span ng-switch-when=true class=\"fa fa-check-circle-o text-success\"></span> <span ng-switch-when=false class=\"fa fa-times-circle-o text-danger\"></span> <span ng-switch-default class=\"fa fa-question-circle-o text-warning\"></span> </span> </div> </div> <div class=row> <div class=col-md-4 i18n=zwave.FrequentlyListening></div> <div class=col-md-8> <span ng-switch=\"selectedThing.properties['zwave_frequent']\"> <span ng-switch-when=true class=\"fa fa-check-circle-o text-success\"></span> <span ng-switch-when=false class=\"fa fa-times-circle-o text-danger\"></span> <span ng-switch-default class=\"fa fa-question-circle-o text-warning\"></span> </span> </div> </div> <div class=row> <div class=col-md-4 i18n=zwave.Beaming></div> <div class=col-md-8> <span ng-switch=\"selectedThing.properties['zwave_beaming']\"> <span ng-switch-when=true class=\"fa fa-check-circle-o text-success\"></span> <span ng-switch-when=false class=\"fa fa-times-circle-o text-danger\"></span> <span ng-switch-default class=\"fa fa-question-circle-o text-warning\"></span> </span> </div> </div> <div class=row ng-if=\"selectedThing.properties['zwave_lastwakeup']\"> <div class=col-md-4 i18n=zwave.WakeupTime></div> <div class=col-md-8> <span>{{selectedThing.properties['zwave_lastwakeup'] | amUtc | amLocal | amDateFormat:'dddd, MMMM Do YYYY, HH:mm:ss'}}</span> <span class=\"fa fa-history text-muted\"></span> <span am-time-ago=\"selectedThing.properties['zwave_lastwakeup']\"></span> </div> </div> <div class=row ng-if=\"selectedThing.properties['zwave_wakeup_time']\"> <div class=col-md-4 i18n=zwave.WakeupTime></div> <div class=col-md-8> <span>{{selectedThing.properties['zwave_wakeup_time'] | amUtc | amLocal | amDateFormat:'dddd, MMMM Do YYYY, HH:mm:ss'}}</span> <span class=\"fa fa-history text-muted\"></span> <span am-time-ago=\"selectedThing.properties['zwave_wakeup_time']\"></span> </div> </div> <div class=row ng-if=\"selectedThing.properties['zwave_neighbours']\"> <div class=col-md-4 i18n=zwave.Neighbors></div> <div class=col-md-8> {{selectedThing.properties['zwave_neighbours'].split(\",\").length}} nodes <span class=\"fa fa-exchange text-muted\"></span> {{selectedThing.properties['zwave_neighbours'].split(\",\").join(\", \")}} </div> </div> <div class=row ng-if=\"selectedThing.properties['zwave_lastheal']\"> <div class=col-md-4 i18n=zwave.LastHeal></div> <div class=col-md-8> <span>{{selectedThing.properties['zwave_lastheal'] | amUtc | amLocal | amDateFormat:'dddd, MMMM Do YYYY, HH:mm:ss'}}</span> <span class=\"fa fa-history text-muted\"></span> <span am-time-ago=\"selectedThing.properties['zwave_lastheal']\"></span> </div> </div>");
}]);

angular.module("configuration/thingConfig.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/thingConfig.tpl.html",
    "<div class=col-sm-4> <div class=\"panel panel-default\">  <div class=panel-heading> <div class=btn-group uib-dropdown>  <button type=button class=\"btn btn-default\" uib-dropdown-toggle> <span ng-class=\"{'fa fa-filter': true, 'text-warning': filterBindings.length || filterStatus.length}\"></span> <span i18n=common.filter></span> <span class=caret></span> </button> <ul class=dropdown-menu uib-dropdown-menu role=menu aria-labelledby=single-button> <li> <a ng-click=\"toggleStatusFilter('UNINITIALIZED')\"> <span ng-class=\"{'fa fa-fw': true, 'fa-check-square-o': filterStatus.indexOf('UNINITIALIZED')==-1}\"></span> <span class=\"fa fa-fw fa-question-circle text-muted\"></span> <span i18n=thing.StatusUninitialised></span> </a> </li> <li> <a ng-click=\"toggleStatusFilter('INITIALIZING')\"> <span ng-class=\"{'fa fa-fw': true, 'fa-check-square-o': filterStatus.indexOf('INITIALIZING')==-1}\"></span> <span class=\"fa fa-fw fa-gears text-info\"></span> <span i18n=thing.StatusInitialising></span> </a> </li> <li> <a ng-click=\"toggleStatusFilter('ONLINE')\"> <span ng-class=\"{'fa fa-fw': true, 'fa-check-square-o': filterStatus.indexOf('ONLINE')==-1}\"></span> <span class=\"fa fa-fw fa-check-circle text-success\"></span> <span i18n=thing.StatusOnline></span> </a> </li> <li> <a ng-click=\"toggleStatusFilter('OFFLINE')\"> <span ng-class=\"{'fa fa-fw': true, 'fa-check-square-o': filterStatus.indexOf('OFFLINE')==-1}\"></span> <span class=\"fa fa-fw fa-times-circle text-danger\"></span> <span i18n=thing.StatusOffline></span> </a> </li> <li> <a ng-click=\"toggleStatusFilter('REMOVING');toggleStatusFilter('REMOVED')\"> <span ng-class=\"{'fa fa-fw': true, 'fa-check-square-o': filterStatus.indexOf('REMOVING')==-1 || filterStatus.indexOf('REMOVED')!=-1}\"></span> <span class=\"fa fa-fw fa-warning text-warning\"></span> <span i18n=thing.StatusRemoving></span> </a> </li> <li role=presentation class=divider></li> <li ng-repeat=\"binding in bindings | orderBy:'name'\" ng-class=\"{'disabled': binding.disabled}\"> <a ng-click=toggleBindingFilter(binding)> <span ng-class=\"{'fa-fw fa': true, 'fa-check-square-o': filterBindings.indexOf(binding.id)!=-1}\"></span> <habmin-icon class=\"fa fa-fw\" icon={{binding.icon}}></habmin-icon> <span>{{binding.name}}</span> </a> </li> </ul> </div> </div>  <div class=\"list-group habmin-list\" resize-panel>  <div ng-if=\"thingCnt!=-1 && insertMode==false\" class=list-group-item ng-class=\"{'active': thing.UID==selectedThing.UID, 'disabled': getThingType(thing)==null}\" ng-repeat=\"thing in things | filter:filterFunction | orderBy:'label'\" ng-click=selectThing(thing)> <li role=presentation class=list-group-item-detail> <table style=\"background-color: transparent\"> <tr> <td class=text-large rowspan=2> <span ng-switch=thing.statusInfo.status tooltip-placement=top tooltip={{thing.statusInfo.description}} tooltip-popup-delay=500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true> <span ng-switch-when=ONLINE class=\"fa fa-fw fa-check-circle text-success\"></span> <span ng-switch-when=OFFLINE class=\"fa fa-fw fa-times-circle text-danger\"></span> <span ng-switch-when=INITIALIZING class=\"fa fa-fw fa-gears text-info\"></span> <span ng-switch-when=REMOVING class=\"fa fa-fw fa-warning text-warning\"></span> <span ng-switch-when=REMOVED class=\"fa fa-fw fa-warning text-danger\"></span> <span ng-switch-default class=\"fa fa-fw fa-question-circle text-muted\"></span> </span> </td> <td> <span>&nbsp;{{thing.label}}</span> </td> </tr> <tr> <td class=\"text-muted small\">&nbsp;&nbsp;{{getThingType(thing).label}} </td> </tr> <tr ng-if=\"getThingType(thing)==null\"> <td> <button type=button class=\"btn btn-xs btn-default\" ng-confirm-click=\"thingDelete(thing, true)\" i18n-attr=\"{'ngConfirmMessage': 'thing.DeleteCheck','ngConfirmTitle': 'thing.Delete','ngConfirmNoBtn': 'common.cancel', 'ngConfirmYesBtn': 'common.ok'}\"> <span class=\"fa fa-fw fa-times-circle text-danger\"></span> <span i18n=common.delete></span> </button> </td> </tr> </table> <span class=thing-battery ng-class=thing.batteryIcon></span> </li> <li class=\"list-group-item-notification small\" ng-class=\"{'danger':thing.statusInfo.status=='OFFLINE', 'success':thing.statusInfo.status!='OFFLINE'}\" ng-if=thing.statusInfo.description> {{thing.statusInfo.description}} </li> </div>  <div ng-if=\"thingCnt==-1\" class=\"list-group-item text-center\"> <span class=\"fa fa-spin fa-refresh\"></span> <span i18n=common.loading></span> </div> <div ng-if=\"thingCnt==0 && insertMode==false\" class=\"list-group-item text-center\"> <span class=\"fa fa-exclamation-triangle text-warning\"></span> <span i18n=thing.NoneFound></span> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>  <div class=col-sm-8> <div class=\"panel panel-default\">  <div class=panel-heading> <button type=button class=\"btn btn-default\" ng-class=\"{'btn-success': formLoaded&&thingConfigForm.modified}\" ng-click=thingSave() ng-disabled=\"!formLoaded || !thingConfigForm.modified\"> <span class=\"fa fa-floppy-o\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.save></span> </button> <button type=button class=\"btn btn-default\" ng-click=thingConfigForm.reset() ng-disabled=\"!formLoaded || !thingConfigForm.modified\"> <span class=\"fa fa-times\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.cancel></span> </button> <button type=button class=\"btn btn-default\" ng-confirm-click=thingDelete(selectedThing) ng-confirm-icon=warning ng-disabled=\"!formLoaded || newThing\" i18n-attr=\"{'ngConfirmMessage': 'thing.Delete','ngConfirmTitle': 'thing.Delete','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes' }\"> <span class=\"fa fa-trash\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.delete></span> </button> <div class=\"pull-right btn-group\"> <div class=\"pull-right btn-group\" uib-dropdown> <button type=button class=\"btn btn-default\" uib-dropdown-toggle> <span class=\"fa fa-cog\"></span> <span i18n=habmin.Tools></span> <span class=caret></span> </button> <ul class=dropdown-menu uib-dropdown-menu role=menu aria-labelledby=single-button> <li ng-repeat=\"config in actionList = (selectedThingConfig.parameters | filter:checkActions())\"> <a ng-click=doAction(config)> <span class=\"fa fa-fw\"></span> <span class=\"fa fa-fw fa-cog\"></span> <span>{{config.label}}</span> </a> </li> <li ng-if=actionList.length class=divider></li> <li> <a ng-click=\"showAdvancedSettings=!showAdvancedSettings\"> <span class=\"fa fa-fw\" ng-class=\"{'fa-check-square-o': showAdvancedSettings}\"></span> <span class=\"fa fa-fw fa-mortar-board\"></span> <span i18n=habmin.AdvancedMode></span> </a> </li> </ul> </div> </div> </div>  <div class=\"list-group habmin-list\" resize-panel> <form name=thingConfigForm novalidate ng-show=formLoaded class=ng-hide-add style=height:100%>  <div> <a role=presentation ng-class=\"{'list-group-item config-panel-title':true, 'active': panelDisplayed=='OVERVIEW'}\" ng-click=\"setPanelDisplayed('OVERVIEW')\"> <span class=\"fa fa-fw fa-book\"></span> <span i18n=habmin.Description></span> </a> </div> <div uib-collapse=\"panelDisplayed!='OVERVIEW'\" class=panel-form> <div i18n=thing.ThingTypeLabel></div> <div class=\"well well-sm\" ng-bind-html=selectedThingType.label></div> <div i18n=thing.ThingTypeDescription></div> <div class=\"well well-sm\" ng-bind-html=selectedThingType.description></div> <div ng-repeat=\"channel in selectedThing.channels\"> <div>{{channel.label}}</div> <div class=\"well well-sm\"> <div ng-show=getChannelItems(channel).length ng-repeat=\"item in getChannelItems(channel)\"> <div style=display:inline-block> <div> <habmin-icon class=\"fa fa-fw\" itemtype={{getItem(item).type}}></habmin-icon> {{getItem(item).label}} </div> <div class=small>{{getItem(item).name}}</div> </div> <div class=pull-right> <ng-include bs-modifiable=false ng-init=\"cfgType='CFG';\" src=\"'configuration/itemWidget.tpl.html'\"> </ng-include> </div> </div> <div ng-hide=getChannelItems(channel).length i18n=common.none> </div> </div> </div> <div ng-if=selectedThing.channels.length> <button type=button class=\"btn btn-xs\" ng-click=refreshChannelItems() tooltip-placement=top tooltip=\"Refresh all items on this thing\" tooltip-popup-delay=1500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true> <span class=\"fa fa-refresh\"></span> <span i18n=thing.RefreshItems>Refresh Items</span> </button> </div> </div>  <div> <a role=presentation ng-class=\"{'list-group-item config-panel-title':true, 'active': panelDisplayed=='PROPERTIES'}\" ng-click=\"setPanelDisplayed('PROPERTIES')\"> <span class=\"fa fa-fw fa-info\"></span> <span i18n=thing.Properties></span> </a> </div> <div uib-collapse=\"panelDisplayed!='PROPERTIES'\" class=panel-form> <div class=form-group> <label for=inputThingLabel class=control-label i18n=thing.Label></label> <input class=form-control id=inputThingLabel name=thingLabel ng-model=selectedThing.label i18n-attr=\"{placeholder: 'thing.SelectLabel'}\"> </div> <div class=form-group> <label for=inputThingLocation class=control-label i18n=thing.Location></label> <input class=form-control id=inputThingLocation name=thingLocation ng-model=selectedThing.location i18n-attr=\"{placeholder: 'thing.SelectLocation'}\"> </div> <div class=form-group ng-if=\"selectedThingType.bridge==false && selectedThingType.supportedBridgeTypeUIDs!=null && selectedThingType.supportedBridgeTypeUIDs.length>0\"> <label for=inputBridge class=control-label i18n=thing.EditBridge></label> <div> <ui-select id=inputBridge ng-model=selectedThing.bridgeUID theme=bootstrap name=thingBridge search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'thing.SelectBridge'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.item.category}}></habmin-icon> {{$select.selected.label}} </ui-select-match> <ui-select-choices repeat=\"bridge.UID as bridge in things | filter:bridgeFilter | orderBy:'label'\"> <habmin-icon class=\"fa fa-fw\" category={{category.item.category}}></habmin-icon> <span>{{bridge.label}}</span> </ui-select-choices> </ui-select> </div> </div>  </div>  <div ng-repeat=\"group in selectedThingConfig.parameterGroups | filter:{name: '!actions'}\"> <div> <a role=presentation ng-class=\"{'list-group-item list-group-item-heading':true, 'active': panelDisplayed=='CONFIG-{{group.name}}'}\" ng-click=\"setPanelDisplayed('CONFIG-'+group.name)\" ng-if=configGroupAdvanced(group)||showAdvancedSettings> <habmin-icon class=fa-fw cfgcontext={{group.context}}></habmin-icon> <span>{{group.label}}</span> </a> </div> <div uib-collapse=\"$parent.panelDisplayed!='CONFIG-{{group.name}}'\" class=panel-form> <div ng-repeat=\"config in selectedThingConfig.parameters\"> <div class=form-group ng-if=\"configGroupFilter(config, group.name) && (!config.advanced||showAdvancedSettings)\"> <ng-include ng-init=\"cfgType='CFG';cfgModel=selectedThing.configuration[config.name];cfgStatus=selectedThingStatus[config.name]\" src=\"'configuration/eshConfigParam.tpl.html'\"></ng-include> </div> </div> </div> </div>  <div ng-if=thingHasUngroupedParams()> <div> <a role=presentation ng-class=\"{'list-group-item list-group-item-heading':true, 'active': panelDisplayed=='CONFIG-ungrouped'}\" ng-click=\"setPanelDisplayed('CONFIG-ungrouped')\"> <span class=\"fa fa-fw fa-wrench\"></span> <span i18n=habmin.Configuration></span> </a> </div> <div uib-collapse=\"$parent.panelDisplayed!='CONFIG-ungrouped'\" class=panel-form> <div ng-repeat=\"config in selectedThingConfig.parameters\"> <div class=form-group ng-if=\"configGroupFilter(config, null) && (!config.advanced||showAdvancedSettings)\"> <ng-include ng-init=\"cfgType='CFG';cfgModel=selectedThing.configuration[config.name]\" src=\"'configuration/eshConfigParam.tpl.html'\"></ng-include> </div> </div> </div> </div>  <div ng-show=\"selectedThing.channels != null && selectedThing.channels.length != 0\"> <a role=presentation ng-class=\"{'list-group-item':true, 'active': panelDisplayed=='CHANNELS'}\" ng-click=\"setPanelDisplayed('CHANNELS')\"> <span class=\"fa fa-fw fa-navicon\"></span> <span i18n=thing.Channels data-active={{countActiveChannels()}} data-total={{selectedThing.channels.length}}></span> </a> </div> <div uib-collapse=\"panelDisplayed!='CHANNELS'\" class=panel-form> <div ng-repeat=\"channel in selectedThing.channels\">  <div class=form-group> <label for=CHANNELLABEL{{$index+1}} class=control-label>{{channel.channelType.label}}</label> <div class=input-group> <span class=\"input-group-addon category-icon\"> <habmin-icon category={{channel.channelType.category}}></habmin-icon> </span> <input class=form-control id=CHANNELLABEL{{$index+1}} readonly value={{channel.channelType.description}} placeholder={{channel.channelType.category}}> <span class=input-group-addon> <span ng-if=\"channel.linkedItems.length>0\" class=\"fa fa-check-circle text-success\"></span> <span ng-if=\"channel.linkedItems.length==0\" class=\"fa fa-times-circle text-danger\"></span> </span> </div>  <div ng-if=\"channel.configDescription!=null && channel.configDescription.parameters!=null && channel.configDescription.parameters.length>0\"> <div class=\"thing-items well well-sm\"> <div> <strong class=text-muted i18n=thing.ChannelConfiguration></strong> </div> <div class=panel-form> <div ng-repeat=\"config in channel.configDescription.parameters\"> <div ng-form={{channel.id}} class=form-group> <ng-include ng-init=\"cfgType='CHAN';cfgModel=channel.configuration[config.name]\" src=\"'configuration/eshConfigParam.tpl.html'\"></ng-include> </div> </div> </div> </div> </div> <div class=\"thing-items well well-sm\" ng-switch=channel.linkedItems.length> <div ng-switch-when=0> <strong class=text-muted i18n=thing.ChannelNoItems></strong> <div class=pull-right> <button type=button class=\"btn btn-primary btn-xs\" ng-click=linkItem(channel) tooltip-placement=top tooltip=\"Link channel to an existing item\" tooltip-popup-delay=1500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true> <span class=\"fa fa-link\"></span> </button> <button type=button class=\"btn btn-primary btn-xs\" ng-click=addItem(channel) tooltip-placement=top tooltip=\"Create a new item and link it to the channel\" tooltip-popup-delay=1500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true> <span class=\"fa fa-plus-circle\"></span> </button> </div> </div> <div ng-switch-default> <table class=\"table table-hover\"> <thead> <tr> <td class=\"thing-items-title text-muted\"> <strong i18n=thing.ChannelItems></strong> </td> <td> <div class=pull-right> <button type=button class=\"btn btn-primary btn-xs\" ng-click=linkItem(channel) tooltip-placement=top tooltip=\"Link channel to an existing item\" tooltip-popup-delay=1500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true> <span class=\"fa fa-link\"></span> </button> <button type=button class=\"btn btn-primary btn-xs\" ng-click=addItem(channel) tooltip-placement=top tooltip=\"Create a new item and link it to the channel\" tooltip-popup-delay=1500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true> <span class=\"fa fa-plus-circle\"></span> </button> </div> </td> </tr></thead> <tbody> <tr ng-repeat=\"itemName in channel.linkedItems\" ng-init=\"item=getItem(itemName)\"> <td class=span-hover> <button type=button class=\"btn btn-primary btn-xs\" ng-click=\"editItem(item, channel)\" tooltip-placement=top tooltip=\"Edit the item\" tooltip-popup-delay=1500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true> <span class=\"fa fa-edit\"></span> </button> <habmin-icon class=\"fa fa-fw\" itemtype={{item.type}}></habmin-icon> {{item.label}} <span tooltip-placement=top tooltip=\"copy item name to clipboard\" tooltip-popup-delay=1500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true> <span class=\"span-hover-hide fa fa-clipboard\" clipboard text=item.name on-copied=copySuccess(item.name) on-error=copyFailure(err)> </span> </span> </td> <td> <div class=pull-right> <button type=button class=\"btn btn-warning btn-xs\" ng-confirm-click=\"unlinkItem(item, channel)\" tooltip-placement=top tooltip=\"Unlink the item\" tooltip-popup-delay=1500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true ng-confirm-icon=warning i18n-attr=\"{'ngConfirmMessage': 'thing.ChannelUnlinkConfirm','ngConfirmTitle': 'thing.ChannelUnlinkTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes' }\"> <span class=\"fa fa-unlink\"></span> </button> <button type=button class=\"btn btn-danger btn-xs\" ng-confirm-click=\"deleteItem(item, channel)\" tooltip-placement=top tooltip=\"Delete the item\" tooltip-popup-delay=1500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true ng-confirm-icon=warning i18n-attr=\"{'ngConfirmMessage': 'thing.ChannelDeleteConfirm','ngConfirmTitle': 'thing.ChannelDeleteTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes' }\"> <span class=\"fa fa-trash\"></span> </button> </div> </td> </tr> </tbody> </table> </div> </div> </div> </div> </div>  <div ng-show=selectedThingHasProperties> <a role=presentation ng-class=\"{'list-group-item config-panel-title':true, 'active': panelDisplayed=='ATTRIBUTES'}\" ng-click=\"setPanelDisplayed('ATTRIBUTES')\"> <span class=\"fa fa-fw fa-pencil-square\"></span> <span i18n=thing.Attributes></span> </a> </div> <div uib-collapse=\"panelDisplayed!='ATTRIBUTES'\" class=panel-form> <div ng-switch=\"selectedThing.thingTypeUID.split(':')[0]\"> <div ng-switch-when=zwave> <ng-include src=\"'configuration/thingAttributesZWave.tpl.html'\"></ng-include> </div> <div ng-switch-default> <div class=row ng-repeat=\"(attName, attValue) in selectedThing.properties\"> <div class=col-md-4>{{attName}}</div> <div class=col-md-8>{{attValue}}</div> </div> </div> </div> </div></form> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("configuration/thingConfigMenu.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/thingConfigMenu.tpl.html",
    "<ul class=\"nav navbar-nav\"> <li class=dropdown uib-dropdown is-open=status.isopen> <a class=dropdown-toggle uib-dropdown-toggle ngx-class=\"{'disabled': discoveryEnabled}\" uib-tooltip-placement=bottom uib-tooltip={{tooltipDiscover}} uib-tooltip-popup-delay=500 uib-tooltip-enable=\"{{status.isopen==false}}\" uib-tooltip-trigger uib-tooltip-animation=false> <i class=\"fa fa-search-plus\"></i> </a> <ul class=dropdown-menu uib-dropdown-menu role=menu> <li ng-repeat=\"binding in bindings | orderBy:'name' | filter:{discovery: 'true'}\"> <a ng-click=startDiscovery(binding)> <habmin-icon class=fa-fw icon={{binding.icon}}></habmin-icon> <span>{{binding.name}}</span> </a> </li> </ul> </li> <li> <a class=navbar-button role=button ui-sref=/thing-wizard.binding uib-tooltip-placement=bottom uib-tooltip={{tooltipManualAdd}} uib-tooltip-popup-delay=500 uib-tooltip-enable=true uib-tooltip-trigger uib-tooltip-animation=false> <i class=\"fa fa-plus\"></i> </a> </li> </ul>");
}]);

angular.module("configuration/thingDiscovery.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/thingDiscovery.tpl.html",
    "<div class=col-sm-4 sidepanel-pane=side> <div class=\"panel panel-default\">  <div class=panel-heading>  <div class=\"btn-group dropdown\"> <button type=button class=\"btn btn-default dropdown-toggle\" ng-disabledx=\"logState!='loaded'\" ng-init=\"filterOpen=false\" ng-click=\"filterOpen=!filterOpen\"> <span class=\"fa fa-filter\"></span> <span i18n=common.Filter></span> <span class=caret></span> <span class=sr-only>Dropdown</span> </button> <ul class=dropdown-menu role=menu> <li><a ng-click=\"listNew=!listNew\"> <span ng-class=\"{'fa fa-fw': true, 'fa-check-square-o': listNew}\"></span> <span class=\"fa fa-fw fa-plus-circle text-success\"></span> <span i18n=thing.New></span> </a></li> <li><a ng-click=\"listIgnored=!listIgnored\"> <span ng-class=\"{'fa fa-fw': true, 'fa-check-square-o': listIgnored}\"></span> <span class=\"fa fa-fw fa-dot-circle-o text-muted\"></span> <span i18n=thing.Ignored></span> </a></li> </ul> </div>  <div class=\"btn-group dropdown pull-right\"> <button type=button class=\"btn btn-default dropdown-toggle\" data-toggle=dropdown> <span class=\"fa fa-plus-square\"></span> <span i18n=thing.Search></span> <span class=caret></span> <span class=sr-only>Dropdown</span> </button> <ul class=dropdown-menu role=menu> <li ng-repeat=\"choice in bindings\" ng-class=\"{'disabled': choice.disabled}\" ng-if=choice.discovery> <a ng-click=startDiscovery(choice)> <habmin-icon class=fa-fw icon={{choice.icon}}></habmin-icon> <span>{{choice.name}}</span> </a> </li> </ul> </div> </div>  <div class=\"list-group habmin-list\" resize-panel>  <div ng-if=\"inboxCnt!=-1\" ng-repeat=\"thing in inbox | filter:filterFunction\"> <a role=presentation ng-class=\"{'list-group-item':true, 'active': thing==selectedThing}\" ng-click=selectThing(thing) sidepanel-click=main> <table style=\"background-color: transparent\"> <tr> <td class=text-large rowspan=2> <span ng-if=\"thing.flag=='NEW'\" class=\"fa fa-fw fa-plus-circle text-success\"></span> <span ng-if=\"thing.flag=='IGNORED'\" class=\"fa fa-fw fa-dot-circle-o text-muted\"></span> </td> <td> <span>{{thing.label}}&nbsp;</span> </td> </tr> <tr> <td class=\"text-muted small\">{{thing.thingUID}}</td> </tr> </table> </a> </div>  <div ng-if=\"inboxCnt==-1\" class=\"list-group-item text-center\"> <span class=\"fa fa-spin fa-refresh\"></span> <span i18n=common.loading></span> </div> <div ng-if=\"inboxCnt==0\" class=\"list-group-item text-center\"> <span class=\"fa fa-exclamation-triangle text-warning\"></span> <span i18n=thing.NoneFound></span> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>  <div class=col-sm-8 sidepanel-pane=main> <div class=\"panel panel-default\">  <div class=panel-heading> <button type=button ng-class=\"{'btn btn-default':true, 'disabled':!selectedThing}\" ng-click=saveThing()> <span class=\"fa fa-fw fa-plus-circle\"></span> <span i18n=common.add></span> </button> <button type=button ng-class=\"{'btn btn-default':true, 'disabled':!selectedThing}\" ng-confirm-click=ignoreThing() i18n-attr=\"{'ngConfirmMessage': 'discovery.IgnoreConfirmMsg','ngConfirmTitle': 'discovery.IgnoreConfirmTitle','ngConfirmNoBtn': 'common.cancel', 'ngConfirmYesBtn': 'common.ok'}\"> <span class=\"fa fa-fw fa-dot-circle-o\"></span> <span i18n=common.ignore></span> </button> <button type=button ng-class=\"{'btn btn-default':true, 'disabled':!selectedThing}\" ng-confirm-click=deleteThing() i18n-attr=\"{'ngConfirmMessage': 'discovery.DeleteConfirmMsg','ngConfirmTitle': 'discovery.DeleteConfirmTitle','ngConfirmNoBtn': 'common.cancel', 'ngConfirmYesBtn': 'common.ok'}\"> <span class=\"fa fa-fw fa-times-circle\"></span> <span i18n=common.delete></span> </button> </div>  <div class=\"list-group habmin-list\" resize-panel> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("configuration/thingWizard.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/thingWizard.tpl.html",
    "<div class=row> <div class=\"wizard col-sm-8 col-sm-offset-2\"> <div class=\"wizard-header text-center\"> <h2>Add new Thing Wizard</h2>   <div class=\"status-buttons text-center\"> <a ui-sref-active=active ui-sref=/thing-wizard.binding ng-click=\"binding=null;selectedThing=null\"><span class=number>1</span><span i18n=thing.WizardBinding></span></a> <a ui-sref-active=active ui-sref=/thing-wizard.thing ng-class=\"{disabled: binding==null}\" ng-click=\"selectedThing=null\"><span class=number>2</span><span i18n=thing.WizardType></span></a> <a ui-sref-active=active ui-sref=/thing-wizard.configure ng-class=\"{disabled: binding==null || selectedThing==null}\"><span class=number>3</span><span i18n=thing.WizardConfigure></span></a> </div> </div> <div class=wizard-views ui-view></div> </div> </div>");
}]);

angular.module("configuration/thingWizardConfigure.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/thingWizardConfigure.tpl.html",
    "<label>Configure Thing...</label> <div class=form-group> <label for=inputThingUID class=control-label i18n=thing.UID></label> <input class=form-control id=inputThingUID name=itemUID ng-model=selectedThing.UID i18n-attr=\"{placeholder: 'thing.SelectUID'}\"> </div> <div class=form-group> <label for=inputThingLabel class=control-label i18n=thing.Label></label> <input class=form-control id=inputThingLabel name=itemLabel ng-model=selectedThing.label i18n-attr=\"{placeholder: 'thing.SelectLabel'}\"> </div> <div class=form-group ng-if=\"selectedThingType.bridge==false && selectedThingType.supportedBridgeTypeUIDs!=null && selectedThingType.supportedBridgeTypeUIDs.length>0\"> <label for=inputBridge class=control-label i18n=thing.EditBridge></label> <div> <ui-select id=inputBridge ng-model=selectedThing.bridgeUID theme=bootstrap search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'thing.SelectBridge'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.category}}></habmin-icon> {{$select.selected.label}} </ui-select-match> <ui-select-choices repeat=\"bridge.UID as bridge in things | filter:bridgeFilter | orderBy:'label'\"> <habmin-icon class=\"fa fa-fw\" category={{category.category}}></habmin-icon> <span>{{bridge.label}}</span> </ui-select-choices> </ui-select> </div> </div>  <button class=\"btn btn-success\" ng-click=saveNewThing()>Save</button>");
}]);

angular.module("configuration/thingWizardDiscovery.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/thingWizardDiscovery.tpl.html",
    "<label>Configure Thing...</label> <div class=form-group> <label for=inputThingLabel class=control-label i18n=thing.Label></label> <input class=form-control id=inputThingLabel name=itemLabel ng-model=selectedThing.item.label i18n-attr=\"{placeholder: 'item.SelectLabel'}\"> </div> <div class=form-group ng-if=\"selectedThingType.bridge==false && selectedThingType.supportedBridgeTypeUIDs!=null && selectedThingType.supportedBridgeTypeUIDs.length>0\"> <label for=inputBridge class=control-label i18n=thing.EditBridge></label> <div> <ui-select id=inputBridge ng-model=selectedThing.bridgeUID theme=bootstrap search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'thing.SelectBridge'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.item.category}}></habmin-icon> {{$select.selected.item.label}} </ui-select-match> <ui-select-choices repeat=\"bridge.UID as bridge in things | filter:bridgeFilter | orderBy:'label'\"> <habmin-icon class=\"fa fa-fw\" category={{category.item.category}}></habmin-icon> <span>{{bridge.item.label}}</span> </ui-select-choices> </ui-select> </div> </div> <div class=form-group> <label for=inputCategory class=control-label i18n=item.EditCategory></label> <div> <ui-select id=inputCategory ng-model=selectedThing.item.category theme=bootstrap name=itemCategory search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'item.SelectCategory'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.id}}></habmin-icon> {{$select.selected.name}} </ui-select-match> <ui-select-choices repeat=\"category.id as category in categories | orderBy: 'name'\"> <habmin-icon class=\"fa fa-fw\" category={{category.id}}></habmin-icon> <span>{{category.name}}</span> </ui-select-choices> </ui-select> </div> </div> <div class=form-group> <label for=inputGroups class=control-label i18n=item.EditGroups></label> <div> <ui-select id=inputGroups ng-model=selectedThing.item.groupNames theme=bootstrap search-enabled=false name=itemGroups multiple> <ui-select-match i18n-attr=\"{placeholder: 'item.SelectGroup'}\"> <habmin-icon class=\"fa fa-fw\" category={{$item.category}}></habmin-icon> {{$item.label}} </ui-select-match> <ui-select-choices repeat=\"group.name as group in itemList | filter: {type: 'GroupItem'} | orderBy: 'label'\"> <habmin-icon class=\"fa fa-fw\" category={{group.category}}></habmin-icon> <span>{{group.label}}</span> </ui-select-choices> </ui-select> </div> </div> <button class=\"btn btn-success\" ng-click=saveNewThing()>Save</button>");
}]);

angular.module("configuration/thingWizardSelectBinding.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/thingWizardSelectBinding.tpl.html",
    "<label>Select binding...</label> <ul class=list-group> <li class=list-group-item ng-repeat=\"binding in bindings | orderBy:'name'\"> <a ng-click=selectBinding(binding)> <span>{{binding.name}}</span> <span class=\"badge pull-right\">{{countBindingThings(binding)}}</span> </a> </li> </ul>");
}]);

angular.module("configuration/thingWizardSelectThing.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configuration/thingWizardSelectThing.tpl.html",
    "<label>Select thing type...</label> <ul class=list-group> <li class=list-group-item ng-repeat=\"thing in newThings | orderBy: 'label'\"> <a ng-click=selectThing(thing)> <habmin-icon class=fa-fw icon={{binding.icon}}></habmin-icon> <span>{{thing.label}}</span> </a> </li> </ul>");
}]);

angular.module("dashboard/dashboard.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboard.tpl.html",
    "<div ng-if=editMode class=page-header> <div class=\"btn-group btn-group-sm\" role=group> <button class=\"btn btn-sm btn-primary\" ng-click=dashboardProperties()><i class=\"fa fa-bookmark-o\"></i> <span i18n=common.properties></span></button> <div class=\"dashboard-toolbar btn-group dropdown\" uib-dropdown> <button type=button class=\"btn btn-sm btn-primary dropdown-toggle\" uib-dropdown-toggle> <span class=\"fa fa-plus-square-o\"></span> <span i18n=dashboard.AddWidget></span> <span class=caret></span> <span class=sr-only>Dropdown</span> </button> <ul class=dropdown-menu role=menu uib-dropdown-menu> <li> <a role=presentation ng-click=\"addWidget('Chart')\"> <span class=\"fa fa-fw fa-area-chart\"></span> <span i18n=dashboard.AddChart></span> </a> </li> <li> <a ng-click=\"addWidget('Gauge')\"> <span class=\"fa fa-fw fa-dashboard\"></span> <span i18n=dashboard.AddGauge></span> </a> </li> <li> <a ng-click=\"addWidget('Image')\"> <span class=\"fa fa-fw fa-picture-o\"></span> <span i18n=dashboard.AddImage></span> </a> </li> <li> <a ng-click=\"addWidget('Group')\"> <span class=\"fa fa-fw fa-sliders\"></span> <span i18n=dashboard.AddGroup></span> </a> </li> <li> <a ng-click=\"addWidget('GroupBar')\"> <span class=\"fa fa-fw fa-sliders\"></span> <span i18n=dashboardAddGroup></span> </a> </li> <li> <a ng-click=\"addWidget('Floor')\"> <span class=\"fa fa-fw fa-home\"></span> <span i18n=dashboard.AddFloorplan></span> </a> </li> </ul> </div> </div> <div class=\"btn-group btn-group-sm pull-right\" role=group> <button class=\"btn btn-sm btn-default\" ng-click=saveDashboard() ng-disabled=\"isDirty==false\" ng-class=\"{'btn-success': isDirty}\"> <span class=\"fa fa-save\"></span> <span i18n=common.save></span> </button> <button class=\"btn btn-sm btn-default\" ng-click=endEdit()> <span class=\"fa fa-check-square\"></span> <span i18n=common.close></span> </button> <button class=\"btn btn-sm btn-default\" ng-confirm-click=clearDashboard() ng-disabled=\"dashboard.widgets.length==0\" i18n-attr=\"{'ngConfirmMessage': 'dashboard.ClearText','ngConfirmTitle': 'dashboard.ClearTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes'}\"> <span class=\"fa fa-file-o\"></span> <span i18n=common.clear></span> </button> <button class=\"btn btn-sm btn-default\" ng-confirm-click=deleteDashboard() ng-disabled=\"dashboard.id==0\" i18n-attr=\"{'ngConfirmMessage': 'dashboard.DeleteText','ngConfirmTitle': 'dashboard.DeleteTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes'}\"> <span class=\"fa fa-trash-o\"></span> <span i18n=common.delete></span> </button> </div> </div> <div gridster=gridsterOptions> <ul> <li gridster-item=widget ng-repeat=\"widget in dashboard.widgets\"> <div ng-class=\"{'dashboard':true, 'dashboard-edit':editMode}\"> <div ng-if=editMode class=dashboard-header> <div class=\"dashboard-header-btns pull-right\"> <a title=settings ng-click=configWidget(widget)><span class=\"fa fa-cog\"></span></a> <a title=\"Remove widget\" ng-click=removeWidget(widget)><span class=\"fa fa-trash\"></span></a> </div> </div> <dashboard-widget widget=widget></dashboard-widget> </div> </li> </ul> </div>");
}]);

angular.module("dashboard/dashboardButtonProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardButtonProperties.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputGroups class=control-label i18n=dashboard.GroupName></label> <div> <ui-select id=inputGroups ng-model=options.group theme=bootstrap search-enabled=true> <ui-select-match i18n-attr=\"{placeholder: 'dashboard.GroupSelectName'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.category}}></habmin-icon> {{$select.selected.label}} </ui-select-match> <ui-select-choices repeat=\"group.name as group in itemList | filter: {type: 'GroupItem'} | orderBy: 'label'\"> <habmin-icon class=\"fa fa-fw\" category={{group.category}}></habmin-icon> <span>{{group.label}}</span> </ui-select-choices> </ui-select> </div> </div> <div class=\"form-group drag-list\"> <label class=control-label i18n=dashboard.GroupItems></label> <ul dnd-list=list> <li role=presentation class=list-group-item ng-repeat=\"item in list\" dnd-draggable=item dnd-moved=\"list.splice($index, 1)\" dnd-effect-allowed=move ng-class=\"{'selected': models.selected === item}\"> {{item.label}} </li> </ul> </div> </form>");
}]);

angular.module("dashboard/dashboardButtonWidget.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardButtonWidget.tpl.html",
    "<div class=box> <div class=box-body> <div> <div class=circle-text ng-class=state ng-click=buttonClick()> <div> <habmin-icon class=fa category=Temperature></habmin-icon> </div> </div> </div> </div> <div> Hello </div> </div>");
}]);

angular.module("dashboard/dashboardChartProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardChartProperties.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputChart class=control-label i18n=dashboard.ChartName></label> <div> <select class=form-control id=inputChart ng-model=options.chartId ng-options=\"chart.id as chart.name for chart in charts\"> </select> </div> </div> <div class=form-group> <label for=inputServices class=control-label i18n=dashboard.ChartService></label> <div> <select class=form-control id=inputServices ng-model=options.serviceId ng-options=\"service.name as service.name for service in services\"> </select> </div> </div> </form>");
}]);

angular.module("dashboard/dashboardChartWidget.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardChartWidget.tpl.html",
    "<div class=\"box box-default\"> <div class=box-body> <habmin-chart style=display:inline-block;height:100%;width:100% chart=options.chartId service=options.serviceId> </habmin-chart> </div> </div>");
}]);

angular.module("dashboard/dashboardFloorplanProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardFloorplanProperties.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputGroups class=control-label i18n=dashboard.FloorName></label> <div> <ui-select id=inputGroups ng-model=options.floorplanId theme=bootstrap search-enabled=true> <ui-select-match i18n-attr=\"{placeholder: 'dashboard.FloorSelectName'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.category}}></habmin-icon> {{$select.selected.name}} </ui-select-match> <ui-select-choices repeat=\"floorplan.id as floorplan in floorplanList | orderBy: 'name'\"> <habmin-icon class=\"fa fa-fw\" category={{floorplan.category}}></habmin-icon> <span>{{floorplan.name}}</span> </ui-select-choices> </ui-select> </div> </div> </form>");
}]);

angular.module("dashboard/dashboardFloorplanWidget.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardFloorplanWidget.tpl.html",
    "<div class=\"box box-default\"> <div class=box-body> <floor-plan ng-click=imgClicked($event) hotspot-click=clickHotspot hotspot-list=hotspotList image={{floorplanImage}}> </floor-plan> </div> </div>");
}]);

angular.module("dashboard/dashboardGaugeProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardGaugeProperties.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputItem class=control-label i18n=dashboard.GaugeItem></label> <div> <ui-select id=inputItem ng-model=options.itemId theme=bootstrap> <ui-select-match i18n-attr=\"{placeholder: 'dashboard.GaugeItemPlaceholder'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.category}}></habmin-icon> &nbsp;{{$select.selected.label}} </ui-select-match> <ui-select-choices repeat=\"item.name as item in items | filter: {label: $select.search }\"> <habmin-icon class=\"fa fa-fw\" category={{item.category}}></habmin-icon> &nbsp;{{item.label}} </ui-select-choices> </ui-select> </div> </div> <div class=form-group> <label for=inputTheme class=control-label i18nx=dashboard.GaugeItem>Theme</label> <div> <ui-select id=inputTheme ng-model=gaugeTheme theme=bootstrap search-enabled=false on-select=selectTheme($item)> <ui-select-match i18n-attr=\"{placeholder: 'dashboard.GaugeItemPlaceholder'}\"> {{$select.selected.name}} </ui-select-match> <ui-select-choices repeat=\"theme.id as theme in gaugeThemes\"> <ng-dial-gauge options=theme.options ng-model=75 style=display:inline-block;height:100px;width:100px></ng-dial-gauge> </ui-select-choices> </ui-select> </div> </div> <div class=form-group> <label for=inputTitle class=control-label i18n=dashboard.GaugeLabel></label> <div> <input ng-model=options.title class=form-control id=inputTitle placeholder=Label> </div> </div> <div class=form-group> <label for=inputUnits class=control-label i18n=dashboard.GaugeUnits></label> <div> <input ng-model=options.units class=form-control id=inputUnits placeholder=Label> </div> </div> <div class=form-group> <label for=inputMinimum class=control-label i18n=dashboard.GaugeMinimum></label> <div> <input type=number ng-model=options.scaleMin class=form-control id=inputMinimum placeholder=Label> </div> </div> <div class=form-group> <label for=inputMaximum class=control-label i18n=dashboard.GaugeMaximum></label> <div> <input type=number ng-model=options.scaleMax class=form-control id=inputMaximum placeholder=Label> </div> </div> <div class=form-group> <label for=inputBarWidth class=control-label i18n=dashboard.GaugeBarWidth></label> <div> <input type=number ng-model=options.barWidth class=form-control id=inputBarWidth placeholder=Label> </div> </div> <div class=form-group> <label for=inputBorderWidth class=control-label i18n=dashboard.GaugeBorderWidth></label> <div> <input type=number ng-model=options.borderWidth class=form-control id=inputBorderWidth placeholder=Label> </div> </div> <div class=form-group> <label for=inputScaleAngle class=control-label i18n=dashboard.GaugeScaleAngle></label> <div> <input type=number ng-model=options.angle class=form-control id=inputScaleAngle placeholder=Label> </div> </div> <div class=form-group> <label for=inputZeroPosition class=control-label i18n=dashboard.GaugeZeroPosition></label> <div> <input type=number ng-model=options.rotate class=form-control id=inputZeroPosition placeholder=Label> </div> </div> <div class=form-group> <label for=inputKnobAngle class=control-label i18n=dashboard.GaugeBarAngle></label> <div> <input type=number ng-model=options.barAngle class=form-control id=inputKnobAngle placeholder=Label> </div> </div> <div class=form-group> <label for=inputEndCap class=control-label i18n=dashboard.GaugeEndCap></label> <div> <ui-select id=inputEndCap ng-model=options.lineCap theme=bootstrap> <ui-select-match i18n-attr=\"{placeholder: 'dashboard.GaugeEndCap'}\">{{$select.selected.name}} </ui-select-match> <ui-select-choices repeat=\"cap.id as cap in endCaps\"> {{cap.name}} </ui-select-choices> </ui-select> </div> </div> </form>");
}]);

angular.module("dashboard/dashboardGaugeWidget.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardGaugeWidget.tpl.html",
    "<div class=\"box box-default\"> <div class=box-body> <ng-dial-gauge options=options ng-model=value style=display:inline-block;height:100%;width:100%> </ng-dial-gauge> </div> </div>");
}]);

angular.module("dashboard/dashboardGeneralProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardGeneralProperties.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputTitle class=control-label i18n=dashboard.GeneralTitle></label> <div> <input disabled ng-model=options.title class=form-control id=inputTitle placeholder=Label> </div> </div> <div class=form-group> <label for=inputUrl class=control-label i18n=dashboard.GeneralBorder></label> <div> <input disabled ng-model=options.border class=form-control id=inputUrl placeholder=Label> </div> </div> <div class=form-group> <label for=inputLink class=control-label i18n=dashboard.GeneralLink></label> <div> <input disabled ng-model=options.link class=form-control id=inputLink placeholder=Label> </div> </div> </form>");
}]);

angular.module("dashboard/dashboardGroupBarProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardGroupBarProperties.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputGroups class=control-label i18n=dashboard.GroupName></label> <div> <ui-select id=inputGroups ng-model=options.group theme=bootstrap search-enabled=true> <ui-select-match i18n-attr=\"{placeholder: 'dashboard.GroupSelectName'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.category}}></habmin-icon> {{$select.selected.label}} </ui-select-match> <ui-select-choices repeat=\"group.name as group in itemList | filter: {type: 'GroupItem'} | orderBy: 'label'\"> <habmin-icon class=\"fa fa-fw\" category={{group.category}}></habmin-icon> <span>{{group.label}}</span> </ui-select-choices> </ui-select> </div> </div> <div class=\"form-group drag-list\"> <label class=control-label i18n=dashboard.GroupItems></label> <ul dnd-list=list> <li role=presentation class=list-group-item ng-repeat=\"item in list\" dnd-draggable=item dnd-moved=\"list.splice($index, 1)\" dnd-effect-allowed=move ng-class=\"{'selected': models.selected === item}\"> {{item.label}} </li> </ul> </div> </form>");
}]);

angular.module("dashboard/dashboardGroupBarWidget.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardGroupBarWidget.tpl.html",
    "<div class=info-box> <span class=info-box-icon><habmin-icon class=fa category={{groupItem.category}}></habmin-icon></span> <div class=info-box-content> <div ng-repeat=\"item in groupMembers\"> <div class=info-box-group> <span class=info-box-text>{{item.label}}</span> <span class=info-box-value>{{item.state}}</span> </div> <div class=progress> <div class=progress-bar style=\"width: 5%\"></div> </div> </div> </div>  </div>");
}]);

angular.module("dashboard/dashboardGroupProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardGroupProperties.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputGroups class=control-label i18n=dashboard.GroupName></label> <div> <ui-select id=inputGroups ng-model=options.group theme=bootstrap search-enabled=true> <ui-select-match i18n-attr=\"{placeholder: 'dashboard.GroupSelectName'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.category}}></habmin-icon> {{$select.selected.label}} </ui-select-match> <ui-select-choices repeat=\"group.name as group in itemList | filter: {type: 'GroupItem'} | orderBy: 'label'\"> <habmin-icon class=\"fa fa-fw\" category={{group.category}}></habmin-icon> <span>{{group.label}}</span> </ui-select-choices> </ui-select> </div> </div> <div class=\"form-group drag-list\"> <label class=control-label i18n=dashboard.GroupItems></label> <ul dnd-list=list> <li role=presentation class=list-group-item ng-repeat=\"item in list\" dnd-draggable=item dnd-moved=\"list.splice($index, 1)\" dnd-effect-allowed=move ng-class=\"{'selected': models.selected === item}\"> {{item.label}} </li> </ul> </div> </form>");
}]);

angular.module("dashboard/dashboardGroupWidget.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardGroupWidget.tpl.html",
    "<div class=\"box box-default\"> <div class=box-body> <div ng-repeat=\"item in groupMembers\"> <div ng-switch on=item.type class=sitemap-row> <dashboard-switch ng-switch-when=Switch item=item></dashboard-switch> <dashboard-text ng-switch-default item=item></dashboard-text> </div> </div> </div> </div>");
}]);

angular.module("dashboard/dashboardImageProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardImageProperties.tpl.html",
    "<form class=form role=form> <div class=form-group> <label for=inputUrl class=control-label i18n=dashboard.ImageURL></label> <div> <input ng-model=options.uri class=form-control id=inputUrl placeholder=Label> </div> </div> </form>");
}]);

angular.module("dashboard/dashboardMenu.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardMenu.tpl.html",
    "<ul class=\"nav navbar-nav\" tooltip-placement=bottom tooltip={{tooltipEdit}} tooltip-popup-delay=500 tooltip-enable=true tooltip-trigger tooltip-animation=false> <li ng-click=dashboardEdit()> <a class=navbar-button role=button> <i class=\"fa fa-edit\"></i> </a> </li> </ul>");
}]);

angular.module("dashboard/dashboardProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardProperties.tpl.html",
    "<div class=modal-header> <h3 class=modal-title i18n=dashboard.PropertiesTitle></h3> </div> <div class=modal-body> <form class=form role=form> <div class=form-group> <label for=inputName class=control-label i18n=dashboard.PropertiesName></label> <div> <input ng-model=dashboard.name class=form-control id=inputName placeholder=Label> </div> </div> <div class=form-group> <label for=inputName class=control-label i18n=dashboard.PropertiesCategory></label> <div> <form-select-category ng-model=dashboard.category id=inputName placeholder=\"Category\"> </div> </div> <div class=form-group> <label class=control-label i18n=dashboard.PropertiesShowMenu></label> <div> <form-select-yes-no ng-model=dashboard.menu placeholder=\"Label\"> </div> </div> </form> </div> <div class=modal-footer> <button type=button class=\"btn btn-primary\" ng-click=ok() i18n=common.save></button> <button type=button class=\"btn btn-warning\" ng-click=cancel() i18n=common.cancel></button> </div>");
}]);

angular.module("dashboard/dashboardWidgetProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("dashboard/dashboardWidgetProperties.tpl.html",
    "<div class=modal-header> <h3 class=modal-title i18n=dashboard.WidgetEditTitle></h3> </div> <div class=modal-body> <div class=row> <div class=col-xs-6> <ul class=\"nav nav-pills nav-stacked\"> <li ng-class=\"{'active':showTab==0}\"> <a ng-click=\"showTab=0\"> <span i18n=dashboard.WidgetConfigGeneral></span> </a> </li> <li ng-show=\"widget.type=='Button'\" ng-class=\"{'active':showTab==1}\"> <a ng-click=\"showTab=1\"> <span i18n=dashboard.WidgetConfigButton></span> </a> </li> <li ng-show=\"widget.type=='Chart'\" ng-class=\"{'active':showTab==1}\"> <a ng-click=\"showTab=1\"> <span i18n=dashboard.WidgetConfigChart></span> </a> </li> <li ng-show=\"widget.type=='Gauge'\" ng-class=\"{'active':showTab==1}\"> <a ng-click=\"showTab=1\"> <span i18n=dashboard.WidgetConfigGauge></span> </a> </li> <li ng-show=\"widget.type=='Image'\" ng-class=\"{'active':showTab==1}\"> <a ng-click=\"showTab=1\"> <span i18n=dashboard.WidgetConfigImage></span> </a> </li> <li ng-show=\"widget.type=='Group'\" ng-class=\"{'active':showTab==1}\"> <a ng-click=\"showTab=1\"> <span i18n=dashboard.WidgetConfigGroup></span> </a> </li> <li ng-show=\"widget.type=='GroupBar'\" ng-class=\"{'active':showTab==1}\"> <a ng-click=\"showTab=1\"> <span i18n=dashboard.WidgetConfigGroup></span> </a> </li> <li ng-show=\"widget.type=='Floor'\" ng-class=\"{'active':showTab==1}\"> <a ng-click=\"showTab=1\"> <span i18n=dashboard.WidgetConfigFloorplan></span> </a> </li> </ul> </div> <div class=col-xs-6> <dashboard-general-properties ng-show=\"showTab==0\" model=general></dashboard-general-properties> <div ng-show=\"showTab==1\"> <dashboard-button-properties ng-if=\"widget.type=='Button'\" options=widget.options></dashboard-button-properties> <dashboard-chart-properties ng-if=\"widget.type=='Chart'\" options=widget.options></dashboard-chart-properties> <dashboard-gauge-properties ng-if=\"widget.type=='Gauge'\" options=widget.options></dashboard-gauge-properties> <dashboard-image-properties ng-if=\"widget.type=='Image'\" options=widget.options></dashboard-image-properties> <dashboard-group-properties ng-if=\"widget.type=='Group'\" options=widget.options></dashboard-group-properties> <dashboard-groupbar-properties ng-if=\"widget.type=='GroupBar'\" options=widget.options></dashboard-groupbar-properties> <dashboard-floorplan-properties ng-if=\"widget.type=='Floor'\" options=widget.options></dashboard-floorplan-properties> </div> </div> </div> </div> <div class=modal-footer> <button type=button class=\"btn btn-primary\" ng-click=ok() i18n=common.save></button> <button type=button class=\"btn btn-warning\" ng-click=cancel() i18n=common.cancel></button> </div>");
}]);

angular.module("floorplan/floorplanEditor.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("floorplan/floorplanEditor.tpl.html",
    "<!DOCTYPE html> <div class=col-sm-4> <div class=\"panel panel-default\">  <div class=\"panel-heading clearfix\"> <span class=\"panel-title pull-left\" i18n=floorplan.Editor></span> <div class=\"btn-group pull-right\"> <button type=button class=\"btn btn-default\" ng-click=newFloorplan()> <span class=\"fa fa-floppy-o\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.new></span> </button> </div> </div>  <div class=\"list-group habmin-list\" resize-panel>  <div ng-if=\"floorplanList.length>0\" ng-repeat=\"floorplan in floorplanList\"> <a role=presentation ng-class=\"{'list-group-item':true, 'active': selectedFloorplan.id==floorplan.id}\" ng-click=selectFloorplan(floorplan)> <table style=\"background-color: transparent\"> <tr> <td class=text-large rowspan=2> <habmin-icon class=\"fa fa-fw\" category={{floorplan.category}}></habmin-icon> </td> <td> <span>{{floorplan.name}}</span> </td> </tr> <tr> <td class=\"text-muted small\"></td> </tr> </table> </a> </div>  <div ng-if=\"bindingsCnt==-1\" class=\"list-group-item text-center\"> <span class=\"fa fa-spin fa-refresh\"></span> <span i18n=common.loading></span> </div> <div ng-if=\"bindingsCnt==0\" class=\"list-group-item text-center\"> <span class=\"fa fa-exclamation-triangle text-warning\"></span> <span i18n=binding.NoneFound></span> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>  <div class=col-sm-8> <div class=\"panel panel-default\">  <div class=panel-heading> <span class=\"btn btn-default btn-file\" ng-disabled=\"selectedFloorplan==null\"> <span class=\"fa fa-picture-o\"></span> <span i18n=floorplan.SelectImage></span> <input onchange=\"angular.element(this).scope().selectImage(this.files[0]);this.value = ''\" type=\"file\"> </span> <button type=button class=\"btn btn-default\" ng-disabled=\"selectedFloorplan==null\" ng-click=editFloorplan()> <span class=\"fa fa-floppy-o\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.properties></span> </button> <button type=button class=\"btn btn-default\" ng-class=\"{'btn-success': isDirty}\" ng-click=saveFloorplan() ng-disabled=\"selectedFloorplan==null || isDirty==false\"> <span class=\"fa fa-floppy-o\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.save></span> </button> <button type=button class=\"btn btn-default\" ng-confirm-click=floorplanDelete() ng-confirm-icon=warning ng-disabled=\"selectedFloorplan==null || selectedFloorplan.id==null\" i18n-attr=\"{'ngConfirmMessage': 'floorplan.DeleteCheck','ngConfirmTitle': 'floorplan.Delete','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes' }\"> <span class=\"fa fa-trash\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.delete></span> </button> </div>  <div class=\"list-group habmin-list floorplan-editor\" resize-panel> <floor-plan ng-click=imgClicked($event) hotspot-click=editHotspot hotspot-list=selectedFloorplan.hotspots image={{floorplanImage}}> </floor-plan> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("floorplan/floorplanHotspotProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("floorplan/floorplanHotspotProperties.tpl.html",
    "<div class=modal-header> <h3 class=modal-title i18n=floorplan.HotspotTitle></h3> </div> <div class=modal-body> <form class=form role=form> <div class=form-group> <label for=inputItem class=control-label i18n=floorplan.HotspotItem></label> <div> <ui-select id=inputItem ng-model=hotspot.itemId theme=bootstrap> <ui-select-match i18n-attr=\"{placeholder: 'floorplan.HotspotItemPlaceholder'}\"> <habmin-icon class=\"fa fa-fw\" category={{$select.selected.category}}></habmin-icon> &nbsp;{{$select.selected.label}} <span ng-if=\"getParentThingItem($select.selected)!=null\">&nbsp;({{getParentThingItem($select.selected).label}})</span> </ui-select-match> <ui-select-choices repeat=\"item.name as item in items | filter: {label: $select.search }\"> <habmin-icon class=\"fa fa-fw\" category={{item.category}}></habmin-icon> &nbsp;{{item.label}} <span ng-if=\"getParentThingItem(item)!=null\">&nbsp;({{getParentThingItem(item).label}})</span> </ui-select-choices> </ui-select> </div> </div> </form> </div> <div class=modal-footer> <button type=button class=\"btn btn-primary\" ng-click=ok() i18n=common.save></button> <button type=button class=\"btn btn-warning\" ng-click=cancel() i18n=common.cancel></button> <button type=button class=\"btn btn-warning\" ng-click=delete() i18n=common.delete></button> </div>");
}]);

angular.module("floorplan/floorplanProperties.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("floorplan/floorplanProperties.tpl.html",
    "<div class=modal-header> <h3 class=modal-title i18n=floorplan.PropertiesTitle></h3> </div> <div class=modal-body> <form class=form role=form> <div class=form-group> <label for=inputName class=control-label i18n=floorplan.PropertiesName></label> <div> <input ng-model=floorplan.name class=form-control id=inputName placeholder=Label> </div> </div> <div class=form-group> <label for=inputName class=control-label i18n=floorplan.PropertiesCategory></label> <div> <form-select-category ng-model=floorplan.category id=inputName placeholder=\"Category\"> </div> </div> </form> </div> <div class=modal-footer> <button type=button class=\"btn btn-primary\" ng-click=ok() i18n=common.save></button> <button type=button class=\"btn btn-warning\" ng-click=cancel() i18n=common.cancel></button> </div>");
}]);

angular.module("home/home.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("home/home.tpl.html",
    "<div class=jumbotron> <h1 class=text-center>HABmin</h1> <p class=\"text-center lead\"> A graphical user interface for openHAB. </p> <p class=\"text-center lead\"> <small>Version: {{version}}, {{date}}</small> </p> <p class=\"text-center lead\" ng-if=phone> <small>Server: {{server}}</small> </p> <div class=text-center> <div class=btn-group> <a href=https://github.com/openhab/org.openhab.ui.habmin/wiki class=\"btn btn-large btn-default\"> <i class=\"fa fa-book\"></i> Read the Docs </a> <a href=https://github.com/openhab/org.openhab.ui.habmin class=\"btn btn-large btn-success\"> <i class=\"fa fa-download\"></i> Download </a> </div> </div> </div> <div class=marketing> <div class=row> <div class=\"col-xs-12 col-sm-6 col-md-4\"> <h4><i class=\"fa fa-thumbs-up\"></i> Good to Go!</h4> <p> Responsive interface to meet all your openHAB needs. </p> </div> <div class=\"col-xs-12 col-sm-6 col-md-4\"> <h4><i class=\"fa fa-area-chart\"></i> Charting</h4> <p> Graphing of your openHAB persistence store. </p> </div> <div class=\"col-xs-12 col-sm-6 col-md-4\"> <h4><i class=\"fa fa-puzzle-piece\"></i> Graphical Rule Editor</h4> <p> Supports a structure that maintains separation of concerns while ensuring maximum code reuse. </p> </div> </div> </div>");
}]);

angular.module("persistence/persistence.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("persistence/persistence.tpl.html",
    "<div class=col-sm-6> <div class=\"panel panel-default\">  <div class=panel-heading> <div class=btn-group uib-dropdown> <button type=button class=\"btn btn-default\" uib-dropdown-toggle> <span class=\"fa fa-cog\"></span> <span i18n=persistence.Service></span> <span class=caret></span> </button> <ul class=dropdown-menu uib-dropdown-menu role=menu aria-labelledby=single-button> <li ng-repeat=\"service in services\" ng-click=selectService(service)> <a ng-click=selectService(service)> <span class=\"fa fa-fw\" ng-class=\"{'fa-check': service==selectedService}\"></span> <span>{{service.label}}</span> </a> </li> </ul> </div> </div>  <div class=\"list-group habmin-list\" resize-panel>  <div ng-repeat=\"item in serviceItems | orderBy:'name'\"> <a role=presentation ng-class=\"{'list-group-item':true, 'active': item==selectedItem}\" ng-click=selectItem(item)> <table style=\"background-color: transparent; width: 100%\"> <tr> <td> <span>{{item.name}}</span> <span class=\"small pull-right\">{{item.count}}&nbsp;<span i18n=persistence.Entries></span></span> </td> </tr> <tr> <td> <span class=small>&nbsp;{{item.earliest | amDateFormat:'dddd, MMMM Do YYYY, h:mm:ss.SSS a'}}</span> </td> </tr> <tr> <td> <span class=small>&nbsp;{{item.latest | amDateFormat:'dddd, MMMM Do YYYY, h:mm:ss.SSS a'}}</span> </td> </tr> </table> </a> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>  <div class=col-sm-6> <div class=\"panel panel-default\">  <div class=\"list-group habmin-list\" resize-panel>  <div> <table class=table> <tr ng-repeat=\"data in dataPage\"> <td>{{data.time | amDateFormat:'dddd, MMMM Do YYYY, h:mm:ss.SSS a'}}</td> <td> <div class=popover-wrapper> <a editable-text=data.state edit-disabled=!serviceEditable onbeforesave=\"updateRecord(data.time, $data)\">{{data.state}}</a> </div> </td> <td class=pull-right> <button type=button ng-if=serviceEditable class=\"btn btn-warning btn-xs\" ng-confirm-click=removeRecord(data.time) tooltip-placement=top tooltip=\"Delete this record\" tooltip-popup-delay=1500 tooltip-enable=true tooltip-trigger tooltip-animation=false tooltip-append-to-body=true ng-confirm-icon=warning i18n-attr=\"{'ngConfirmMessage': 'persistence.RecordDeleteConfirm','ngConfirmTitle': 'persistence.RecordDeleteTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes' }\"> <span class=\"fa fa-trash\"></span> </button> </td> </tr> </table> </div> </div>  <div class=\"panel-footer text-center\"> <ul uib-pagination total-items=totalItems ng-change=selectPage() items-per-page=pageSize ng-model=currentPage max-size=maxSize boundary-links=true boundary-link-numbers=true rotate=false></ul> </div> </div> </div>");
}]);

angular.module("sitemap/sitemap.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("sitemap/sitemap.tpl.html",
    "<div dynamic-sitemap></div>");
}]);

angular.module("tools/zwave/logInfo.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("tools/zwave/logInfo.tpl.html",
    "<div class=popover-content> <table class=\"table table-condensed small\"> <tr> <td>Time</td> <td>{{selectedPkt.time}}</td> </tr>  <tr ng-show=selectedPkt.packetData> <td>Packet Data</td> <td>{{selectedPkt.packetData}}</td> </tr> <tr ng-show=selectedPkt.class> <td>Packet Class</td> <td>{{selectedPkt.class}}</td> </tr> <tr ng-show=selectedPkt.warnFlag> <td>Warning Message</td> <td><span class=\"text-warning fa fa-question-circle\"></span> {{selectedPkt.warnMessage}}</td> </tr> <tr ng-show=selectedPkt.errorFlag> <td>Error Message</td> <td><span class=\"text-danger fa fa-exclamation-circle\"></span> {{selectedPkt.errorMessage}}</td> </tr>  <tr ng-show=selectedPkt.packet.class> <td>Command Class</td> <td>{{selectedPkt.packet.class}}</td> </tr> <tr ng-show=selectedPkt.packet.function> <td>Command Function</td> <td>{{selectedPkt.packet.function}}</td> </tr> <tr ng-show=selectedPkt.packet.responseTime> <td>Packet Response Time</td> <td>{{selectedPkt.packet.responseTime}}</td> </tr>  <tr> <td>Node Number</td> <td>{{selectedPkt.node}}</td> </tr> <tr ng-show=selectedPkt.stage> <td>Current Stage</td> <td>{{selectedPkt.stage}}</td> </tr> <tr ng-show=selectedNode> <td>Node Messages Sent</td> <td>{{selectedNode.messagesSent}}</td> </tr> <tr ng-show=selectedNode> <td>Node Messages Received</td> <td>{{selectedNode.responseTimeCnt}}</td> </tr> <tr ng-show=selectedNode> <td>Node Messages Timed-out</td> <td>{{selectedNode.responseTimeouts}}</td> </tr> <tr ng-show=selectedNode> <td>Node Response Time Stats</td> <td>{{selectedNode.responseTimeMin}}/{{selectedNode.responseTimeAvg}}/{{selectedNode.responseTimeMax}}</td> </tr> </table> <div class=pull-right> <a ng-click=hidePopover() class=\"btn btn-xs btn-primary\">Close</a> </div> </div>");
}]);

angular.module("tools/zwave/logReader.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("tools/zwave/logReader.tpl.html",
    "<div class=col-sm-12>  <div class=\"panel panel-default\"> <div class=panel-heading style=padding:3px> <button type=button ng-disabled=\"logState!='loaded' || showOption=='LIST'\" class=\"btn btn-sm btn-default\" ng-click=\"changePanel('LIST')\"> <span class=\"fa fa-list-alt\"></span> <span>Log</span> </button> <button type=button ng-disabled=\"logState!='loaded' || showOption=='TIMELINE'\" class=\"btn btn-sm btn-default\" ng-click=\"changePanel('TIMELINE')\"> <span class=\"fa fa-line-chart\"></span> <span>Timeline</span> </button> <button type=button ng-disabled=\"logState!='loaded' || showOption=='NODES'\" class=\"btn btn-sm btn-default\" ng-click=\"changePanel('NODES')\"> <span class=\"fa fa-list\"></span> <span>Nodes</span> </button> <span ng-class=\"{'btn-group btn-group-sm': true, 'open': filterOpen}\"> <button type=button class=\"btn btn-sm btn-default dropdown\" ng-disabled=\"logState!='loaded'\" ng-init=\"filterOpen=false\" ng-click=\"filterOpen=!filterOpen\"> <span class=\"fa fa-filter\"></span> &nbsp;Filter <span class=caret></span> </button> <div class=\"dropdown-menu dropdown_dialog\" style=min-width:200px;white-space:nowrap> <div class=modal-header> <button class=\"btn btn-xs default\" ng-click=checkAllNodes(true)>All Nodes </button> <button class=\"btn btn-xs default\" ng-click=checkAllNodes(false)>No Nodes </button> </div> <table> <tr> <td> <table> <tr ng-repeat=\"node in nodes | orderObjectBy:'id'\"> <td> <input type=checkbox checklist-model=nodeFilter checklist-value=node.id> &nbsp;Node {{node.id}} </td> </tr> </table> </td> <td style=\"vertical-align: top;padding-left: 10px\"> <table> <tr ng-repeat=\"process in processFilterOptions\"> <td> <input type=checkbox checklist-model=processFilter checklist-value=process.ref>&nbsp;{{process.name}} </td> </tr> </table> </td> </tr> </table> </div> </span> <span class=pull-right> <div class=btn-group ng-show=\"logState=='loaded'\"> <div class=\"text-right small\">{{logName}}</div> <div class=\"text-right small\">Lines Processed: {{countEntries}}:{{countLines}}</div> </div> <span class=\"btn btn-sm btn-default btn-file\" ng-disabled=\"logState=='loading'\"> <span class=\"fa fa-download\" ng-hide=\"logState=='loading'\"></span> <span>Select File</span> <input onchange=\"angular.element(this).scope().fileChanged(this);this.value = ''\" type=\"file\"> </span> </span> </div>  <div ng-show=\"showOption=='LIST'\" class=habmin-list resize-panel> <table class=table> <tbody> <tr ng-repeat=\"log in data | filter:filterFunction\" ng-class=log.result popup-show=tools/zwave/logInfo.tpl.html popup-placement=bottom-left popup-shown=onPopupShown(log) popup-class=zwave-logreader-popover> <td> {{log.time}} </td> <td class=text-center> {{log.node}} </td> <td> {{log.content}} </td> <td class=text-center> {{log.class}} </td> <td class=text-center> {{log.stage}} </td> <td class=text-center style=white-space:nowrap> <span ng-if=log.duplicate class=\"text-muted fa fa-copy\"></span> <span ng-if=log.successFlag class=\"text-success fa fa-check-circle\"></span> <span ng-if=log.warnFlag class=\"text-warning fa fa-question-circle\"></span> <span ng-if=log.errorFlag class=\"text-danger fa fa-exclamation-circle\"></span> <span ng-if=\"log.queueLen>5&&log.queueLen<15\" class=\"small label label-warning\">{{log.queueLen}}</span> <span ng-if=\"log.queueLen>=15\" class=\"small label label-danger\">{{log.queueLen}}</span> </td> </tr> </tbody> </table> </div>  <div ng-show=\"showOption=='TIMELINE'\" style=padding:3px resize-panel> <vis-timeline data=timelineData options=timelineOptions events=timelineEvents></vis-timeline> </div>  <div ng-show=\"showOption=='NODES'\" style=padding:10px resize-panel> <div class=\"col-sm-4 panel panel-default\" style=height:100%;padding:0px;border-left:0px;border-right:0px> <div class=habmin-list style=height:100%> <div class=list-group style=height:100%;margin-bottom:0px> <a ng-class=\"{'list-group-item':true, 'active':node==selectedNode}\" ng-repeat=\"node in nodes | orderObjectBy:'id'\" ng-click=selectNode(node)> Node {{node.id}} <span class=pull-right> <span ng-if=node.warnings.length class=\"text-warning fa fa-question-circle\"></span> <span ng-if=node.errors.length class=\"text-danger fa fa-exclamation-circle\"></span> </span> </a> </div> </div> </div> <div class=\"col-sm-8 panel panel-default\" style=height:100%;padding:0px;border-left:0px;border-right:0px> <div class=habmin-list style=height:100%> <table ng-if=selectedNode class=\"table habmin-property-table\"> <tbody> <tr> <td>Node ID</td> <td>{{selectedNode.id}}</td> </tr> <tr> <td>Device Class</td> <td>{{selectedNode.deviceClass}}</td> </tr> <tr> <td>Alerts</td> <td> <table> <tr ng-repeat=\"error in selectedNode.errors\"> <td><span class=\"text-danger fa fa-exclamation-circle\"></span>&nbsp;{{error}} </td> </tr> <tr ng-repeat=\"warning in selectedNode.warnings\"> <td><span class=\"text-warning fa fa-question-circle\"></span>&nbsp;{{warning}} </td> </tr> </table> </td> </tr> <tr ng-if=selectedNode.txErrorCan> <td>Messages CANcelled</td> <td><span class=\"text-danger fa fa-exclamation-circle\"></span>&nbsp;{{selectedNode.txErrorCan}} </td> </tr> <tr ng-if=selectedNode.txErrorNak> <td>Messages NAKed</td> <td><span class=\"text-danger fa fa-exclamation-circle\"></span>&nbsp;{{selectedNode.txErrorNak}} </td> </tr> <tr> <td>Command Classes</td> <td> <table> <tr ng-repeat=\"(key, value) in selectedNode.classes\"> <td>{{key}}</td> <td>{{value}}</td> </tr> </table> </td> </tr> <tr> <td>Control Classes</td> <td> <table> <tr ng-repeat=\"(key, value) in selectedNode.control\"> <td>{{key}}</td> </tr> </table> </td> </tr> <tr> <td>Endpoints</td> <td> <table> <tr ng-repeat=\"(key, value) in selectedNode.endpoints\"> <td>{{key}}</td> <td> <table> <tr>Device Class</tr> <tr>{{value.deviceClass}}</tr> </table> </td> </tr> </table> </td> </tr> <tr> <td>Item Definitions</td> <td> <table> <tr ng-repeat=\"item in selectedNode.items\"> <td>{{item}}</td> </tr> </table> </td> </tr> <tr> <td>Listening State</td> <td> <span ng-if=selectedNode.isListening>Yes</span> &nbsp; <span ng-if=selectedNode.isFLiRS>Frequently</span> </td> </tr> <tr ng-if=\"selectedNode.neighboursTotal!=null\"> <td>Neighbours</td> <td>{{selectedNode.neighboursTotal}} total, {{selectedNode.neighboursListening}} listening, {{selectedNode.neighboursUnknown}} unknown </td> </tr> <tr> <td>Messages Sent</td> <td>{{selectedNode.messagesSent}}</td> </tr> <tr> <td>Messages Timed-out</td> <td>{{selectedNode.responseTimeouts}} ({{selectedNode.retryPercent}}%)</td> </tr> <tr> <td>Response Times</td> <td>{{selectedNode.responseTimeMin}} / {{selectedNode.responseTimeAvg}} / {{selectedNode.responseTimeMax}} </td> </tr> <tr> <td>Manufacturer</td> <td>{{selectedNode.manufacturer}}</td> </tr> <tr> <td>Device Type</td> <td>{{selectedNode.deviceType}}</td> </tr> <tr> <td>Device ID</td> <td>{{selectedNode.deviceID}}</td> </tr> <tr> <td>Basic Device Class</td> <td>{{selectedNode.basicClass}}</td> </tr> <tr> <td>Generic Device Class</td> <td>{{selectedNode.genericClass}}</td> </tr> <tr> <td>Specific Device Class</td> <td>{{selectedNode.specificClass}}</td> </tr> <tr></tr> <tr ng-repeat=\"(key, value) in selectedNode\"> <td>{{key}}</td> <td>{{value}}</td> </tr> </tbody> </table> </div> </div> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("tools/zwave/zwaveNetwork.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("tools/zwave/zwaveNetwork.tpl.html",
    "<!DOCTYPE html> <div class=col-sm-12> <div class=\"panel panel-default\">  <div class=panel-heading> <div class=\"btn-group dropdown\"> <button type=button ng-class=\"{'disabled': !devEdit.label}\" class=\"btn btn-default dropdown-toggle\" data-toggle=dropdown> <span class=\"fa fa-cog\"></span> <span i18n=zwave.DeviceTools></span> <span class=caret></span> <span class=sr-only>Dropdown</span> </button> <ul class=dropdown-menu role=menu> <li> <a ng-click=\"setView('CONFIG')\"> <span class=\"fa fa-fw fa-wrench\"></span> <span i18n=zwave.DeviceConfiguration></span> </a> </li> <li> <a ng-click=\"setView('NETWORK')\"> <span class=\"fa fa-fw fa-sitemap\"></span> <span i18n=zwave.DeviceNetworkDiagram></span> </a> </li> <li role=presentation class=divider></li> <li> <a ng-click=\"zwaveAction('nodes/'+devEdit.device+'/', 'Heal')\"> <span class=\"fa fa-fw fa-ambulance\"></span> <span i18n=zwave.DeviceHeal></span> </a> </li> <li ng-class1=\"{'disabled':devEdit.nodeStage!='FAILED'}\"> <a ng-confirm-click=\"zwaveAction('nodes/'+devEdit.device+'/', 'Delete')\" i18n-attr=\"{'ngConfirmMessage': 'zwave.RemoveFailedText','ngConfirmTitle': 'zwave.RemoveFailedTitle','ngConfirmNoBtn': 'common.no', 'ngConfirmYesBtn': 'common.yes'}\" nodenumber={{devEdit.id}}> <span class=\"fa fa-fw fa-trash-o\"></span> <span i18n=zwave.DeviceKill></span> </a> </li> <li> <a ng-click=\"zwaveAction('nodes/'+devEdit.device+'/parameters/', 'Refresh');zwaveAction('nodes/'+devEdit.device+'/associations/', 'Refresh')\"> <span class=\"fa fa-fw fa-refresh\"></span> <span i18n=zwave.DeviceRefresh></span> </a> </li> </ul> </div> </div>   <div class=panel-body style=padding:3px resize-panel> <vis-network data=networkNodes options=networkOptions events=networkEvents></vis-network> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("user/userChart.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("user/userChart.tpl.html",
    "<div class=modal-header> <h3 class=modal-title i18n=user.ChartPrefTitle></h3> </div> <div class=modal-body> <form class=form-horizontal role=form> <div class=form-group> <label for=inputDefaultPeriod class=\"col-sm-3 control-label\" i18n=user.ChartPeriod></label> <div class=col-sm-9> <select class=form-control id=inputDefaultPeriod> <option value=-1>hello</option> <option value=3600 i18n=common.period1Hour></option> <option value=1>hello 2</option> </select> </div> </div> <div class=form-group> <label for=inputDefaultPeriod class=\"col-sm-3 control-label\" i18n=user.ChartLegend></label> <div class=col-sm-9> <input type=checkbox> </div> </div> </form> </div> <div class=modal-footer> <button type=button class=\"btn btn-primary\" ng-click=ok() i18n=common.save></button> <button type=button class=\"btn btn-warning\" ng-click=cancel() i18n=common.cancel></button> </div>");
}]);

angular.module("user/userConfig.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("user/userConfig.tpl.html",
    "<div class=col-sm-12> <div class=\"panel panel-default\">  <div class=panel-heading> <button type=button class=\"btn btn-default\" ng-class=\"{'btn-success': userConfigForm.modified}\" ng-click=saveConfig() ng-disabled=!userConfigForm.modified> <span class=\"fa fa-floppy-o\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.save></span> </button> <button type=button class=\"btn btn-default\" ng-click=userConfigForm.reset() ng-disabled=!userConfigForm.modified> <span class=\"fa fa-times\"></span> <span class=\"hidden-xs hidden-sm\" i18n=common.cancel></span> </button> </div>  <div class=\"list-group habmin-list\" resize-panel> <form name=userConfigForm novalidate style=height:100%>  <div> <a role=presentation class=\"list-group-item config-panel-title\" ng-class=\"{'active': panelDisplayed=='GENERAL'}\" ng-click=\"setPanelDisplayed('GENERAL')\"> <span class=\"fa fa-fw fa-book\"></span> <span i18n=user.GeneralPrefTitle></span> </a> </div> <div uib-collapse=\"panelDisplayed!='GENERAL'\" class=panel-form> <div class=form-group> <label for=inputLanguage class=control-label i18n=user.Language></label> <ui-select id=inputLanguage ng-model=model.currentLanguage theme=bootstrap search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'user.LanguageSelect'}\"> <span ng-bind-html=$select.selected.name></span>&nbsp;(<span ng-bind-html=$select.selected.desc></span>) </ui-select-match> <ui-select-choices repeat=\"language.id as language in languages | orderBy: 'name'\"> <div class=language-select ng-style=\"{'background-image':'url(assets/'+language.flag+'.svg)'}\"> <div ng-bind-html=language.name></div> <span style=padding-left:10px class=small ng-bind-html=language.desc></span> </div> </ui-select-choices> </ui-select> </div> <div class=form-group> <label for=inputPersistence class=control-label i18n=user.ChartPersistence></label> <ui-select id=inputPersistence ng-model=model.currentPersistence theme=bootstrap search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'user.ChartPersistenceSelect'}\"> <span ng-bind-html=$select.selected.label></span> </ui-select-match> <ui-select-choices repeat=\"service.id as service in services | orderBy: 'label'\"> <div ng-bind-html=service.label></div> </ui-select-choices> </ui-select> </div> </div>  <div ng-if=document.HABminCordova> <a role=presentation class=\"list-group-item config-panel-title\" ng-class=\"{'active': panelDisplayed=='SERVER'}\" ng-click=\"setPanelDisplayed('SERVER')\"> <span class=\"fa fa-fw fa-desktop\"></span> <span i18n=user.ServerPrefTitle></span> </a> </div> <div uib-collapse=\"panelDisplayed!='SERVER'\" class=panel-form> <div class=form-group> <label for=inputServerAddress class=control-label i18n=user.ServerAddress></label> <input id=inputServerAddress class=form-control ng-dirty ng-model=model.serverAddress> </div> </div> </form> </div>  <div class=\"panel-footer panel-footer-none\"> </div> </div> </div>");
}]);

angular.module("user/userGeneral.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("user/userGeneral.tpl.html",
    "<div class=modal-header> <h3 class=modal-title i18n=user.GeneralPrefTitle></h3> </div> <div class=modal-body> <form class=form-horizontal role=form> <div class=form-group> <label for=inputTheme class=\"col-sm-3 control-label\" i18n=user.Theme></label> <div class=col-sm-9> <ui-select id=inputTheme ng-model=model.theme theme=bootstrap search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'user.ThemeSelect'}\">{{$select.selected.name}} </ui-select-match> <ui-select-choices repeat=\"theme.id as theme in model.themes\"> <div>{{theme.name}}</div> <span class=small>&nbsp;{{theme.desc}}</span> </ui-select-choices> </ui-select> </div> </div> <div class=form-group> <label for=inputTheme class=\"col-sm-3 control-label\" i18n=user.Language></label> <div class=col-sm-9> <ui-select id=inputLanguage ng-model=model.language theme=bootstrap search-enabled=false> <ui-select-match i18n-attr=\"{placeholder: 'user.LanguageSelect'}\"> <span ng-bind-html=$select.selected.name></span>&nbsp;(<span ng-bind-html=$select.selected.desc></span>) </ui-select-match> <ui-select-choices repeat=\"language.id as language in model.languages | orderBy: 'name'\"> <div class=language-select ng-style=\"{'background-image':'url(assets/'+language.flag+'.svg)'}\"> <div ng-bind-html=language.name></div> <span style=padding-left:10px class=small ng-bind-html=language.desc></span> </div> </ui-select-choices> </ui-select> </div> </div>  </form> </div> <div class=modal-footer> <button type=button class=\"btn btn-primary\" ng-click=ok() i18n=common.save></button> <button type=button class=\"btn btn-warning\" ng-click=cancel() i18n=common.cancel></button> </div>");
}]);
