/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.servlet;

import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HABminApp {
    public static final String HABMIN_ALIAS = "/habmin";
    private static final Logger logger = LoggerFactory.getLogger(HABminApp.class);
    protected HttpService httpService;

    protected void activate(ComponentContext componentContext) {
        try {
            this.httpService.registerResources(HABMIN_ALIAS, "web", null);
            logger.info("Started HABmin servlet at /habmin");
        }
        catch (NamespaceException e) {
            logger.error("Error during HABmin servlet startup", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.httpService.unregister(HABMIN_ALIAS);
        logger.info("Stopped HABmin servlet");
    }

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }
}

