/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.rule;

import io.swagger.annotations.Api;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.openhab.ui.habmin.internal.services.rule.RuleSourceBean;
import org.openhab.ui.habmin.internal.services.rule.RuleSourceListBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="habmin/rules")
@Api(value="habmin-rules")
public class RuleResource
implements RESTResource {
    private static final Logger logger = LoggerFactory.getLogger(RuleResource.class);
    public static final String PATH = "habmin/rules";
    public static final String API = "habmin-rules";
    protected static final String RULE_FOLDER = "/rules/";
    protected static final String RULE_FILEEXT = ".rules";
    @Context
    UriInfo uriInfo;

    @GET
    @Produces(value={"application/json"})
    public Response httpGetModelList(@Context HttpHeaders headers) {
        logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        RuleSourceListBean responseObject = this.getRuleModelList();
        return Response.ok((Object)responseObject).build();
    }

    @GET
    @Path(value="/{modelname: .+}")
    @Produces(value={"application/json"})
    public Response httpGetModelSource(@Context HttpHeaders headers, @PathParam(value="modelname") String modelName) {
        logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        RuleSourceBean responseObject = this.getRuleModelSource(modelName);
        return Response.ok((Object)responseObject).build();
    }

    @PUT
    @Path(value="/{modelname: .+}")
    @Produces(value={"application/json"})
    public Response httpPutModelSource(@Context HttpHeaders headers, @PathParam(value="modelname") String modelName, RuleSourceBean rule) {
        logger.debug("Received HTTP PUT request at '{}'", (Object)this.uriInfo.getPath());
        RuleSourceBean responseObject = this.putRuleModelSource(modelName, rule);
        return Response.ok((Object)responseObject).build();
    }

    private RuleSourceListBean getRuleModelList() {
        RuleSourceListBean beans = new RuleSourceListBean();
        File[] files = new File(String.valueOf(ConfigConstants.getConfigFolder()) + RULE_FOLDER).listFiles();
        if (files == null) {
            return beans;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String modelName = file.getName();
            if (modelName.endsWith(RULE_FILEEXT)) {
                RuleSourceBean bean = new RuleSourceBean();
                bean.name = modelName.substring(0, modelName.length() - RULE_FILEEXT.length());
                beans.rules.add(bean);
            }
            ++n2;
        }
        return beans;
    }

    private RuleSourceBean putRuleModelSource(String modelName, RuleSourceBean rule) {
        String orgName = String.valueOf(ConfigConstants.getConfigFolder()) + RULE_FOLDER + modelName + RULE_FILEEXT;
        String newName = String.valueOf(ConfigConstants.getConfigFolder()) + RULE_FOLDER + modelName + RULE_FILEEXT + ".new";
        String bakName = String.valueOf(ConfigConstants.getConfigFolder()) + RULE_FOLDER + modelName + RULE_FILEEXT + ".bak";
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newName), "UTF-8"));
            out.write(rule.source);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File bakFile = new File(bakName);
        File orgFile = new File(orgName);
        File newFile = new File(newName);
        if (bakFile.exists()) {
            bakFile.delete();
        }
        orgFile.renameTo(bakFile);
        newFile.renameTo(orgFile);
        return this.getRuleModelSource(modelName);
    }

    private RuleSourceBean getRuleModelSource(String modelName) {
        RuleSourceBean rule = new RuleSourceBean();
        rule.name = modelName;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(String.valueOf(ConfigConstants.getConfigFolder()) + RULE_FOLDER + modelName + RULE_FILEEXT);
            rule.source = IOUtils.toString((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rule;
    }
}

