/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.floorplan;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import io.swagger.annotations.Api;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.openhab.ui.habmin.HABminConstants;
import org.openhab.ui.habmin.internal.services.floorplan.FloorplanConfigBean;
import org.openhab.ui.habmin.internal.services.floorplan.FloorplanHotspotConfigBean;
import org.openhab.ui.habmin.internal.services.floorplan.FloorplanListBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="habmin/floorplan")
@Api(value="habmin-floorplan")
public class FloorplanResource
implements RESTResource {
    public static final String PATH = "habmin/floorplan";
    public static final String API = "habmin-floorplan";
    private static String FLOORPLAN_FILE = "floorplans.xml";
    private static final Logger logger = LoggerFactory.getLogger(FloorplanResource.class);
    @Context
    UriInfo uriInfo;

    @GET
    @Produces(value={"application/json"})
    public Response httpGetFloorplans(@Context HttpHeaders headers) {
        logger.trace("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
        List<FloorplanConfigBean> responseObject = this.getFloorplanList();
        return Response.ok(responseObject).build();
    }

    @POST
    @Produces(value={"application/json"})
    public Response httpPostFloorplan(@Context HttpHeaders headers, FloorplanConfigBean floorplan) {
        logger.trace("Received HTTP POST request at '{}'.", (Object)this.uriInfo.getPath());
        FloorplanConfigBean responseObject = this.putFloorplanBean(0, floorplan);
        return Response.ok((Object)responseObject).build();
    }

    @GET
    @Path(value="/{floorplanID: [0-9]*}")
    @Produces(value={"application/json"})
    public Response httpGetFloorplan(@Context HttpHeaders headers, @PathParam(value="floorplanID") Integer floorplanID) {
        logger.trace("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
        FloorplanConfigBean responseObject = this.getFloorplan(floorplanID);
        return Response.ok((Object)responseObject).build();
    }

    @PUT
    @Path(value="/{floorplanID: [0-9]*}")
    @Produces(value={"application/json"})
    public Response httpPutFloorplan(@Context HttpHeaders headers, @PathParam(value="floorplanID") Integer floorplanID, FloorplanConfigBean floorplan) {
        logger.trace("Received HTTP PUT request at '{}'.", (Object)this.uriInfo.getPath());
        FloorplanConfigBean responseObject = this.putFloorplanBean(floorplanID, floorplan);
        return Response.ok((Object)responseObject).build();
    }

    @DELETE
    @Path(value="/{floorplanID: [0-9]*}")
    @Produces(value={"application/json"})
    public Response httpDeleteFloorplan(@Context HttpHeaders headers, @QueryParam(value="type") String type, @PathParam(value="floorplanID") Integer floorplanID) {
        logger.trace("Received HTTP DELETE request at '{}'.", (Object)this.uriInfo.getPath());
        List<FloorplanConfigBean> responseObject = this.deleteFloorplan(floorplanID);
        return Response.ok(responseObject).build();
    }

    @GET
    @Path(value="/{floorplanID: [0-9]*}/image")
    @Produces(value={"image/jpeg"})
    public Response httpGetFloorplanImage(@Context HttpHeaders headers, @PathParam(value="floorplanID") String floorplanID) {
        File folder = new File(HABminConstants.getDataDirectory());
        if (!folder.exists()) {
            logger.debug("Creating directory {}", (Object)HABminConstants.getDataDirectory());
            folder.mkdirs();
        }
        File file = new File(folder + "/floorplan-" + floorplanID + ".img");
        return Response.ok((Object)file).build();
    }

    private FloorplanConfigBean putFloorplanBean(Integer floorplanRef, FloorplanConfigBean bean) {
        bean.id = floorplanRef == 0 ? null : floorplanRef;
        FloorplanListBean list = this.loadFloorplans();
        int high = 0;
        FloorplanConfigBean foundFloorplan = null;
        for (FloorplanConfigBean i : list.entries) {
            if (i.id > high) {
                high = i.id;
            }
            if (i.id.intValue() != floorplanRef.intValue()) continue;
            foundFloorplan = i;
        }
        if (foundFloorplan != null) {
            list.entries.remove(foundFloorplan);
        }
        if (bean.id == null) {
            bean.id = high + 1;
        }
        if (bean.imgBase64 != null) {
            byte[] data = Base64.decodeBase64((String)bean.imgBase64);
            File folder = new File(HABminConstants.getDataDirectory());
            if (!folder.exists()) {
                logger.debug("Creating directory {}", (Object)HABminConstants.getDataDirectory());
                folder.mkdirs();
            }
            try {
                FileOutputStream fos = new FileOutputStream(folder + "/floorplan-" + bean.id + ".img");
                BufferedOutputStream out = new BufferedOutputStream(fos);
                out.write(data);
                out.flush();
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            bean.imgBase64 = null;
        }
        list.entries.add(bean);
        this.saveFloorplans(list);
        return bean;
    }

    private List<FloorplanConfigBean> getFloorplanList() {
        FloorplanListBean floorplans = this.loadFloorplans();
        ArrayList<FloorplanConfigBean> list = new ArrayList<FloorplanConfigBean>();
        for (FloorplanConfigBean i : floorplans.entries) {
            FloorplanConfigBean newFloorplan = new FloorplanConfigBean();
            newFloorplan.id = i.id;
            newFloorplan.name = i.name;
            newFloorplan.category = i.category;
            list.add(newFloorplan);
        }
        return list;
    }

    private FloorplanConfigBean getFloorplan(Integer floorplanRef) {
        FloorplanListBean floorplans = this.loadFloorplans();
        for (FloorplanConfigBean i : floorplans.entries) {
            if (i.id.intValue() != floorplanRef.intValue()) continue;
            return i;
        }
        return null;
    }

    private List<FloorplanConfigBean> deleteFloorplan(Integer floorplanRef) {
        FloorplanListBean floorplans = this.loadFloorplans();
        FloorplanConfigBean foundFloorplan = null;
        for (FloorplanConfigBean i : floorplans.entries) {
            if (i.id.intValue() != floorplanRef.intValue()) continue;
            foundFloorplan = i;
            break;
        }
        if (foundFloorplan != null) {
            floorplans.entries.remove(foundFloorplan);
            File folder = new File(HABminConstants.getDataDirectory());
            if (folder.exists()) {
                File file = new File(folder, "floorplan-" + floorplanRef + ".img");
                file.delete();
            }
        }
        this.saveFloorplans(floorplans);
        return this.getFloorplanList();
    }

    private boolean saveFloorplans(FloorplanListBean floorplan) {
        File folder = new File(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            long timerStart = System.currentTimeMillis();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/" + FLOORPLAN_FILE), "UTF-8"));
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xstream.alias("floorplans", FloorplanListBean.class);
            xstream.alias("floorplan", FloorplanConfigBean.class);
            xstream.alias("hotspot", FloorplanHotspotConfigBean.class);
            xstream.processAnnotations(FloorplanListBean.class);
            xstream.toXML((Object)floorplan, (Writer)out);
            out.close();
            long timerStop = System.currentTimeMillis();
            logger.debug("Floorplan list saved in {}ms.", (Object)(timerStop - timerStart));
        }
        catch (FileNotFoundException e) {
            logger.debug("Unable to open Floorplan list for SAVE - ", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.debug("Unable to write Floorplan list for SAVE - ", (Throwable)e);
            return false;
        }
        return true;
    }

    private FloorplanListBean loadFloorplans() {
        FloorplanListBean floorplans = null;
        try {
            long timerStart = System.currentTimeMillis();
            FileInputStream fin = new FileInputStream(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/" + FLOORPLAN_FILE);
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xstream.alias("floorplans", FloorplanListBean.class);
            xstream.alias("floorplan", FloorplanConfigBean.class);
            xstream.alias("hotspot", FloorplanHotspotConfigBean.class);
            xstream.processAnnotations(FloorplanListBean.class);
            floorplans = (FloorplanListBean)xstream.fromXML((InputStream)fin);
            fin.close();
            long timerStop = System.currentTimeMillis();
            logger.debug("Floorplans loaded in {}ms.", (Object)(timerStop - timerStart));
        }
        catch (FileNotFoundException e) {
            floorplans = new FloorplanListBean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return floorplans;
    }
}

