/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableSetBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(VariableSetBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        DesignerFieldBean varField = this.findField(block.fields, "VAR");
        if (varField == null) {
            logger.error("VARIABLE SET contains no VAR");
            return null;
        }
        DesignerChildBean child = this.findChild(block.children, "VALUE");
        if (child == null) {
            logger.error("VARIABLE SET contains no VALUE");
            return null;
        }
        String value = this.callBlock(ruleContext, child.block);
        String varType = "Number";
        String varDefault = "0";
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            varType = null;
        }
        if (varType == null && (value.equals("true") || value.equals("false"))) {
            varType = "boolean";
            varDefault = "false";
        }
        ruleContext.addGlobal("var " + varType + " " + varField.value + " = " + varDefault);
        return String.valueOf(this.startLine(ruleContext.level)) + varField.value + " = " + value + "\r\n";
    }
}

