/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RuleContext {
    List<Trigger> triggerList = new ArrayList<Trigger>();
    List<String> importList = new ArrayList<String>();
    List<String> globalList = new ArrayList<String>();
    HashMap<String, String> constantList = new HashMap();
    int cronTime = 0;
    int ruleId = 0;
    int globalId = 0;
    int level = 0;

    RuleContext(int id) {
        this.ruleId = id;
    }

    String getGlobalId() {
        int a = this.globalId / 26;
        int b = this.globalId % 26;
        String id = String.format("_%03d_", this.ruleId);
        if (a > 0) {
            id = String.valueOf(id) + (char)(a + 65);
        }
        id = String.valueOf(id) + (char)(b + 65);
        ++this.globalId;
        return id;
    }

    List<Trigger> getTriggerList() {
        return this.triggerList;
    }

    void addTrigger(String item, TriggerType type) {
        Trigger trigger2;
        for (Trigger trigger2 : this.triggerList) {
            if (!trigger2.item.equalsIgnoreCase(item)) continue;
            if (trigger2.type == TriggerType.COMMAND && type == TriggerType.COMMAND) {
                return;
            }
            if (trigger2.type == TriggerType.UPDATED || type == TriggerType.UPDATED) {
                trigger2.type = TriggerType.UPDATED;
            }
            return;
        }
        trigger2 = new Trigger();
        trigger2.item = item;
        trigger2.type = type;
        this.triggerList.add(trigger2);
    }

    void addConstant(String name, String value) {
        this.constantList.put(name, value);
    }

    String getConstant(String name) {
        return this.constantList.get(name);
    }

    HashMap<String, String> getConstantList() {
        return this.constantList;
    }

    List<String> getImportList() {
        return this.importList;
    }

    void addImport(String newImport) {
        for (String s : this.importList) {
            if (!s.equals(newImport)) continue;
            return;
        }
        this.importList.add(newImport);
    }

    List<String> getGlobalList() {
        return this.globalList;
    }

    void addGlobal(String newGlobal) {
        for (String s : this.globalList) {
            if (!s.equals(newGlobal)) continue;
            return;
        }
        this.globalList.add(newGlobal);
    }

    void setCron(int time) {
        if (time == 0) {
            return;
        }
        if (this.cronTime == 0) {
            this.cronTime = time;
        }
        if (time < this.cronTime) {
            this.cronTime = time;
        }
    }

    int getCron() {
        return this.cronTime;
    }

    static enum CronType {
        STARTED(0, "System started"),
        SHUTDOWN(0, "System shutdown"),
        MIDNIGHT(0, "Time is midnight"),
        MIDDAY(0, "Time is midday"),
        CRON5SECONDS(5, "Time cron \"0/5 * * * * ?\""),
        CRON6SECONDS(6, "Time cron \"0/6 * * * * ?\""),
        CRON7SECONDS(7, "Time cron \"0/7 * * * * ?\""),
        CRON8SECONDS(8, "Time cron \"0/8 * * * * ?\""),
        CRON9SECONDS(9, "Time cron \"0/9 * * * * ?\""),
        CRON10SECONDS(10, "Time cron \"0/10 * * * * ?\""),
        CRON11SECONDS(11, "Time cron \"0/11 * * * * ?\""),
        CRON12SECONDS(12, "Time cron \"0/12 * * * * ?\""),
        CRON13SECONDS(13, "Time cron \"0/13 * * * * ?\""),
        CRON14SECONDS(14, "Time cron \"0/14 * * * * ?\""),
        CRON15SECONDS(15, "Time cron \"0/15 * * * * ?\""),
        CRON20SECONDS(20, "Time cron \"0/20 * * * * ?\""),
        CRON30SECONDS(30, "Time cron \"0/30 * * * * ?\""),
        CRON1MINUTE(60, "Time cron \"0 * * * * ?\""),
        CRON2MINUTE(120, "Time cron \"0 0/2 * * * ?\""),
        CRON3MINUTE(180, "Time cron \"0 0/3 * * * ?\""),
        CRON4MINUTE(240, "Time cron \"0 0/4 * * * ?\""),
        CRON5MINUTE(300, "Time cron \"0 0/5 * * * ?\""),
        CRON6MINUTE(360, "Time cron \"0 0/6 * * * ?\""),
        CRON7MINUTE(420, "Time cron \"0 0/7 * * * ?\""),
        CRON8MINUTE(480, "Time cron \"0 0/8 * * * ?\""),
        CRON9MINUTE(540, "Time cron \"0 0/9 * * * ?\""),
        CRON10MINUTE(600, "Time cron \"0 0/10 * * * ?\""),
        CRON15MINUTE(900, "Time cron \"0 0/15 * * * ?\""),
        CRON20MINUTE(1200, "Time cron \"0 0/20 * * * ?\""),
        CRON30MINUTE(1800, "Time cron \"0 0/30 * * * ?\""),
        CRON1HOUR(3600, "Time cron \"0 0 * * * ?\""),
        CRON2HOUR(7200, "Time cron \"0 0 0/2 * * ?\""),
        CRON3HOUR(10800, "Time cron \"0 0 0/3 * * ?\""),
        CRON4HOUR(14400, "Time cron \"0 0 0/4 * * ?\""),
        CRON6HOUR(21600, "Time cron \"0 0 0/6 * * ?\""),
        CRON8HOUR(28800, "Time cron \"0 0 0/8 * * ?\""),
        CRON12HOUR(43200, "Time cron \"0 0 0/12 * * ?\""),
        CRON1DAY(86400, "Time cron \"0 0 0 * * ?\""),
        CRONFOREVER(Integer.MAX_VALUE, "Time cron \"0 0 0 * * ?\"");

        private int period;
        private String value;

        private CronType(int period, String value) {
            this.period = period;
            this.value = value;
        }

        public static CronType fromPeriod(int period) {
            CronType lowest = null;
            CronType[] cronTypeArray = CronType.values();
            int n = cronTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CronType c = cronTypeArray[n2];
                if (c.period != 0) {
                    if (lowest == null) {
                        lowest = c;
                    }
                    if (period > lowest.period && c.period <= period) {
                        lowest = c;
                    }
                }
                ++n2;
            }
            return lowest;
        }

        public static CronType fromString(String text) {
            if (text != null) {
                CronType[] cronTypeArray = CronType.values();
                int n = cronTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CronType c = cronTypeArray[n2];
                    if (text.equalsIgnoreCase(c.name())) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }

    class Trigger {
        String item;
        TriggerType type;
        String value1;
        String value2;

        Trigger() {
        }
    }

    static enum TriggerType {
        CHANGED("changed"),
        UPDATED("received update"),
        COMMAND("received command");

        private String value;

        private TriggerType(String value) {
            this.value = value;
        }

        public static TriggerType fromString(String text) {
            if (text != null) {
                TriggerType[] triggerTypeArray = TriggerType.values();
                int n = triggerTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TriggerType c = triggerTypeArray[n2];
                    if (text.equalsIgnoreCase(c.name())) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

