/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenhabTimeBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(OpenhabTimeBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        DesignerFieldBean field;
        String blockString = new String();
        ruleContext.addImport("org.joda.time.*");
        if (block.comment != null) {
            String[] comments;
            String[] stringArray = comments = block.comment.text.split("\\r?\\n");
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                String comment = stringArray[n2];
                blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "// " + comment + "\r\n";
                ++n2;
            }
        }
        if ((field = this.findField(block.fields, "COMPARE")) == null) {
            logger.error("OPENHAB TIME contains no COMPARE.");
            return null;
        }
        Compare compare = Compare.valueOf(field.value);
        if (compare == null) {
            logger.error("OPENHAB TIME contains invalid COMPARE.");
            return null;
        }
        field = this.findField(block.fields, "HOUR");
        if (field == null) {
            logger.error("OPENHAB TIME contains no HOUR.");
            return null;
        }
        Integer hour = Integer.valueOf(field.value);
        if (hour == null) {
            logger.error("OPENHAB TIME contains invalid HOUR.");
            return null;
        }
        field = this.findField(block.fields, "MIN");
        if (field == null) {
            logger.error("OPENHAB TIME contains no MIN.");
            return null;
        }
        Integer min = Integer.valueOf(field.value);
        if (min == null) {
            logger.error("OPENHAB TIME contains invalid MIN.");
            return null;
        }
        if (min != 0) {
            ruleContext.setCron(60);
        } else if (hour != 0) {
            ruleContext.setCron(3600);
        } else {
            ruleContext.setCron(86400);
        }
        blockString = "((new LocalTime().getLocalMillis()) " + compare.toString() + " (new LocalTime(" + hour + ", " + min + ", 0, 0).getLocalMillis()))";
        return blockString;
    }

    static enum Compare {
        BEFORE("<="),
        AFTER(">=");

        private String value;

        private Compare(String value) {
            this.value = value;
        }

        public static Compare fromString(String text) {
            if (text != null) {
                Compare[] compareArray = Compare.values();
                int n = compareArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Compare c = compareArray[n2];
                    if (text.equalsIgnoreCase(c.name())) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

