/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenhabStateOnOffBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(OpenhabStateOnOffBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        String blockString = new String();
        DesignerFieldBean operatorField = this.findField(block.fields, "STATE");
        if (operatorField == null) {
            logger.error("OPENHAB STATE ONOFF contains no field STATE");
            return null;
        }
        Operators op = Operators.valueOf(operatorField.value.toUpperCase());
        if (op == null) {
            logger.error("OPENHAB STATE ONOFF contains invalid field STATE ({})", (Object)operatorField.name.toUpperCase());
            return null;
        }
        blockString = op.toString();
        return blockString;
    }

    static enum Operators {
        ON,
        OFF;

    }
}

