/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenhabRuleBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(OpenhabRuleBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        String blockString = new String();
        String ruleString = new String();
        ruleContext.addImport("org.openhab.core.library.types.*");
        ruleContext.addImport("org.openhab.core.persistence.*");
        ruleContext.addImport("org.openhab.model.script.actions.*");
        DesignerFieldBean nameField = this.findField(block.fields, "NAME");
        if (nameField == null) {
            logger.error("ROOT block must have a name.");
            return null;
        }
        DesignerChildBean child = this.findChild(block.children, "CONSTANT");
        if (child != null) {
            this.callBlock(ruleContext, child.block);
        }
        ++ruleContext.level;
        child = this.findChild(block.children, "STACK");
        if (child != null) {
            String response = this.callBlock(ruleContext, child.block);
            if (response == null) {
                return null;
            }
            ruleString = String.valueOf(ruleString) + response;
        }
        --ruleContext.level;
        if (block.comment != null) {
            String[] comments;
            String[] stringArray = comments = block.comment.text.split("\\r?\\n");
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                String comment = stringArray[n2];
                blockString = String.valueOf(blockString) + "// " + comment + "\r\n";
                ++n2;
            }
            blockString = String.valueOf(blockString) + "\r\n";
        }
        blockString = String.valueOf(blockString) + "rule \"" + nameField.value + "\"\r\n";
        blockString = String.valueOf(blockString) + "when\r\n";
        boolean firstTrigger = true;
        if (ruleContext.cronTime != 0) {
            RuleContext.CronType cron = RuleContext.CronType.fromPeriod(ruleContext.cronTime);
            if (cron != null) {
                blockString = String.valueOf(blockString) + "    " + cron.toString() + "\r\n";
            }
            firstTrigger = false;
        }
        for (RuleContext.Trigger trigger : ruleContext.getTriggerList()) {
            if (!firstTrigger) {
                blockString = String.valueOf(blockString) + "    or\r\n";
            }
            blockString = String.valueOf(blockString) + "    Item " + trigger.item + " " + trigger.type.toString();
            switch (trigger.type) {
                case CHANGED: {
                    if (trigger.value1 != null) {
                        blockString = String.valueOf(blockString) + " from " + trigger.value1;
                    }
                    if (trigger.value2 == null) break;
                    blockString = String.valueOf(blockString) + " to " + trigger.value2;
                    break;
                }
                case UPDATED: {
                    if (trigger.value1 == null) break;
                    blockString = String.valueOf(blockString) + " " + trigger.value1;
                    break;
                }
                case COMMAND: {
                    if (trigger.value1 == null) break;
                    blockString = String.valueOf(blockString) + " " + trigger.value1;
                }
            }
            blockString = String.valueOf(blockString) + "\r\n";
            firstTrigger = false;
        }
        blockString = String.valueOf(blockString) + "then\r\n";
        blockString = String.valueOf(blockString) + ruleString;
        blockString = String.valueOf(blockString) + "end\r\n";
        return blockString;
    }
}

