/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenhabPersistenceGetBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(OpenhabPersistenceGetBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        String blockString = new String();
        DesignerFieldBean varField = this.findField(block.fields, "ITEM");
        if (varField == null) {
            logger.error("PERSISTENCE GET contains no VAR");
            return null;
        }
        DesignerFieldBean field = this.findField(block.fields, "PERIOD");
        if (field == null) {
            logger.error("PERSISTENCE GET TIMER contains no PERIOD.");
            return null;
        }
        Period period = Period.fromString(field.value);
        if (period == null) {
            logger.error("PERSISTENCE GET TIMER contains invalid PERIOD.");
            return null;
        }
        field = this.findField(block.fields, "NUM");
        if (field == null) {
            logger.error("PERSISTENCE GET TIMER contains no NUM.");
            return null;
        }
        int periodNum = Integer.parseInt(field.value);
        int timeSeconds = 0;
        switch (period) {
            case SECONDS: {
                timeSeconds = periodNum;
                break;
            }
            case MINUTES: {
                timeSeconds = periodNum * 60;
                break;
            }
            case HOURS: {
                timeSeconds = periodNum * 3600;
            }
        }
        DesignerFieldBean typeField = this.findField(block.fields, "TYPE");
        if (typeField == null) {
            logger.error("PERSISTENCE GET contains no field TYPE");
            return null;
        }
        Operators type = Operators.valueOf(typeField.value.toUpperCase());
        if (type == null) {
            logger.error("PERSISTENCE GET contains invalid field TYPE ({})", (Object)typeField.name.toUpperCase());
            return null;
        }
        ruleContext.setCron(timeSeconds / 500);
        String val = varField.value;
        if (this.getItem(val) != null) {
            ruleContext.addTrigger(varField.value, RuleContext.TriggerType.CHANGED);
        }
        blockString = String.valueOf(varField.value) + "." + type.toString() + "(now.minus" + period.toString() + "(" + periodNum + ")).state";
        return blockString;
    }

    static enum Operators {
        STATE("historicState"),
        CHANGED("changedSince"),
        UPDATED("updatedSince"),
        AVERAGE("averageSince"),
        MINIMUM("minimumSince"),
        MAXIMUM("maximumSince");

        private String value;

        private Operators(String value) {
            this.value = value;
        }

        public static Operators fromString(String text) {
            if (text != null) {
                Operators[] operatorsArray = Operators.values();
                int n = operatorsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Operators c = operatorsArray[n2];
                    if (text.equalsIgnoreCase(c.name())) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }

    static enum Period {
        SECONDS("Seconds"),
        MINUTES("Minutes"),
        HOURS("Hours");

        private String value;

        private Period(String value) {
            this.value = value;
        }

        public static Period fromString(String text) {
            if (text != null) {
                Period[] periodArray = Period.values();
                int n = periodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Period c = periodArray[n2];
                    if (text.equalsIgnoreCase(c.name())) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

