/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenhabItemSetBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(OpenhabItemSetBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        DesignerFieldBean varField = this.findField(block.fields, "ITEM");
        if (varField == null) {
            logger.error("ITEM SET contains no VAR");
            return null;
        }
        DesignerChildBean child = this.findChild(block.children, "VALUE");
        if (child == null) {
            logger.error("ITEM SET contains no VALUE");
            return null;
        }
        String value = this.callBlock(ruleContext, child.block);
        return String.valueOf(this.startLine(ruleContext.level)) + "postUpdate(" + varField.value + ", " + value + ")" + "\r\n";
    }
}

