/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenhabIfTimerBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(OpenhabIfTimerBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        DesignerChildBean child;
        String blockString = new String();
        String timerID = "_timer" + ruleContext.getGlobalId();
        ruleContext.addGlobal("var Timer " + timerID + " = null");
        if (block.comment != null) {
            String[] comments;
            String[] stringArray = comments = block.comment.text.split("\\r?\\n");
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                String comment = stringArray[n2];
                blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "// " + comment + "\r\n";
                ++n2;
            }
        }
        if ((child = this.findChild(block.children, "IF0")) == null) {
            logger.error("OPENHAB IF TIMER contains no IF0.");
            return null;
        }
        String response = this.callBlock(ruleContext, child.block);
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "if (" + response + ") {" + "\r\n";
        ++ruleContext.level;
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "if (" + timerID + " == null) {" + "\r\n";
        DesignerFieldBean field = this.findField(block.fields, "PERIOD");
        if (field == null) {
            logger.error("OPENHAB IF TIMER contains no PERIOD.");
            return null;
        }
        Period period = Period.fromString(field.value);
        if (period == null) {
            logger.error("OPENHAB IF TIMER contains invalid PERIOD.");
            return null;
        }
        field = this.findField(block.fields, "NUM");
        if (field == null) {
            logger.error("OPENHAB IF TIMER contains no NUM.");
            return null;
        }
        ++ruleContext.level;
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + timerID + " = createTimer(now.plus" + period.toString() + "(" + field.value + ")) [|" + "\r\n";
        ++ruleContext.level;
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + timerID + ".cancel()" + "\r\n";
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + timerID + " = null" + "\r\n";
        child = this.findChild(block.children, "DO0");
        if (child == null) {
            logger.error("OPENHAB IF TIMER contains no DO0");
            return null;
        }
        blockString = String.valueOf(blockString) + this.callBlock(ruleContext, child.block);
        --ruleContext.level;
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "]" + "\r\n";
        --ruleContext.level;
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "}" + "\r\n";
        --ruleContext.level;
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "}" + "\r\n";
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "else if(" + timerID + " != null) {" + "\r\n";
        ++ruleContext.level;
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + timerID + ".cancel()" + "\r\n";
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + timerID + " = null" + "\r\n";
        --ruleContext.level;
        blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "}" + "\r\n";
        return blockString;
    }

    static enum Period {
        SECONDS("Seconds"),
        MINUTES("Minutes"),
        HOURS("Hours");

        private String value;

        private Period(String value) {
            this.value = value;
        }

        public static Period fromString(String text) {
            if (text != null) {
                Period[] periodArray = Period.values();
                int n = periodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Period c = periodArray[n2];
                    if (text.equalsIgnoreCase(c.name())) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

