/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenhabConstantSetBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(OpenhabConstantSetBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        DesignerFieldBean varField = this.findField(block.fields, "CONSTANT");
        if (varField == null) {
            logger.error("CONSTANT SET contains no CONSTANT");
            return null;
        }
        DesignerChildBean child = this.findChild(block.children, "VALUE");
        if (child == null) {
            logger.error("CONSTANT SET contains no VALUE");
            return null;
        }
        String value = this.callBlock(ruleContext, child.block);
        ruleContext.addConstant(varField.value, value);
        return "";
    }
}

