/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenhabConstantGetBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(OpenhabConstantGetBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        DesignerFieldBean varField = this.findField(block.fields, "CONSTANT");
        if (varField == null) {
            logger.error("CONSTANT GET contains no CONSTANT");
            return null;
        }
        String constant = ruleContext.getConstant(varField.value);
        if (constant == null) {
            logger.error("CONSTANT GET can't find constant {}", (Object)constant);
            return null;
        }
        return constant;
    }
}

