/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathConstrainBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(MathConstrainBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        String blockString = new String();
        DesignerChildBean child = this.findChild(block.children, "VALUE");
        if (child == null) {
            logger.error("MATH CONSTRAIN contains no VALUE");
            return null;
        }
        String blockValue = this.callBlock(ruleContext, child.block);
        child = this.findChild(block.children, "LOW");
        if (child == null) {
            logger.error("MATH CONSTRAIN contains no LOW");
            return null;
        }
        String blockLow = this.callBlock(ruleContext, child.block);
        child = this.findChild(block.children, "HIGH");
        if (child == null) {
            logger.error("MATH CONSTRAIN contains no HIGH");
            return null;
        }
        String blockHigh = this.callBlock(ruleContext, child.block);
        blockString = "if(" + blockValue + ">" + blockHigh + ") " + blockHigh + "\r\n";
        blockString = "if(" + blockValue + "<" + blockLow + ") " + blockLow + "\r\n";
        return blockString;
    }
}

