/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathArithmeticBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(MathArithmeticBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        String B;
        String blockString = new String();
        ruleContext.addImport("org.java.math.*");
        DesignerChildBean child = this.findChild(block.children, "A");
        if (child == null) {
            logger.error("MATH ARITHMETIC contains no A");
            return null;
        }
        String blockA = this.callBlock(ruleContext, child.block);
        child = this.findChild(block.children, "B");
        if (child == null) {
            logger.error("MATH ARITHMETIC contains no B");
            return null;
        }
        String blockB = this.callBlock(ruleContext, child.block);
        DesignerFieldBean operatorField = this.findField(block.fields, "OP");
        if (operatorField == null) {
            logger.error("MATH ARITHMETIC contains no field OP");
            return null;
        }
        Operators op = Operators.valueOf(operatorField.value.toUpperCase());
        if (op == null) {
            logger.error("MATH ARITHMETIC contains invalid field OP ({})", (Object)operatorField.name.toUpperCase());
            return null;
        }
        String A = blockA;
        if (A.endsWith(".state")) {
            A = String.valueOf(A) + " as DecimalType";
        }
        if ((B = blockB).endsWith(".state")) {
            B = String.valueOf(B) + " as DecimalType";
        }
        blockString = "(" + A + " " + op.toString() + " " + B + ")";
        return blockString;
    }

    static enum Operators {
        ADD("+"),
        MINUS("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        POWER("^");

        private String value;

        private Operators(String value) {
            this.value = value;
        }

        public static Operators fromString(String text) {
            if (text != null) {
                Operators[] operatorsArray = Operators.values();
                int n = operatorsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Operators c = operatorsArray[n2];
                    if (text.equalsIgnoreCase(c.name())) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

