/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerMutationBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicOperationBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(LogicOperationBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        String blockString = new String();
        DesignerChildBean child = this.findChild(block.children, "IN0");
        if (child == null) {
            logger.error("LOGIC COMPARE contains no IN0");
            return null;
        }
        String blockA = this.callBlock(ruleContext, child.block);
        blockString = "(" + blockA;
        DesignerMutationBean mutation = this.findMutation(block.mutation, "operators");
        int operators = 1;
        if (mutation != null) {
            operators += Integer.parseInt(mutation.value);
        }
        int x = 1;
        while (x <= operators) {
            child = this.findChild(block.children, "IN" + x);
            if (child == null) {
                logger.error("LOGIC COMPARE contains no IN" + x);
                return null;
            }
            String blockOp = this.callBlock(ruleContext, child.block);
            DesignerFieldBean operatorField = this.findField(block.fields, "OP" + x);
            if (operatorField == null) {
                logger.error("LOGIC OPERATION contains no field OP" + x);
                return null;
            }
            Operators op = Operators.valueOf(operatorField.value.toUpperCase());
            if (op == null) {
                logger.error("LOGIC OPERATION contains invalid field OP ({})", (Object)operatorField.name.toUpperCase());
                return null;
            }
            blockString = String.valueOf(blockString) + " " + op.toString() + " " + blockOp;
            ++x;
        }
        blockString = String.valueOf(blockString) + ")";
        return blockString;
    }

    static enum Operators {
        AND("&&"),
        OR("||");

        private String value;

        private Operators(String value) {
            this.value = value;
        }

        public static Operators fromString(String text) {
            if (text != null) {
                Operators[] operatorsArray = Operators.values();
                int n = operatorsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Operators c = operatorsArray[n2];
                    if (text.equalsIgnoreCase(c.name())) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

