/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicBooleanBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(LogicBooleanBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        String blockString = new String();
        DesignerFieldBean operatorField = this.findField(block.fields, "BOOL");
        if (operatorField == null) {
            logger.error("LOGIC OPERATION contains no field BOOL");
            return null;
        }
        Operators op = Operators.valueOf(operatorField.value.toUpperCase());
        if (op == null) {
            logger.error("LOGIC BOOLEAN contains invalid field BOOL ({})", (Object)operatorField.name.toUpperCase());
            return null;
        }
        blockString = op.toString();
        return blockString;
    }

    static enum Operators {
        TRUE("true"),
        FALSE("false");

        private String value;

        private Operators(String value) {
            this.value = value;
        }

        public static Operators fromString(String text) {
            if (text != null) {
                Operators[] operatorsArray = Operators.values();
                int n = operatorsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Operators c = operatorsArray[n2];
                    if (text.equalsIgnoreCase(c.name())) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

