/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerMutationBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerResource;
import org.openhab.ui.habmin.internal.services.designer.blocks.ControlIfBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.LogicBooleanBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.LogicCompareBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.LogicNegateBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.LogicOperationBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.MathArithmeticBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.MathConstrainBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.MathNumberBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.MathRoundBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabConstantGetBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabConstantSetBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabIfTimerBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabItemCmdBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabItemGetBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabItemSetBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabPersistenceGetBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabRuleBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabStateOnOffBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabStateOpenClosedBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.OpenhabTimeBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.openhab.ui.habmin.internal.services.designer.blocks.TextBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.VariableGetBlock;
import org.openhab.ui.habmin.internal.services.designer.blocks.VariableSetBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(DesignerRuleCreator.class);
    static final String EOL = "\r\n";
    static final String ruleExtension = ".rules";
    public static final String PATH_RULES = "rules/";
    private static HashMap<String, Class<? extends DesignerRuleCreator>> blockMap = null;

    abstract String processBlock(RuleContext var1, DesignerBlockBean var2);

    String callBlock(RuleContext context, DesignerBlockBean block) {
        if (block == null) {
            logger.error("Block is null!");
            return null;
        }
        DesignerRuleCreator processor = DesignerRuleCreator.getBlockProcessor(block.type);
        if (processor == null) {
            logger.error("Error finding processor for block type '{}'.", (Object)block.type);
            return "\r\n*** Unknown Block \"" + block.type + "\"" + EOL;
        }
        String blockString = processor.processBlock(context, block);
        if (blockString == null) {
            return null;
        }
        if (block.next != null) {
            blockString = String.valueOf(blockString) + EOL;
            blockString = String.valueOf(blockString) + this.callBlock(context, block.next);
        }
        return blockString;
    }

    String startLine(int level) {
        String line = new String();
        int c = 0;
        while (c < level) {
            line = String.valueOf(line) + "  ";
            ++c;
        }
        return line;
    }

    protected Item getItem(String name) {
        block3: {
            try {
                if (DesignerResource.getItemRegistry() != null) break block3;
                return null;
            }
            catch (ItemNotFoundException e) {
                return null;
            }
        }
        return DesignerResource.getItemRegistry().getItem(name);
    }

    DesignerChildBean findChild(List<DesignerChildBean> children, String name) {
        if (children == null) {
            return null;
        }
        for (DesignerChildBean child : children) {
            if (child.name == null || !child.name.equalsIgnoreCase(name)) continue;
            return child;
        }
        return null;
    }

    DesignerMutationBean findMutation(List<DesignerMutationBean> mutations, String name) {
        if (mutations == null) {
            return null;
        }
        for (DesignerMutationBean mutation : mutations) {
            if (mutation.name == null || !mutation.name.equalsIgnoreCase(name)) continue;
            return mutation;
        }
        return null;
    }

    DesignerFieldBean findField(List<DesignerFieldBean> fields, String name) {
        if (fields == null) {
            return null;
        }
        for (DesignerFieldBean field : fields) {
            if (field.name == null || !field.name.equalsIgnoreCase(name)) continue;
            return field;
        }
        return null;
    }

    public static String makeRule(int id, String name, DesignerBlockBean rootBlock) {
        if (rootBlock.fields == null) {
            logger.error("Root block doesn't contain any fields.");
            return null;
        }
        if (!rootBlock.type.equalsIgnoreCase("openhab_rule")) {
            logger.error("Root block type is not an openhab rule.");
            return null;
        }
        if (rootBlock.children == null) {
            logger.error("Root block has no children.");
            return null;
        }
        if (rootBlock.children.size() == 0) {
            logger.error("Root block has no children.");
            return null;
        }
        if (name == null) {
            logger.error("Rule has no name.");
            return null;
        }
        name = name.trim();
        RuleContext context = new RuleContext(id);
        DesignerRuleCreator processor = DesignerRuleCreator.getBlockProcessor(rootBlock.type);
        if (processor == null) {
            logger.error("Error finding processor for ROOT block type '{}'.", (Object)rootBlock.type);
            return null;
        }
        String ruleString = processor.callBlock(context, rootBlock);
        if (ruleString == null) {
            return null;
        }
        String outputString = new String();
        outputString = String.valueOf(outputString) + "// This rule file is autogenerated by HABmin.\r\n";
        outputString = String.valueOf(outputString) + "// Any changes made manually to this file will be overwritten next time HABmin rules are saved.\r\n";
        outputString = String.valueOf(outputString) + EOL;
        if (context.getImportList().size() != 0) {
            outputString = String.valueOf(outputString) + "// Imports\r\n";
            for (String i : context.getImportList()) {
                outputString = String.valueOf(outputString) + "import " + i + EOL;
            }
            outputString = String.valueOf(outputString) + EOL;
        }
        if (context.getImportList().size() != 0) {
            outputString = String.valueOf(outputString) + "// Global Variables\r\n";
            for (String i : context.getGlobalList()) {
                outputString = String.valueOf(outputString) + i + EOL;
            }
            outputString = String.valueOf(outputString) + EOL;
        }
        if (context.getConstantList().size() != 0) {
            outputString = String.valueOf(outputString) + "// Constants used to generate this rule\r\n";
            for (Map.Entry<String, String> pairs : context.getConstantList().entrySet()) {
                outputString = String.valueOf(outputString) + "// " + pairs.getKey() + " == " + pairs.getValue() + EOL;
            }
            outputString = String.valueOf(outputString) + EOL;
        }
        outputString = String.valueOf(outputString) + ruleString;
        outputString = String.valueOf(outputString) + EOL;
        return outputString;
    }

    static String getFilename(int id, String name) {
        String fileRule = name.toLowerCase().replaceAll("[^a-z0-9.-]", "_");
        return String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + PATH_RULES + "(" + id + ")_" + fileRule + ruleExtension;
    }

    public static String saveRule(int id, String name, DesignerBlockBean rootBlock) {
        String ruleString = DesignerRuleCreator.makeRule(id, name, rootBlock);
        if (ruleString == null) {
            return null;
        }
        String fWildcard = "\\(" + id + "\\)_.*\\" + ruleExtension;
        File folder = new File(PATH_RULES);
        File[] allFiles = folder.listFiles();
        if (allFiles != null) {
            File[] fileArray = allFiles;
            int n = allFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().matches(fWildcard) && !file.delete()) {
                    logger.error("Can't remove " + file.getAbsolutePath());
                }
                ++n2;
            }
        }
        String fileName = DesignerRuleCreator.getFilename(id, name);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
            out.write(ruleString);
            out.write(EOL);
            out.close();
        }
        catch (IOException e) {
            logger.error("Error writing habmin rule file :", (Throwable)e);
        }
        return ruleString;
    }

    public static String loadSource(int id, String name) {
        String source = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(DesignerRuleCreator.getFilename(id, name));
            source = IOUtils.toString((InputStream)inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return source;
    }

    public static DesignerRuleCreator getBlockProcessor(String type) {
        if (blockMap == null) {
            blockMap = new HashMap();
            blockMap.put("controls_if", ControlIfBlock.class);
            blockMap.put("logic_operation", LogicOperationBlock.class);
            blockMap.put("logic_compare", LogicCompareBlock.class);
            blockMap.put("logic_boolean", LogicBooleanBlock.class);
            blockMap.put("logic_negate", LogicNegateBlock.class);
            blockMap.put("math_arithmetic", MathArithmeticBlock.class);
            blockMap.put("math_number", MathNumberBlock.class);
            blockMap.put("math_round", MathRoundBlock.class);
            blockMap.put("math_constrain", MathConstrainBlock.class);
            blockMap.put("variables_get", VariableGetBlock.class);
            blockMap.put("variables_set", VariableSetBlock.class);
            blockMap.put("openhab_constantget", OpenhabConstantGetBlock.class);
            blockMap.put("openhab_constantset", OpenhabConstantSetBlock.class);
            blockMap.put("openhab_itemget", OpenhabItemGetBlock.class);
            blockMap.put("openhab_itemset", OpenhabItemSetBlock.class);
            blockMap.put("openhab_itemcmd", OpenhabItemCmdBlock.class);
            blockMap.put("openhab_rule", OpenhabRuleBlock.class);
            blockMap.put("openhab_iftimer", OpenhabIfTimerBlock.class);
            blockMap.put("openhab_persistence_get", OpenhabPersistenceGetBlock.class);
            blockMap.put("openhab_state_onoff", OpenhabStateOnOffBlock.class);
            blockMap.put("openhab_state_openclosed", OpenhabStateOpenClosedBlock.class);
            blockMap.put("openhab_time", OpenhabTimeBlock.class);
            blockMap.put("text", TextBlock.class);
        }
        if (blockMap.get(type) == null) {
            return null;
        }
        try {
            Constructor<? extends DesignerRuleCreator> constructor = blockMap.get(type).getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error("Command processor error: {}", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("Command processor error: {}", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error("Command processor error: {}", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Command processor error: {}", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("Command processor error: {}", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("Command processor error: {}", (Throwable)e);
        }
        return null;
    }
}

