/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer.blocks;

import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerMutationBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.openhab.ui.habmin.internal.services.designer.blocks.RuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlIfBlock
extends DesignerRuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(ControlIfBlock.class);

    @Override
    String processBlock(RuleContext ruleContext, DesignerBlockBean block) {
        String response;
        DesignerChildBean child;
        String blockString = new String();
        if (block.comment != null) {
            String[] comments;
            String[] stringArray = comments = block.comment.text.split("\\r?\\n");
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                String comment = stringArray[n2];
                blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "// " + comment + "\r\n";
                ++n2;
            }
        }
        DesignerMutationBean mutation = this.findMutation(block.mutation, "elseif");
        int elseif = 1;
        if (mutation != null) {
            elseif += Integer.parseInt(mutation.value);
        }
        int x = 0;
        while (x < elseif) {
            child = this.findChild(block.children, "IF" + x);
            if (child == null) {
                logger.error("IF CONTROL contains no IF{} (mutation count was {}).", (Object)x, (Object)(elseif - 1));
                return null;
            }
            ++ruleContext.level;
            response = this.callBlock(ruleContext, child.block);
            --ruleContext.level;
            blockString = x == 0 ? String.valueOf(blockString) + this.startLine(ruleContext.level) + "if (" + response + ") {" + "\r\n" : String.valueOf(blockString) + this.startLine(ruleContext.level) + "else if (" + response + ") {" + "\r\n";
            child = this.findChild(block.children, "DO" + x);
            if (child == null) {
                logger.error("IF CONTROL contains no DO{} (mutation count was {}).", (Object)x, (Object)(elseif - 1));
                return null;
            }
            ++ruleContext.level;
            response = this.callBlock(ruleContext, child.block);
            --ruleContext.level;
            blockString = String.valueOf(blockString) + response;
            blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "}" + "\r\n";
            ++x;
        }
        mutation = this.findMutation(block.mutation, "else");
        if (mutation != null && (child = this.findChild(block.children, "ELSE")) != null) {
            response = this.callBlock(ruleContext, child.block);
            blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "else {" + "\r\n";
            blockString = String.valueOf(blockString) + response;
            blockString = String.valueOf(blockString) + this.startLine(ruleContext.level) + "}" + "\r\n";
        }
        return blockString;
    }
}

