/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.designer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import io.swagger.annotations.Api;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.openhab.ui.habmin.HABminConstants;
import org.openhab.ui.habmin.internal.services.designer.DesignerBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerBlockBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerChildBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerCommentBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerFieldBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerListBean;
import org.openhab.ui.habmin.internal.services.designer.DesignerMutationBean;
import org.openhab.ui.habmin.internal.services.designer.blocks.DesignerRuleCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="habmin/designer")
@Api(value="habmin-designer")
public class DesignerResource
implements RESTResource {
    private static final Logger logger = LoggerFactory.getLogger(DesignerResource.class);
    protected static final String DESIGN_FILE = "designer.xml";
    public static final String PATH = "habmin/designer";
    public static final String API = "habmin-designer";
    @Context
    UriInfo uriInfo;
    private static ItemRegistry itemRegistry;

    public void setItemRegistry(ItemRegistry itemRegistry) {
        DesignerResource.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        DesignerResource.itemRegistry = null;
    }

    public static ItemRegistry getItemRegistry() {
        return itemRegistry;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDesigns(@Context HttpHeaders headers) {
        logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        DesignerListBean responseObject = this.getDesignBeans();
        return Response.ok((Object)responseObject).build();
    }

    @GET
    @Path(value="/{designref: [0-9]*}")
    @Produces(value={"application/json"})
    public Response getDesignRef(@Context HttpHeaders headers, @PathParam(value="designref") Integer designref) {
        logger.debug("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
        DesignerBean responseObject = this.getDesignBean(designref);
        return Response.ok((Object)responseObject).build();
    }

    @DELETE
    @Path(value="/{designref: [0-9]*}")
    @Produces(value={"application/json"})
    public Response deleteDesignRef(@Context HttpHeaders headers, @PathParam(value="designref") Integer designref) {
        logger.debug("Received HTTP DELETE request at '{}'.", (Object)this.uriInfo.getPath());
        DesignerListBean responseObject = this.deleteDesignBean(designref);
        return Response.ok((Object)responseObject).build();
    }

    @PUT
    @Path(value="/{designref: [0-9]*}")
    @Produces(value={"application/json"})
    public Response putDesignRef(@Context HttpHeaders headers, @PathParam(value="designref") Integer designref, DesignerBean updatedDesign) {
        logger.debug("Received HTTP PUT request at '{}'.", (Object)this.uriInfo.getPath());
        DesignerBean responseObject = this.putDesignBean(designref, updatedDesign);
        return Response.ok((Object)responseObject).build();
    }

    @POST
    @Produces(value={"application/json"})
    public Response postDesignRef(@Context HttpHeaders headers, DesignerBean updatedDesign) {
        logger.debug("Received HTTP POST request at '{}'", (Object)this.uriInfo.getPath());
        DesignerBean responseObject = this.putDesignBean(0, updatedDesign);
        return Response.ok((Object)responseObject).build();
    }

    private DesignerListBean getDesignBeans() {
        DesignerListBean designs = this.loadDesigns();
        DesignerListBean newList = new DesignerListBean();
        for (DesignerBean i : designs.designs) {
            DesignerBean newDesign = new DesignerBean();
            newDesign.id = i.id;
            newDesign.name = i.name;
            newList.designs.add(newDesign);
        }
        return newList;
    }

    private DesignerBean getDesignBean(Integer designRef) {
        DesignerListBean designs = this.loadDesigns();
        for (DesignerBean i : designs.designs) {
            if (i.id.intValue() != designRef.intValue()) continue;
            i.source = DesignerRuleCreator.loadSource(i.id, i.name);
            return i;
        }
        return null;
    }

    private DesignerListBean deleteDesignBean(Integer designRef) {
        DesignerListBean designs = this.loadDesigns();
        DesignerBean foundDesign = null;
        for (DesignerBean i : designs.designs) {
            if (i.id.intValue() != designRef.intValue()) continue;
            foundDesign = i;
        }
        if (foundDesign != null) {
            designs.designs.remove(foundDesign);
        }
        this.saveDesigns(designs);
        return this.getDesignBeans();
    }

    private DesignerListBean loadDesigns() {
        DesignerListBean designs = null;
        logger.debug("Loading Designs.");
        try {
            long timerStart = System.currentTimeMillis();
            FileInputStream fin = new FileInputStream(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/" + DESIGN_FILE);
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xstream.alias("designlist", DesignerListBean.class);
            xstream.alias("field", DesignerFieldBean.class);
            xstream.alias("mutation", DesignerMutationBean.class);
            xstream.alias("child", DesignerChildBean.class);
            xstream.processAnnotations(DesignerListBean.class);
            xstream.processAnnotations(DesignerMutationBean.class);
            xstream.processAnnotations(DesignerBean.class);
            xstream.processAnnotations(DesignerBlockBean.class);
            xstream.processAnnotations(DesignerChildBean.class);
            xstream.processAnnotations(DesignerCommentBean.class);
            xstream.processAnnotations(DesignerFieldBean.class);
            designs = (DesignerListBean)xstream.fromXML((InputStream)fin);
            fin.close();
            long timerStop = System.currentTimeMillis();
            logger.debug("Designs loaded in {}ms.", (Object)(timerStop - timerStart));
        }
        catch (FileNotFoundException e) {
            designs = new DesignerListBean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (designs.designs == null) {
            designs.designs = new ArrayList<DesignerBean>();
        }
        return designs;
    }

    private DesignerBean putDesignBean(Integer designRef, DesignerBean bean) {
        if (designRef != 0 && bean.id != null && bean.id.intValue() != designRef.intValue()) {
            logger.error("Inconsistent id in HTTP call '{}' and structure '{}'", (Object)designRef, (Object)bean.id);
            return null;
        }
        DesignerListBean list = this.loadDesigns();
        int high = 0;
        DesignerBean foundDesign = null;
        for (DesignerBean i : list.designs) {
            if (i.id > high) {
                high = i.id;
            }
            if (i.id.intValue() != designRef.intValue()) continue;
            foundDesign = i;
        }
        if (foundDesign != null) {
            list.designs.remove(foundDesign);
        }
        if (bean.id == null) {
            bean.id = high + 1;
        }
        if (bean.name == null) {
            bean.name = "";
        }
        list.designs.add(bean);
        this.saveDesigns(list);
        bean.source = DesignerRuleCreator.saveRule(bean.id, bean.name, bean.block);
        return bean;
    }

    private boolean saveDesigns(DesignerListBean designs) {
        File folder = new File(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/");
        if (!folder.exists()) {
            logger.debug("Creating directory {}", (Object)HABminConstants.getDataDirectory());
            folder.mkdirs();
        }
        try {
            long timerStart = System.currentTimeMillis();
            FileOutputStream fout = new FileOutputStream(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/" + DESIGN_FILE);
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xstream.alias("designlist", DesignerListBean.class);
            xstream.alias("field", DesignerFieldBean.class);
            xstream.alias("mutation", DesignerMutationBean.class);
            xstream.alias("child", DesignerChildBean.class);
            xstream.processAnnotations(DesignerListBean.class);
            xstream.processAnnotations(DesignerMutationBean.class);
            xstream.processAnnotations(DesignerBean.class);
            xstream.processAnnotations(DesignerBlockBean.class);
            xstream.processAnnotations(DesignerChildBean.class);
            xstream.processAnnotations(DesignerCommentBean.class);
            xstream.processAnnotations(DesignerFieldBean.class);
            xstream.toXML((Object)designs, (OutputStream)fout);
            fout.close();
            long timerStop = System.currentTimeMillis();
            logger.debug("Designs saved in {}ms.", (Object)(timerStop - timerStart));
        }
        catch (FileNotFoundException e) {
            logger.debug("Unable to open Designs for SAVE - ", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.debug("Unable to write Designs for SAVE - ", (Throwable)e);
            return false;
        }
        return true;
    }
}

