/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.dashboard;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import io.swagger.annotations.Api;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.openhab.ui.habmin.HABminConstants;
import org.openhab.ui.habmin.internal.services.dashboard.DashboardConfigBean;
import org.openhab.ui.habmin.internal.services.dashboard.DashboardListBean;
import org.openhab.ui.habmin.internal.services.dashboard.DashboardWidgetBean;
import org.openhab.ui.habmin.internal.services.dashboard.DashboardWidgetOptionsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="habmin/dashboards")
@Api(value="habmin-dashboards")
public class DashboardResource
implements RESTResource {
    private static String DASHBOARD_FILE = "dashboards.xml";
    private static final Logger logger = LoggerFactory.getLogger(DashboardResource.class);
    public static final String PATH = "habmin/dashboards";
    public static final String API = "habmin-dashboards";
    @Context
    UriInfo uriInfo;

    @GET
    @Produces(value={"application/json"})
    public Response httpGetDashboards(@Context HttpHeaders headers) {
        logger.trace("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
        List<DashboardConfigBean> responseObject = this.getDashboardList();
        return Response.ok(responseObject).build();
    }

    @POST
    @Produces(value={"application/json"})
    public Response httpPostDashboards(@Context HttpHeaders headers, DashboardConfigBean dashboard) {
        logger.trace("Received HTTP POST request at '{}'.", (Object)this.uriInfo.getPath());
        DashboardConfigBean responseObject = this.putDashboardBean(0, dashboard);
        return Response.ok((Object)responseObject).build();
    }

    @PUT
    @Path(value="/{dashboardId: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    public Response httpPutDashboards(@Context HttpHeaders headers, @PathParam(value="dashboardId") Integer dashboardId, DashboardConfigBean dashboard) {
        logger.trace("Received HTTP PUT request at '{}'.", (Object)this.uriInfo.getPath());
        DashboardConfigBean responseObject = this.putDashboardBean(dashboardId, dashboard);
        return Response.ok((Object)responseObject).build();
    }

    @DELETE
    @Path(value="/{dashboardId: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    public Response httpDeleteDashboards(@Context HttpHeaders headers, @QueryParam(value="type") String type, @PathParam(value="dashboardId") Integer dashboardId) {
        logger.trace("Received HTTP DELETE request at '{}'.", (Object)this.uriInfo.getPath());
        List<DashboardConfigBean> responseObject = this.deleteDashboard(dashboardId);
        return Response.ok(responseObject).build();
    }

    @GET
    @Path(value="/{dashboardId: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    public Response httpGetDashboards(@Context HttpHeaders headers, @PathParam(value="dashboardId") Integer dashboardId) {
        logger.trace("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
        DashboardConfigBean responseObject = this.getDashboard(dashboardId);
        return Response.ok((Object)responseObject).build();
    }

    private DashboardConfigBean putDashboardBean(Integer dashboardRef, DashboardConfigBean bean) {
        bean.id = dashboardRef == 0 ? null : dashboardRef;
        DashboardListBean list = this.loadDashboards();
        int high = 0;
        DashboardConfigBean foundDashboard = null;
        for (DashboardConfigBean i : list.entries) {
            if (i.id > high) {
                high = i.id;
            }
            if (i.id.intValue() != dashboardRef.intValue()) continue;
            foundDashboard = i;
        }
        if (foundDashboard != null) {
            list.entries.remove(foundDashboard);
        }
        if (bean.id == null) {
            bean.id = high + 1;
        }
        list.entries.add(bean);
        this.saveDashboards(list);
        return bean;
    }

    private List<DashboardConfigBean> getDashboardList() {
        DashboardListBean dashboards = this.loadDashboards();
        ArrayList<DashboardConfigBean> list = new ArrayList<DashboardConfigBean>();
        for (DashboardConfigBean i : dashboards.entries) {
            DashboardConfigBean newDashboard = new DashboardConfigBean();
            newDashboard.id = i.id;
            newDashboard.name = i.name;
            newDashboard.category = i.category;
            newDashboard.menu = i.menu;
            list.add(newDashboard);
        }
        return list;
    }

    private DashboardConfigBean getDashboard(Integer dashboardRef) {
        DashboardListBean dashboards = this.loadDashboards();
        for (DashboardConfigBean i : dashboards.entries) {
            if (i.id.intValue() != dashboardRef.intValue()) continue;
            return i;
        }
        return null;
    }

    private List<DashboardConfigBean> deleteDashboard(Integer dashboardRef) {
        DashboardListBean dashboards = this.loadDashboards();
        DashboardConfigBean foundDashboard = null;
        for (DashboardConfigBean i : dashboards.entries) {
            if (i.id.intValue() != dashboardRef.intValue()) continue;
            foundDashboard = i;
            break;
        }
        if (foundDashboard != null) {
            dashboards.entries.remove(foundDashboard);
        }
        this.saveDashboards(dashboards);
        return this.getDashboardList();
    }

    private XStream getXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.alias("dashboards", DashboardListBean.class);
        xstream.alias("dashboard", DashboardConfigBean.class);
        xstream.alias("widgets", DashboardWidgetBean.class);
        xstream.alias("options", DashboardWidgetOptionsBean.class);
        xstream.processAnnotations(DashboardListBean.class);
        return xstream;
    }

    private boolean saveDashboards(DashboardListBean dashboard) {
        File folder = new File(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/");
        if (!folder.exists()) {
            logger.debug("Creating directory {}", (Object)HABminConstants.getDataDirectory());
            folder.mkdirs();
        }
        try {
            long timerStart = System.currentTimeMillis();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/" + DASHBOARD_FILE), "UTF-8"));
            XStream xstream = this.getXStream();
            xstream.toXML((Object)dashboard, (Writer)out);
            out.close();
            long timerStop = System.currentTimeMillis();
            logger.debug("Dashboard list saved in {}ms.", (Object)(timerStop - timerStart));
        }
        catch (FileNotFoundException e) {
            logger.debug("Unable to open Dashboards list for SAVE - ", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.debug("Unable to write Dashboards list for SAVE - ", (Throwable)e);
            return false;
        }
        return true;
    }

    private DashboardListBean loadDashboards() {
        DashboardListBean dashboards = null;
        try {
            long timerStart = System.currentTimeMillis();
            FileInputStream fin = new FileInputStream(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/" + DASHBOARD_FILE);
            XStream xstream = this.getXStream();
            dashboards = (DashboardListBean)xstream.fromXML((InputStream)fin);
            fin.close();
            long timerStop = System.currentTimeMillis();
            logger.debug("Dashboards loaded in {}ms.", (Object)(timerStop - timerStart));
        }
        catch (FileNotFoundException e) {
            dashboards = new DashboardListBean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dashboards;
    }
}

