/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habmin.internal.services.chart;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.openhab.ui.habmin.HABminConstants;
import org.openhab.ui.habmin.internal.services.chart.ChartAxisConfigBean;
import org.openhab.ui.habmin.internal.services.chart.ChartConfigBean;
import org.openhab.ui.habmin.internal.services.chart.ChartItemConfigBean;
import org.openhab.ui.habmin.internal.services.chart.ChartListBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="habmin/charts")
@Api(value="habmin-charts")
public class ChartResource
implements RESTResource {
    private static String CHART_FILE = "charts.xml";
    private static final Logger logger = LoggerFactory.getLogger(ChartResource.class);
    public static final String PATH = "habmin/charts";
    public static final String API = "habmin-charts";
    @Context
    UriInfo uriInfo;
    private static ItemUIRegistry itemUIRegistry;

    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        ChartResource.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemRegistry itemUIRegistry) {
        ChartResource.itemUIRegistry = null;
    }

    public static ItemUIRegistry getItemUIRegistry() {
        return itemUIRegistry;
    }

    @GET
    @Produces(value={"application/json"})
    public Response httpGetCharts(@Context HttpHeaders headers) {
        logger.trace("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
        List<ChartConfigBean> responseObject = this.getChartList();
        return Response.ok(responseObject).build();
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates a new chart.", response=ChartConfigBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response httpPostCharts(@Context HttpHeaders headers, ChartConfigBean chart) {
        logger.trace("Received HTTP POST request at '{}'.", (Object)this.uriInfo.getPath());
        ChartConfigBean responseObject = this.putChartBean(0, chart);
        return Response.ok((Object)responseObject).build();
    }

    @PUT
    @Path(value="/{chartId: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    public Response httpPutCharts(@Context HttpHeaders headers, @PathParam(value="chartId") Integer chartId, ChartConfigBean chart) {
        logger.trace("Received HTTP PUT request at '{}'.", (Object)this.uriInfo.getPath());
        ChartConfigBean responseObject = this.putChartBean(chartId, chart);
        return Response.ok((Object)responseObject).build();
    }

    @DELETE
    @Path(value="/{chartId: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    public Response httpDeleteCharts(@Context HttpHeaders headers, @QueryParam(value="type") String type, @PathParam(value="chartId") Integer chartId) {
        logger.trace("Received HTTP DELETE request at '{}'.", (Object)this.uriInfo.getPath());
        List<ChartConfigBean> responseObject = this.deleteChart(chartId);
        return Response.ok(responseObject).build();
    }

    @GET
    @Path(value="/{chartId: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    public Response httpGetCharts(@Context HttpHeaders headers, @PathParam(value="chartId") Integer chartId) {
        logger.trace("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
        ChartConfigBean responseObject = this.getChart(chartId);
        return Response.ok((Object)responseObject).build();
    }

    public static Item getItem(String itemname) {
        ItemUIRegistry registry = ChartResource.getItemUIRegistry();
        if (registry != null) {
            try {
                Item item = registry.getItem(itemname);
                return item;
            }
            catch (ItemNotFoundException e) {
                logger.debug(e.getMessage());
            }
        }
        return null;
    }

    private ChartConfigBean putChartBean(Integer chartRef, ChartConfigBean bean) {
        bean.id = chartRef == 0 ? null : chartRef;
        ChartListBean list = this.loadCharts();
        int high = 0;
        ChartConfigBean foundChart = null;
        for (ChartConfigBean i : list.entries) {
            if (i.id > high) {
                high = i.id;
            }
            if (i.id.intValue() != chartRef.intValue()) continue;
            foundChart = i;
        }
        if (foundChart != null) {
            list.entries.remove(foundChart);
        }
        if (bean.id == null) {
            bean.id = high + 1;
        }
        list.entries.add(bean);
        this.saveCharts(list);
        return bean;
    }

    private List<ChartConfigBean> getChartList() {
        ChartListBean charts = this.loadCharts();
        ArrayList<ChartConfigBean> list = new ArrayList<ChartConfigBean>();
        for (ChartConfigBean i : charts.entries) {
            ChartConfigBean newChart = new ChartConfigBean();
            newChart.id = i.id;
            newChart.name = i.name;
            newChart.icon = i.icon;
            list.add(newChart);
        }
        return list;
    }

    private ChartConfigBean getChart(Integer chartRef) {
        ChartListBean charts = this.loadCharts();
        for (ChartConfigBean i : charts.entries) {
            if (i.id.intValue() != chartRef.intValue()) continue;
            return i;
        }
        return null;
    }

    private List<ChartConfigBean> deleteChart(Integer chartRef) {
        ChartListBean charts = this.loadCharts();
        ChartConfigBean foundChart = null;
        for (ChartConfigBean i : charts.entries) {
            if (i.id.intValue() != chartRef.intValue()) continue;
            foundChart = i;
            break;
        }
        if (foundChart != null) {
            charts.entries.remove(foundChart);
        }
        this.saveCharts(charts);
        return this.getChartList();
    }

    private boolean saveCharts(ChartListBean chart) {
        File folder = new File(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/");
        if (!folder.exists()) {
            logger.debug("Creating directory {}", (Object)HABminConstants.getDataDirectory());
            folder.mkdirs();
        }
        try {
            long timerStart = System.currentTimeMillis();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/" + CHART_FILE), "UTF-8"));
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xstream.alias("charts", ChartListBean.class);
            xstream.alias("chart", ChartConfigBean.class);
            xstream.alias("item", ChartItemConfigBean.class);
            xstream.alias("axis", ChartAxisConfigBean.class);
            xstream.processAnnotations(ChartListBean.class);
            xstream.toXML((Object)chart, (Writer)out);
            out.close();
            long timerStop = System.currentTimeMillis();
            logger.debug("Chart list saved in {}ms.", (Object)(timerStop - timerStart));
        }
        catch (FileNotFoundException e) {
            logger.debug("Unable to open Chart list for SAVE - ", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.debug("Unable to write Chart list for SAVE - ", (Throwable)e);
            return false;
        }
        return true;
    }

    private ChartListBean loadCharts() {
        ChartListBean charts = null;
        try {
            long timerStart = System.currentTimeMillis();
            FileInputStream fin = new FileInputStream(String.valueOf(ConfigConstants.getUserDataFolder()) + "/" + "/habmin/" + CHART_FILE);
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xstream.alias("charts", ChartListBean.class);
            xstream.alias("chart", ChartConfigBean.class);
            xstream.alias("item", ChartItemConfigBean.class);
            xstream.alias("axis", ChartAxisConfigBean.class);
            xstream.processAnnotations(ChartListBean.class);
            charts = (ChartListBean)xstream.fromXML((InputStream)fin);
            fin.close();
            long timerStop = System.currentTimeMillis();
            logger.debug("Charts loaded in {}ms.", (Object)(timerStop - timerStart));
        }
        catch (FileNotFoundException e) {
            charts = new ChartListBean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return charts;
    }
}

