/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.classic.internal.servlet;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.library.items.SwitchItem;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.io.http.HttpContextFactoryService;
import org.openhab.ui.classic.internal.servlet.BaseServlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={})
public class CmdServlet
extends BaseServlet {
    private static final long serialVersionUID = 5627895645086890496L;
    private final Logger logger = LoggerFactory.getLogger(CmdServlet.class);
    public static final String SERVLET_NAME = "CMD";
    private EventPublisher eventPublisher;

    @Reference(policy=ReferencePolicy.DYNAMIC)
    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate("/classicui/CMD", bundleContext);
    }

    @Deactivate
    protected void deactivate() {
        this.httpService.unregister("/classicui/CMD");
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/plain");
        for (Object key : req.getParameterMap().keySet()) {
            String itemName = key.toString();
            if (itemName.startsWith("__")) continue;
            String commandName = req.getParameter(itemName);
            try {
                Command command;
                Item item = this.itemRegistry.getItem(itemName);
                if ((item instanceof SwitchItem || item instanceof GroupItem) && commandName.equals("TOGGLE")) {
                    String string = commandName = OnOffType.ON.equals((Object)item.getStateAs(OnOffType.class)) ? "OFF" : "ON";
                }
                if ((command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)commandName)) != null) {
                    this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)itemName, (Command)command));
                    continue;
                }
                this.logger.warn("Received unknown command '{}' for item '{}'", (Object)commandName, (Object)itemName);
            }
            catch (ItemNotFoundException e) {
                this.logger.warn("Received command '{}' for item '{}', but the item does not exist in the registry", (Object)commandName, (Object)itemName);
            }
        }
    }

    @Override
    @Reference
    public void setItemRegistry(ItemRegistry ItemRegistry2) {
        super.setItemRegistry(ItemRegistry2);
    }

    @Override
    public void unsetItemRegistry(ItemRegistry ItemRegistry2) {
        super.unsetItemRegistry(ItemRegistry2);
    }

    @Reference
    public void setHttpService(HttpService HttpService2) {
        super.setHttpService(HttpService2);
    }

    public void unsetHttpService(HttpService HttpService2) {
        super.unsetHttpService(HttpService2);
    }

    @Reference
    public void setHttpContextFactoryService(HttpContextFactoryService HttpContextFactoryService2) {
        super.setHttpContextFactoryService(HttpContextFactoryService2);
    }

    public void unsetHttpContextFactoryService(HttpContextFactoryService HttpContextFactoryService2) {
        super.unsetHttpContextFactoryService(HttpContextFactoryService2);
    }
}

