/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.classic.internal.render;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.eclipse.smarthome.model.sitemap.sitemap.Mapping;
import org.eclipse.smarthome.model.sitemap.sitemap.Selection;
import org.eclipse.smarthome.model.sitemap.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.openhab.ui.classic.internal.render.AbstractWidgetRenderer;
import org.openhab.ui.classic.internal.render.RenderException;
import org.openhab.ui.classic.internal.render.WidgetRenderer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WidgetRenderer.class})
public class SelectionRenderer
extends AbstractWidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(SelectionRenderer.class);

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Selection;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        String snippet = this.getSnippet("selection");
        snippet = StringUtils.replace((String)snippet, (String)"%category%", (String)this.getCategory(w));
        snippet = StringUtils.replace((String)snippet, (String)"%state%", (String)this.getState(w));
        snippet = StringUtils.replace((String)snippet, (String)"%format%", (String)this.getFormat());
        State state = this.itemUIRegistry.getState(w);
        Selection selection = (Selection)w;
        String mappedValue = "";
        Item item = null;
        try {
            item = this.itemUIRegistry.getItem(w.getItem());
        }
        catch (ItemNotFoundException e) {
            this.logger.debug("Failed to retrieve item during widget rendering: {}", (Object)e.getMessage());
        }
        StringBuilder rowSB = new StringBuilder();
        if (selection.getMappings().size() == 0 && item != null) {
            StateDescription stateDescription = item.getStateDescription();
            if (stateDescription != null) {
                for (StateOption option : stateDescription.getOptions()) {
                    String rowMappedValue = this.buildRow(selection, option.getLabel(), option.getValue(), item, state, rowSB);
                    if (rowMappedValue == null) continue;
                    mappedValue = rowMappedValue;
                }
            }
        } else {
            for (Mapping mapping : selection.getMappings()) {
                String rowMappedValue = this.buildRow(selection, mapping.getLabel(), mapping.getCmd(), item, state, rowSB);
                if (rowMappedValue == null) continue;
                mappedValue = rowMappedValue;
            }
        }
        snippet = StringUtils.replace((String)snippet, (String)"%label_header%", (String)this.getLabel(w, mappedValue));
        snippet = StringUtils.replace((String)snippet, (String)"%rows%", (String)rowSB.toString());
        snippet = this.processColor(w, snippet);
        sb.append(snippet);
        return null;
    }

    private String buildRow(Selection w, String lab, String cmd, Item item, State state, StringBuilder rowSB) throws RenderException {
        String mappedValue = null;
        String rowSnippet = this.getSnippet("selection_row");
        String command = cmd != null ? cmd : "";
        String label = lab;
        if (item instanceof NumberItem && ((NumberItem)item).getDimension() != null) {
            String unit = this.getUnitForWidget((Widget)w);
            command = StringUtils.replace((String)command, (String)"%unit%", (String)unit);
            label = StringUtils.replace((String)label, (String)"%unit%", (String)unit);
        }
        rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%item%", (String)(w.getItem() != null ? w.getItem() : ""));
        rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%cmd%", (String)StringEscapeUtils.escapeHtml((String)command));
        rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%label%", (String)(label != null ? StringEscapeUtils.escapeHtml((String)label) : ""));
        State compareMappingState = state;
        if (state instanceof QuantityType) {
            compareMappingState = this.convertStateToLabelUnit((QuantityType)state, command);
        }
        if (compareMappingState.toString().equals(command)) {
            mappedValue = label;
            rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%checked%", (String)"checked=\"true\"");
        } else {
            rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%checked%", (String)"");
        }
        rowSB.append(rowSnippet);
        return mappedValue;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

