/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.classic.internal.render;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.model.sitemap.sitemap.Chart;
import org.eclipse.smarthome.model.sitemap.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.openhab.ui.classic.internal.render.AbstractWidgetRenderer;
import org.openhab.ui.classic.internal.render.RenderException;
import org.openhab.ui.classic.internal.render.WidgetRenderer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WidgetRenderer.class})
public class ChartRenderer
extends AbstractWidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(ChartRenderer.class);

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Chart;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Chart chart = (Chart)w;
        try {
            String itemParam = null;
            Item item = this.itemUIRegistry.getItem(chart.getItem());
            itemParam = item instanceof GroupItem ? "groups=" + chart.getItem() : "items=" + chart.getItem();
            String url = "/chart?" + itemParam + "&period=" + chart.getPeriod() + "&t=" + new Date().getTime();
            if (chart.getService() != null) {
                url = String.valueOf(url) + "&service=" + chart.getService();
            }
            if (chart.getLegend() != null) {
                url = chart.getLegend() != false ? String.valueOf(url) + "&legend=true" : String.valueOf(url) + "&legend=false";
            }
            String snippet = this.getSnippet("image");
            snippet = chart.getRefresh() > 0 ? StringUtils.replace((String)snippet, (String)"%refresh%", (String)("id=\"%id%\" data-timeout=\"" + chart.getRefresh() + "\" onload=\"startReloadImage('%url%', '%id%')\"")) : StringUtils.replace((String)snippet, (String)"%refresh%", (String)"");
            snippet = StringUtils.replace((String)snippet, (String)"%id%", (String)this.itemUIRegistry.getWidgetId(w));
            snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)url);
            sb.append(snippet);
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Chart cannot be rendered as item '{}' does not exist.", (Object)chart.getItem());
        }
        return null;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

