/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.classic.internal.render;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.openhab.ui.classic.internal.WebAppActivator;
import org.openhab.ui.classic.internal.WebAppConfig;
import org.openhab.ui.classic.internal.render.RenderException;
import org.openhab.ui.classic.internal.render.WidgetRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWidgetRenderer
implements WidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(AbstractWidgetRenderer.class);
    private static final String ICON_TYPE = "svg";
    protected WebAppConfig config;
    protected ItemUIRegistry itemUIRegistry;
    protected static final String SNIPPET_EXT = ".html";
    protected static final String SNIPPET_LOCATION = "snippets/";
    protected static final Map<String, String> SNIPPET_CACHE = new HashMap<String, String>();

    protected void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    protected void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    public ItemUIRegistry getItemUIRegistry() {
        return this.itemUIRegistry;
    }

    protected synchronized String getSnippet(String elementType) throws RenderException {
        String lowerCaseElementType = elementType.toLowerCase();
        String snippet = SNIPPET_CACHE.get(lowerCaseElementType);
        if (snippet == null) {
            String snippetLocation = SNIPPET_LOCATION + lowerCaseElementType + SNIPPET_EXT;
            URL entry = WebAppActivator.getContext().getBundle().getEntry(snippetLocation);
            if (entry != null) {
                try {
                    snippet = IOUtils.toString((InputStream)entry.openStream());
                    if (!this.config.isHtmlCacheDisabled()) {
                        SNIPPET_CACHE.put(lowerCaseElementType, snippet);
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Cannot load snippet for element type '{}'", (Object)lowerCaseElementType, (Object)e);
                }
            } else {
                throw new RenderException("Cannot find a snippet for element type '" + lowerCaseElementType + "'");
            }
        }
        return snippet;
    }

    public String getLabel(Widget w) {
        return this.getLabel(w, null);
    }

    public String getLabel(Widget w, String preferredValue) {
        String label = this.itemUIRegistry.getLabel(w);
        int index = label.indexOf(91);
        int index2 = label.lastIndexOf(93);
        label = index != -1 && index2 != -1 ? this.formatLabel(label.substring(0, index).trim(), preferredValue == null ? label.substring(index + 1, index2) : preferredValue) : this.formatLabel(label, null);
        return label;
    }

    private String formatLabel(String left, String right) {
        String label = "<span style=\"%labelstyle%\" class=\"iLabel\">" + StringEscapeUtils.escapeHtml((String)left) + "</span>";
        if (right != null) {
            label = String.valueOf(label) + "<span class=\"iValue\" style=\"%valuestyle%\">" + StringEscapeUtils.escapeHtml((String)right) + "</span>";
        }
        return label;
    }

    protected String escapeURLPath(String path) {
        try {
            return URLEncoder.encode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException use) {
            this.logger.warn("Cannot escape string '{}'. Returning unmodified string.", (Object)path);
            return path;
        }
    }

    protected String processColor(Widget w, String snippet) {
        String style = "";
        String color = this.itemUIRegistry.getLabelColor(w);
        if (color != null) {
            style = "color:" + color;
        }
        String ret = StringUtils.replace((String)snippet, (String)"%labelstyle%", (String)style);
        style = "";
        color = this.itemUIRegistry.getValueColor(w);
        if (color != null) {
            style = "color:" + color;
        }
        ret = StringUtils.replace((String)ret, (String)"%valuestyle%", (String)style);
        return ret;
    }

    protected String getFormat() {
        return ICON_TYPE;
    }

    protected String getState(Widget w) {
        State state = this.itemUIRegistry.getState(w);
        if (state != null) {
            return this.escapeURLPath(state.toString());
        }
        return "NULL";
    }

    protected String getStateAsNumber(Widget w) {
        String itemName = w.getItem();
        if (itemName != null) {
            try {
                Item item = this.itemUIRegistry.getItem(itemName);
                State state = item.getState();
                state = item.getAcceptedDataTypes().contains(PercentType.class) ? item.getStateAs(PercentType.class) : item.getStateAs(DecimalType.class);
                if (state != null) {
                    return this.escapeURLPath(state.toString());
                }
                this.logger.debug("State '{}' of item '{}' is not a number!", (Object)item.getState(), (Object)itemName);
            }
            catch (ItemNotFoundException e) {
                this.logger.error("Cannot retrieve item '{}' for widget {}", new Object[]{itemName, w.eClass().getInstanceTypeName()});
            }
        }
        return "NULL";
    }

    protected String getCategory(Widget w) {
        String icon = this.escapeURLPath(this.itemUIRegistry.getCategory(w));
        return icon;
    }

    @Override
    public void setConfig(WebAppConfig config) {
        this.config = config;
    }

    protected String getUnitForWidget(Widget widget) {
        return this.itemUIRegistry.getUnitForWidget(widget);
    }

    protected State convertStateToLabelUnit(QuantityType<?> state, String label) {
        return this.itemUIRegistry.convertStateToLabelUnit(state, label);
    }

    protected boolean isValidURL(String url) {
        if (url != null && !url.isEmpty()) {
            try {
                return new URL(url).toURI() != null;
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return false;
    }
}

