/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import java.io.File;
import net.rubygrapefruit.platform.file.FileInfo;
import net.rubygrapefruit.platform.file.PosixFiles;
import org.gradle.internal.nativeintegration.filesystem.Symlink;

class NativePlatformBackedSymlink
implements Symlink {
    private final PosixFiles posixFiles;

    public NativePlatformBackedSymlink(PosixFiles posixFiles) {
        this.posixFiles = posixFiles;
    }

    @Override
    public boolean isSymlinkSupported() {
        return true;
    }

    @Override
    public void symlink(File link, File target) {
        link.getParentFile().mkdirs();
        this.posixFiles.symlink(link, target.getPath());
    }

    @Override
    public boolean isSymlink(File suspect) {
        return this.posixFiles.stat(suspect).getType() == FileInfo.Type.Symlink;
    }
}

