/*
** $Id: sockswrap.c,v 1.1 2004/07/17 03:57:03 mrsam Exp $
**
** Copyright 2004 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include "courier_socks_config.h"
#include "socks.h"

/*
** libsockswrap intercepts the system functions by forwarding them to
** the socksing version in libsocks
*/

int connect(int fd, const struct sockaddr *addr, SOCKLEN_T addrlen)
{
	return Rconnect(fd, addr, addrlen);
}

int bind(int fd, const struct sockaddr *addr, SOCKLEN_T addrlen)
{
	return Rbind(fd, addr, addrlen);
}

int close(int fd)
{
	return Rclose(fd);
}

int fclose(FILE *fp)
{
	return Rfclose(fp);
}

int select(int n, fd_set *r, fd_set *w, fd_set *e,
	   struct timeval *tv)
{
	return Rselect(n, r, w, e, tv);
}

int poll(struct pollfd *ufds, NFDS_T nfds, int timeout)
{
	return Rpoll(ufds, nfds, timeout);
}

int listen(int s, int backlog)
{
	return Rlisten(s, backlog);
}

int dup(int fd)
{
	return Rdup(fd);
}

int dup2(int fd, int fdNew)
{
	return Rdup2(fd, fdNew);
}

int accept(int s, struct sockaddr *addr, SOCKLEN_T *addrlen)
{
	return Raccept(s, addr, addrlen);
}

int getsockopt(int  s, int level, int optname, void *optval,
	       SOCKLEN_T *optlen)
{
	return Rgetsockopt(s, level, optname, optval, optlen);
}

int getsockname(int s, struct sockaddr *name, SOCKLEN_T *namelen)
{
	return Rgetsockname(s, name, namelen);
}

int getpeername(int s, struct sockaddr *name, SOCKLEN_T *namelen)
{
	return Rgetpeername(s, name, namelen);
}

