/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ShadowBorder
implements Border {
    private static Insets INSETS_FULL = new Insets(3, 2, 5, 5);
    private static Insets INSETS_HALF = new Insets(1, 1, 5, 5);
    private static Image shadowImage = new ImageIcon(ShadowBorder.class.getResource("shadow.png")).getImage();
    static int shadowW = shadowImage.getWidth(null);
    static int shadowH = shadowImage.getHeight(null);
    private Color highlight = UIManager.getColor("controlLtHighlight");
    private Color shadow = UIManager.getColor("controlShadow");
    private boolean paintTopLeft = true;
    private Insets insets;

    public ShadowBorder() {
        this(true);
    }

    public ShadowBorder(boolean paintTopLeft) {
        this.paintTopLeft = paintTopLeft;
        this.insets = paintTopLeft ? INSETS_FULL : INSETS_HALF;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component component, Graphics graphics, int x, int y, int w, int h) {
        graphics.drawImage(shadowImage, x + w - 5, y, x + w, y + 5, shadowW - 5, 0, shadowW, 5, null);
        graphics.drawImage(shadowImage, x + w - 5, y + 5, x + w, y + h - 5, shadowW - 5, 5, shadowW, shadowH - 5, null);
        graphics.drawImage(shadowImage, x + w - 5, y + h - 5, x + w, y + h, shadowW - 5, shadowH - 5, shadowW, shadowH, null);
        graphics.drawImage(shadowImage, x + 5, y + h - 5, x + w - 5, y + h, 5, shadowH - 5, shadowW - 5, shadowH, null);
        graphics.drawImage(shadowImage, x, y + h - 5, x + 5, y + h, 0, shadowH - 5, 5, shadowH, null);
        if (this.paintTopLeft) {
            graphics.setColor(this.highlight);
            graphics.drawRect(x + 1, y + 2, w - 7, 1);
            graphics.drawLine(x + 1, y + 2, x + 1, y + h - 5);
            graphics.setColor(this.shadow);
            graphics.drawRect(x, y + 1, w - 5, h - 6);
        }
    }

    public Insets getBorderInsets(Component component) {
        return this.insets;
    }
}

