/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.omegat.filters2.TranslationException;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.xml.DefaultEntityFilter;
import org.omegat.util.xml.XMLBlock;
import org.omegat.util.xml.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamReader {
    private DefaultEntityFilter entityFilter;
    private boolean cdata_flag = false;
    private boolean end_cdata_flag = false;
    private static final int type_text = 1;
    private static final int type_ws = 2;
    private static final int type_apos = 3;
    private static final int type_quote = 4;
    private static final int type_lt = 5;
    private static final int type_gt = 6;
    private static final int type_amp = 7;
    private static final int type_equals = 8;
    private static final int type_ques = 9;
    private static final int type_opBrac = 10;
    private static final int type_clBrac = 11;
    private static final int type_slash = 12;
    private static final int type_backSlash = 13;
    private static final int type_dash = 14;
    private BufferedReader m_bufferedReader;
    private String m_stringStream = "";
    private XMLBlock m_headBlock = null;
    private int m_pos = -1;
    private Stack<Character> m_charStack = new Stack();
    private List<Character> m_charCache = new ArrayList<Character>();
    private boolean m_killEmptyBlocks = false;
    private boolean m_ignoreWhiteSpace = false;
    private boolean m_breakWhitespace = false;
    private boolean m_compressWhitespace = false;

    public void setStream(File name) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        this.setStream(name, "UTF-8");
    }

    public void setStream(String name, String encoding) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        this.setStream(new File(name), encoding);
    }

    private void setStream(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        XMLReader ear = new XMLReader(file.getAbsolutePath(), encoding);
        this.m_bufferedReader = new BufferedReader(ear);
        this._setStream();
    }

    public void setStream(BufferedReader rdr) throws IOException, TranslationException {
        this.m_bufferedReader = rdr;
        this._setStream();
    }

    private void _setStream() throws IOException, TranslationException {
        this.m_pos = -1;
        XMLBlock blk = this.getNextBlock();
        if (blk == null) {
            throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + OStrings.getString("XSR_ERROR_UNABLE_INIT_READ_XML"));
        }
        if (blk.getTagName().equals("xml")) {
            String ver = blk.getAttribute("version");
            if (ver != null && !ver.equals("") && !ver.equals("1.0")) {
                throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + StaticUtils.format(OStrings.getString("XSR_ERROR_UNSUPPORTED_XML_VERSION"), ver));
            }
        } else {
            throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + OStrings.getString("XSR_ERROR_NONVALID_XML"));
        }
        this.m_headBlock = blk;
    }

    public XMLBlock getNextBlock() throws TranslationException {
        char c = this.getNextChar();
        if (c == '\u0000') {
            return null;
        }
        if (c == '<') {
            c = this.getNextChar();
            this.pushChar(c);
            if (c != ' ') {
                XMLBlock b = this.getNextTag();
                return b;
            }
        } else if (c == ']' && this.end_cdata_flag) {
            XMLBlock b = this.getNextTagCDATAEnd();
            return b;
        }
        this.pushChar(c);
        XMLBlock blk = this.getNextText();
        if (blk != null && this.m_killEmptyBlocks) {
            String str = blk.getText();
            if ((str = str.trim()).length() == 0) {
                blk = this.getNextBlock();
            }
        }
        return blk;
    }

    public void killEmptyBlocks() {
        this.m_killEmptyBlocks = true;
    }

    public void breakOnWhitespace(boolean brk) {
        this.m_breakWhitespace = brk;
    }

    public void compressWhitespace(boolean tof) {
        this.m_compressWhitespace = tof;
    }

    public void setEntityFilter(DefaultEntityFilter filter) {
        this.entityFilter = filter;
    }

    private void pushChar(char c) {
        this.m_charStack.push(new Character(c));
    }

    private char getNextCharCache() {
        char c = this.getNextChar();
        this.m_charCache.add(new Character(c));
        return c;
    }

    private void clearCache() {
        this.m_charCache.clear();
    }

    private void revertToCached() {
        for (int i = this.m_charCache.size() - 1; i >= 0; --i) {
            this.m_charStack.push(this.m_charCache.get(i));
        }
    }

    private char getNextChar() {
        if (!this.m_charStack.empty()) {
            Character ch = this.m_charStack.pop();
            return ch.charValue();
        }
        if (this.m_pos >= 0) {
            if (this.m_pos < this.m_stringStream.length()) {
                int c;
                if ((c = this.m_stringStream.charAt(this.m_pos++)) == 13) {
                    c = this.m_stringStream.charAt(this.m_pos);
                    if (c == 10) {
                        ++this.m_pos;
                    } else {
                        c = 10;
                    }
                }
                return (char)c;
            }
            return '\u0000';
        }
        char[] c = new char[2];
        try {
            char b;
            int res = this.m_bufferedReader.read(c, 0, 1);
            if (res > 0) {
                b = c[0];
                if (b == '\r') {
                    res = this.m_bufferedReader.read(c, 0, 1);
                    if (res > 0) {
                        b = c[0];
                        if (b != '\n' && b == '\r') {
                            this.pushChar('\n');
                        }
                    } else {
                        b = '\u0000';
                    }
                }
            } else {
                return '\u0000';
            }
            return b;
        }
        catch (IOException e) {
            Log.logErrorRB("XSR_ERROR_IOEXCEPTION", new Object[0]);
            Log.log(e);
            return '\u0000';
        }
    }

    private XMLBlock getNextText() throws TranslationException {
        char c;
        XMLBlock blk = new XMLBlock();
        StringBuffer strBuf = new StringBuffer();
        boolean wsCnt = false;
        boolean wsBreak = false;
        while ((c = this.getNextChar()) != '<' && c != '\u0000') {
            if (c == '&') {
                wsCnt = false;
                if (wsBreak) {
                    this.pushChar(c);
                    break;
                }
                char c2 = this.getEscChar();
                if (c2 == '\u0000') {
                    strBuf.append('&');
                    continue;
                }
                strBuf.append(c2);
                continue;
            }
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                if (this.m_ignoreWhiteSpace) continue;
                if (this.m_compressWhitespace) {
                    if (this.m_breakWhitespace) {
                        if (strBuf.length() > 0) {
                            if (wsBreak) continue;
                            this.pushChar(c);
                            break;
                        }
                        wsCnt = true;
                        strBuf.setLength(0);
                        strBuf.append(" ");
                        wsBreak = true;
                        continue;
                    }
                    if (wsCnt) continue;
                    strBuf.append(' ');
                    wsCnt = true;
                    continue;
                }
                strBuf.append(c);
                continue;
            }
            wsCnt = false;
            if (wsBreak) {
                this.pushChar(c);
                break;
            }
            if (c == ']' && this.cdata_flag) {
                char c1 = this.getNextChar();
                char c2 = this.getNextChar();
                this.pushChar(c2);
                this.pushChar(c1);
                if (c1 == ']' && c2 == '>') {
                    this.cdata_flag = false;
                    this.end_cdata_flag = true;
                    this.pushChar(c);
                    break;
                }
            }
            strBuf.append(c);
        }
        if (c == '<') {
            this.pushChar(c);
        }
        blk.setText(strBuf.toString());
        return blk;
    }

    private XMLBlock getNextTagCDATAEnd() {
        this.end_cdata_flag = false;
        XMLBlock blk = new XMLBlock();
        blk.setTypeChar('!');
        blk.setTagName("]]");
        this.getNextChar();
        this.getNextChar();
        return blk;
    }

    private XMLBlock getNextTagExclamation() throws TranslationException {
        char c;
        boolean state_start = true;
        int state_name = 2;
        int state_finish = 3;
        int state_record = 4;
        int state_recordSingle = 5;
        int state_recordDouble = 6;
        int state_escSingle = 7;
        int state_escDouble = 8;
        int state_cdata = 9;
        int state_commentStart = 10;
        int state_comment = 11;
        XMLBlock blk = new XMLBlock();
        blk.setTypeChar('!');
        String name = "";
        String data = "";
        int state = 1;
        boolean err = false;
        String msg = "";
        int dashCnt = 0;
        while ((c = this.getNextChar()) != '\u0000') {
            int type = this.getCharType(c);
            block0 : switch (state) {
                case 1: {
                    switch (type) {
                        case 2: {
                            break block0;
                        }
                        case 1: {
                            state = 2;
                            name = name + c;
                            break block0;
                        }
                        case 10: {
                            blk.setTagName("CDATA");
                            state = 9;
                            break block0;
                        }
                        case 14: {
                            state = 10;
                            blk.setComment();
                            break block0;
                        }
                    }
                    err = true;
                    msg = StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + state);
                    break;
                }
                case 10: {
                    if (c == '-') {
                        state = 11;
                        break;
                    }
                    err = true;
                    msg = OStrings.getString("XSR_ERROR_CONFUSED");
                    break;
                }
                case 11: {
                    switch (type) {
                        case 14: {
                            if (dashCnt >= 2) {
                                data = data + c;
                                break block0;
                            }
                            ++dashCnt;
                            break block0;
                        }
                        case 6: {
                            if (dashCnt < 2) break block0;
                            blk.setText(data);
                            state = 3;
                            break block0;
                        }
                    }
                    if (dashCnt > 0) {
                        while (dashCnt > 0) {
                            data = data + '-';
                            --dashCnt;
                        }
                    }
                    data = data + c;
                    break;
                }
                case 9: {
                    switch (type) {
                        case 10: {
                            state = 3;
                            this.cdata_flag = true;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (type) {
                        case 1: {
                            name = name + c;
                            break block0;
                        }
                        case 2: {
                            blk.setTagName(name);
                            state = 4;
                            break block0;
                        }
                        case 6: {
                            state = 3;
                            break block0;
                        }
                    }
                    err = true;
                    msg = StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + state);
                    break;
                }
                case 4: {
                    switch (type) {
                        case 3: {
                            state = 5;
                            data = data + c;
                            break block0;
                        }
                        case 4: {
                            state = 6;
                            data = data + c;
                            break block0;
                        }
                        case 6: {
                            state = 3;
                            blk.setAttribute(data, "");
                            break block0;
                        }
                    }
                    data = data + c;
                    break;
                }
                case 5: {
                    switch (type) {
                        case 3: {
                            state = 4;
                            data = data + c;
                            break block0;
                        }
                        case 13: {
                            state = 7;
                            data = data + c;
                            break block0;
                        }
                    }
                    data = data + c;
                    break;
                }
                case 7: {
                    data = data + c;
                    state = 5;
                    break;
                }
                case 6: {
                    switch (type) {
                        case 4: {
                            state = 4;
                            data = data + c;
                            break block0;
                        }
                        case 13: {
                            state = 8;
                            data = data + c;
                            break block0;
                        }
                    }
                    data = data + c;
                    break;
                }
                case 8: {
                    data = data + c;
                    state = 6;
                }
            }
            if (err) {
                String str = OStrings.getString("XSR_ERROR_TAG_NAME") + blk.getTagName() + " ";
                if (blk.isComment()) {
                    str = str + OStrings.getString("XSR_ERROR_COMMENT_TAG");
                }
                if (blk.numAttributes() > 0) {
                    str = str + blk.getAttribute((int)0).name;
                }
                throw new TranslationException(msg + str + "::" + data);
            }
            if (state != 3) continue;
            break;
        }
        return blk;
    }

    private void throwErrorInGetNextTag(XMLBlock blk, String msg) throws TranslationException {
        String data = OStrings.getString("XSR_ERROR_TAG_NAME") + blk.getTagName() + " ";
        if (blk.isStandalone()) {
            data = data + OStrings.getString("XSR_ERROR_EMPTY_TAG");
        } else if (blk.isClose()) {
            data = data + OStrings.getString("XSR_ERROR_CLOSE_TAG");
        }
        if (blk.numAttributes() > 0) {
            data = data + OStrings.getString("XSR_ERROR_LOADED") + blk.numAttributes() + OStrings.getString("XSR_ERROR_ATTRIBUTES");
        }
        throw new TranslationException(msg + data);
    }

    private XMLBlock getNextTag() throws TranslationException {
        char c = this.getNextChar();
        if (c == '\u0000') {
            return null;
        }
        if (c == '!') {
            return this.getNextTagExclamation();
        }
        boolean state_start = true;
        int state_buildName = 2;
        int state_setCloseFlag = 3;
        int state_setStandaloneFlag = 4;
        int state_attrStandby = 5;
        int state_buildAttr = 6;
        int state_transitionFromAttr = 7;
        int state_buildValue = 8;
        int state_closeValueQuote = 9;
        int state_finish = 10;
        int state_xmlDeclaration = 11;
        XMLBlock blk = new XMLBlock();
        if (c == '?') {
            c = this.getNextChar();
            blk.setTypeChar('?');
        }
        int state = 1;
        String name = "";
        String attr = "";
        String val = "";
        int buildValueStartType = 0;
        while (c != '\u0000') {
            int type = this.getCharType(c);
            block0 : switch (state) {
                case 1: {
                    switch (type) {
                        case 12: {
                            blk.setCloseFlag();
                            state = 3;
                            break block0;
                        }
                        case 1: {
                            name = name + c;
                            state = 2;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + state));
                    break;
                }
                case 2: {
                    switch (type) {
                        case 1: 
                        case 14: {
                            name = name + c;
                            break block0;
                        }
                        case 2: {
                            state = 5;
                            blk.setTagName(name);
                            break block0;
                        }
                        case 12: {
                            blk.setTagName(name);
                            blk.setStandaloneFlag();
                            state = 4;
                            break block0;
                        }
                        case 6: {
                            blk.setTagName(name);
                            state = 10;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + state));
                    break;
                }
                case 3: {
                    switch (type) {
                        case 1: {
                            name = name + c;
                            state = 2;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + state));
                    break;
                }
                case 4: {
                    switch (type) {
                        case 2: {
                            break block0;
                        }
                        case 6: {
                            state = 10;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + state));
                    break;
                }
                case 5: {
                    switch (type) {
                        case 1: {
                            attr = attr + c;
                            state = 6;
                            break block0;
                        }
                        case 9: {
                            state = 11;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 12: {
                            blk.setStandaloneFlag();
                            state = 4;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + state));
                    break;
                }
                case 11: {
                    if (c != '>') {
                        this.throwErrorInGetNextTag(blk, OStrings.getString("XSR_ERROR_FLOATING_QUESTION_MARK"));
                        break;
                    }
                    state = 10;
                    break;
                }
                case 6: {
                    switch (type) {
                        case 1: 
                        case 14: {
                            attr = attr + c;
                            break block0;
                        }
                        case 8: {
                            state = 7;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + state));
                    break;
                }
                case 7: {
                    switch (type) {
                        case 3: 
                        case 4: {
                            state = 8;
                            buildValueStartType = type;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + state));
                    break;
                }
                case 8: {
                    switch (type) {
                        case 3: 
                        case 4: {
                            if (type == buildValueStartType) {
                                blk.setAttribute(attr, val);
                                attr = "";
                                val = "";
                                state = 9;
                                break block0;
                            }
                            val = val + c;
                            break block0;
                        }
                    }
                    val = val + c;
                    break;
                }
                case 9: {
                    switch (type) {
                        case 1: {
                            attr = attr + c;
                            state = 6;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 12: {
                            blk.setStandaloneFlag();
                            state = 4;
                            break block0;
                        }
                        case 6: {
                            state = 10;
                            break block0;
                        }
                        case 9: {
                            state = 11;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + state));
                    break;
                }
                default: {
                    Log.log("INTERNAL ERROR untrapped parse state " + state);
                }
            }
            if (state == 10) break;
            c = this.getNextChar();
        }
        return blk;
    }

    private int getCharType(char c) {
        int type = 1;
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                type = 2;
                break;
            }
            case '\"': {
                type = 4;
                break;
            }
            case '\'': {
                type = 3;
                break;
            }
            case '&': {
                type = 7;
                break;
            }
            case '<': {
                type = 5;
                break;
            }
            case '>': {
                type = 6;
                break;
            }
            case '?': {
                type = 9;
                break;
            }
            case '/': {
                type = 12;
                break;
            }
            case '=': {
                type = 8;
                break;
            }
            case '[': {
                type = 10;
                break;
            }
            case ']': {
                type = 11;
                break;
            }
            case '-': {
                type = 14;
                break;
            }
            case '\\': {
                type = 13;
            }
        }
        return type;
    }

    public String makeValidXML(char c) {
        String res = StaticUtils.makeValidXML(c);
        if (res.length() == 1 && this.entityFilter != null) {
            return this.entityFilter.convertToEntity(c);
        }
        return res;
    }

    public String makeValidXML(String plaintext) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < plaintext.length(); ++i) {
            char c = plaintext.charAt(i);
            out.append(this.makeValidXML(c));
        }
        return out.toString();
    }

    public List<XMLBlock> closeBlock(XMLBlock block) throws TranslationException {
        return this.closeBlock(block, false);
    }

    public List<XMLBlock> closeBlock(XMLBlock block, boolean includeTerminationBlock) throws TranslationException {
        ArrayList<XMLBlock> lst = new ArrayList<XMLBlock>();
        if (block == null) {
            return lst;
        }
        if (block.isStandalone()) {
            return lst;
        }
        int depth = 0;
        while (true) {
            XMLBlock blk;
            if ((blk = this.getNextBlock()) == null) {
                throw new TranslationException(OStrings.getString("XSR_ERROR_END_OF_STREAM"));
            }
            if (blk.isTag() && blk.getTagName().equals(block.getTagName())) {
                if (blk.isClose()) {
                    if (depth == 0) {
                        if (!includeTerminationBlock) break;
                        lst.add(blk);
                        break;
                    }
                    --depth;
                } else {
                    ++depth;
                }
                lst.add(blk);
                continue;
            }
            lst.add(blk);
        }
        if (lst.size() == 0) {
            return null;
        }
        return lst;
    }

    public XMLBlock advanceToTag(String tagname) throws TranslationException {
        XMLBlock blk;
        while (!((blk = this.getNextBlock()) == null || blk.isTag() && blk.getTagName().equals(tagname))) {
        }
        return blk;
    }

    private char getEscChar() throws TranslationException {
        this.clearCache();
        char c = this.getNextCharCache();
        String val = "";
        boolean hex = false;
        if (c == '#') {
            c = this.getNextCharCache();
            if (c == 'x' || c == 'X') {
                c = this.getNextCharCache();
                hex = true;
            }
        } else if (c == ' ') {
            this.revertToCached();
            return '\u0000';
        }
        int ctr = 0;
        while (c != ';') {
            val = val + c;
            if (c == '\u0000') {
                throw new TranslationException(OStrings.getString("XSR_ERROR_UNTERMINATED_ESCAPE_CHAR"));
            }
            c = this.getNextCharCache();
            if (ctr++ <= 13) continue;
            this.revertToCached();
            return '\u0000';
        }
        this.clearCache();
        if (val.equals("amp")) {
            return '&';
        }
        if (val.equals("lt")) {
            return '<';
        }
        if (val.equals("gt")) {
            return '>';
        }
        if (val.equals("apos")) {
            return '\'';
        }
        if (val.equals("quot")) {
            return '\"';
        }
        if (this.entityFilter != null) {
            return this.entityFilter.convertToSymbol(val);
        }
        for (int i = 0; i < val.length(); ++i) {
            char b = val.charAt(i);
            if (hex) {
                c = (char)(c * 16);
                if (b >= '0' && b <= '9') {
                    c = (char)(c + (b - 48));
                    continue;
                }
                if (b >= 'A' && b <= 'F') {
                    c = (char)(c + 10);
                    c = (char)(c + (b - 65));
                    continue;
                }
                if (b >= 'a' && b <= 'f') {
                    c = (char)(c + 10);
                    c = (char)(c + (b - 97));
                    continue;
                }
                throw new TranslationException(StaticUtils.format(OStrings.getString("XSR_ERROR_BAD_BINARY_CHAR"), val));
            }
            c = (char)(c * 10);
            if (b >= '0' && b <= '9') {
                c = (char)(c + (b - 48));
                continue;
            }
            throw new TranslationException(StaticUtils.format(OStrings.getString("XSR_ERROR_BAD_DECIMAL_CHAR"), val));
        }
        return c;
    }

    public XMLBlock getHeadBlock() {
        return this.m_headBlock;
    }

    public void close() throws IOException {
        this.m_bufferedReader.close();
    }
}

