/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.regex.Pattern;

public class Token {
    private int hash;
    private static Pattern AMP = Pattern.compile("\\&");
    private int length;
    private int offset;

    public boolean equals(Object other) {
        return this == other || other instanceof Token && this.hash == ((Token)other).hash;
    }

    public int hashCode() {
        return this.hash;
    }

    private final String stripAmpersand(String s) {
        return AMP.matcher(s).replaceAll("");
    }

    public Token(String _text, int _offset) {
        this(_text, _offset, _text.length());
    }

    public Token(String _text, int _offset, int _length) {
        this.length = _length;
        this.hash = _text == null ? -1 : this.stripAmpersand(_text).hashCode();
        this.offset = _offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final String toString() {
        return this.hash + "@" + this.offset;
    }

    public String getTextFromString(String input) {
        return input.substring(this.offset, this.length + this.offset);
    }
}

