/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TMXDateParser {
    private static DateFormat tmxDateFormat = TMXDateParser.initializeTMXDateFormat();

    private static DateFormat initializeTMXDateFormat() {
        SimpleDateFormat tmxDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        tmxDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        return tmxDateFormat;
    }

    public static Date parse(String tmxDate) throws ParseException {
        if (tmxDate == null || tmxDate.length() != 16) {
            int offset = 0;
            if (tmxDate != null) {
                offset = tmxDate.length() < 16 ? tmxDate.length() : 16;
            }
            throw new ParseException("date '" + tmxDate + "' is null or not equal to YYYYMMDDThhmmssZ", offset);
        }
        return tmxDateFormat.parse(tmxDate);
    }

    public static String getTMXDate(Date date) {
        return tmxDateFormat.format(date);
    }

    public static String getTMXDate(long date) {
        return tmxDateFormat.format(new Date(date));
    }
}

