/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;

public class LinebreakPreservingReader
extends Reader {
    private PushbackReader in;
    private StringBuffer linebreak = new StringBuffer(2);

    private LinebreakPreservingReader() {
    }

    public LinebreakPreservingReader(Reader in) {
        this.in = new PushbackReader(in);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public String getLinebreak() {
        return this.linebreak.toString();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.in.mark(readAheadLimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(char[] cbuf) throws IOException {
        return this.in.read(cbuf);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.in.read(cbuf, off, len);
    }

    public String readLine() throws IOException {
        this.linebreak.setLength(0);
        StringBuffer line = new StringBuffer(1024);
        int chr = this.in.read();
        if (chr == -1) {
            return null;
        }
        while (chr != -1 && !this.isLinebreakCharacter(chr)) {
            line.append((char)chr);
            chr = this.in.read();
        }
        if (this.isLinebreakCharacter(chr)) {
            this.linebreak.append((char)chr);
            if ((char)chr == '\r') {
                chr = this.in.read();
                if ((char)chr == '\n') {
                    this.linebreak.append((char)chr);
                } else {
                    this.in.unread(chr);
                }
            }
        }
        return line.toString();
    }

    public boolean ready() throws IOException {
        return this.in.ready();
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    private final boolean isLinebreakCharacter(int chr) {
        return (char)chr == '\n' || (char)chr == '\r';
    }

    public void printLinebreak(PrintStream out) {
        out.print("Break: ");
        for (int i = 0; i < this.linebreak.length(); ++i) {
            char c = this.linebreak.charAt(i);
            if (c == '\r') {
                out.print("\\r");
                continue;
            }
            if (c == '\n') {
                out.print("\\n");
                continue;
            }
            out.print(c);
        }
        out.println();
    }
}

